/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.fluss.fs.FileStatus;
import org.apache.fluss.fs.FileSystem;
import org.apache.fluss.fs.FsPath;
import org.apache.fluss.fs.hdfs.HadoopDataInputStream;
import org.apache.fluss.fs.hdfs.HadoopDataOutputStream;
import org.apache.fluss.fs.hdfs.HadoopFileStatus;
import org.apache.fluss.utils.Preconditions;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

public abstract class HadoopFileSystem
extends FileSystem {
    private final org.apache.hadoop.fs.FileSystem fs;

    public HadoopFileSystem(org.apache.hadoop.fs.FileSystem hadoopFileSystem) {
        this.fs = (org.apache.hadoop.fs.FileSystem)Preconditions.checkNotNull((Object)hadoopFileSystem, (String)"hadoopFileSystem");
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public FileStatus getFileStatus(FsPath f) throws IOException {
        org.apache.hadoop.fs.FileStatus status = this.fs.getFileStatus(HadoopFileSystem.toHadoopPath(f));
        return HadoopFileStatus.fromHadoopStatus(status);
    }

    public HadoopDataInputStream open(FsPath f) throws IOException {
        Path path = HadoopFileSystem.toHadoopPath(f);
        FSDataInputStream fdis = this.fs.open(path);
        return new HadoopDataInputStream(fdis);
    }

    public HadoopDataOutputStream create(FsPath f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream fsDataOutputStream = this.fs.create(HadoopFileSystem.toHadoopPath(f), overwrite == FileSystem.WriteMode.OVERWRITE);
        return new HadoopDataOutputStream(fsDataOutputStream);
    }

    public boolean delete(FsPath f, boolean recursive) throws IOException {
        return this.fs.delete(HadoopFileSystem.toHadoopPath(f), recursive);
    }

    public boolean exists(FsPath f) throws IOException {
        return this.fs.exists(HadoopFileSystem.toHadoopPath(f));
    }

    public FileStatus[] listStatus(FsPath f) throws IOException {
        org.apache.hadoop.fs.FileStatus[] hadoopFiles = this.fs.listStatus(HadoopFileSystem.toHadoopPath(f));
        FileStatus[] files = new FileStatus[hadoopFiles.length];
        for (int i = 0; i < files.length; ++i) {
            files[i] = HadoopFileStatus.fromHadoopStatus(hadoopFiles[i]);
        }
        return files;
    }

    public boolean mkdirs(FsPath f) throws IOException {
        return this.fs.mkdirs(HadoopFileSystem.toHadoopPath(f));
    }

    public boolean rename(FsPath src, FsPath dst) throws IOException {
        return this.fs.rename(HadoopFileSystem.toHadoopPath(src), HadoopFileSystem.toHadoopPath(dst));
    }

    public static Path toHadoopPath(FsPath path) {
        return new Path(path.toUri());
    }
}

