/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.s3.token;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import org.apache.fluss.fs.s3.token.S3DelegationTokenReceiver;
import org.apache.fluss.fs.token.Credentials;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicTemporaryAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = DynamicTemporaryAWSCredentialsProvider.class.getName();
    public static final String COMPONENT = "Dynamic session credentials for Fluss";
    private static final Logger LOG = LoggerFactory.getLogger(DynamicTemporaryAWSCredentialsProvider.class);

    @Override
    public AWSCredentials getCredentials() {
        Credentials credentials = S3DelegationTokenReceiver.getCredentials();
        if (credentials == null) {
            throw new NoAwsCredentialsException(COMPONENT);
        }
        LOG.debug("Providing session credentials");
        return new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSecurityToken());
    }

    @Override
    public void refresh() {
    }
}

