/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkBaseException;
import com.amazonaws.SdkClientException;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.RegionUtils;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientV2Builder;
import com.amazonaws.services.s3.S3ClientOptions;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.CryptoConfigurationV2;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.CryptoRangeGetMode;
import com.amazonaws.services.s3.model.KMSEncryptionMaterialsProvider;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.RuntimeHttpUtils;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.S3ClientFactory;
import org.apache.hadoop.fs.s3a.statistics.impl.AwsStatisticsCollector;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DefaultS3ClientFactory
extends Configured
implements S3ClientFactory {
    private static final String S3_SERVICE_NAME = "s3";
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultS3ClientFactory.class);
    private static final LogExactlyOnce WARN_OF_DEFAULT_REGION_CHAIN = new LogExactlyOnce(LOG);
    private static final String SDK_REGION_CHAIN_IN_USE = "S3A filesystem client is using the SDK region resolution chain.";
    private static final LogExactlyOnce IGNORE_CSE_WARN = new LogExactlyOnce(LOG);
    private String bucket;

    @Override
    public AmazonS3 createS3Client(URI uri, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        Configuration conf = this.getConf();
        this.bucket = uri.getHost();
        ClientConfiguration awsConf = S3AUtils.createAwsConf(conf, this.bucket, "S3");
        parameters.getHeaders().forEach((h2, v) -> awsConf.addHeader((String)h2, (String)v));
        awsConf.setUseThrottleRetries(conf.getBoolean("fs.s3a.experimental.aws.s3.throttling", true));
        if (!StringUtils.isEmpty(parameters.getUserAgentSuffix())) {
            awsConf.setUserAgentSuffix(parameters.getUserAgentSuffix());
        }
        S3AEncryptionMethods encryptionMethods = S3AUtils.getEncryptionAlgorithm(this.bucket, conf);
        try {
            if (S3AEncryptionMethods.CSE_KMS.getMethod().equals(encryptionMethods.getMethod())) {
                return this.buildAmazonS3EncryptionClient(awsConf, parameters);
            }
            return this.buildAmazonS3Client(awsConf, parameters);
        }
        catch (SdkClientException e) {
            throw S3AUtils.translateException("creating AWS S3 client", uri.toString(), (SdkBaseException)e);
        }
    }

    protected AmazonS3 buildAmazonS3EncryptionClient(ClientConfiguration awsConf, S3ClientFactory.S3ClientCreationParameters parameters) throws IOException {
        AmazonS3EncryptionClientV2Builder builder = new AmazonS3EncryptionClientV2Builder();
        Configuration conf = this.getConf();
        String kmsKeyId = S3AUtils.getS3EncryptionKey(this.bucket, conf, true);
        Preconditions.checkArgument(!StringUtils.isBlank(kmsKeyId), "CSE-KMS method requires KMS key ID. Use fs.s3a.encryption.key property to set it. ");
        KMSEncryptionMaterialsProvider materialsProvider = new KMSEncryptionMaterialsProvider(kmsKeyId);
        builder.withEncryptionMaterialsProvider(materialsProvider);
        this.configureBasicParams(builder, awsConf, parameters);
        AwsClientBuilder.EndpointConfiguration epr = DefaultS3ClientFactory.createEndpointConfiguration(parameters.getEndpoint(), awsConf, this.getConf().getTrimmed("fs.s3a.endpoint.region"));
        this.configureEndpoint(builder, epr);
        CryptoConfigurationV2 cryptoConfigurationV2 = new CryptoConfigurationV2(CryptoMode.AuthenticatedEncryption).withRangeGetMode(CryptoRangeGetMode.ALL);
        if (epr != null) {
            cryptoConfigurationV2.withAwsKmsRegion(RegionUtils.getRegion(epr.getSigningRegion()));
            LOG.debug("KMS region used: {}", (Object)cryptoConfigurationV2.getAwsKmsRegion());
        }
        builder.withCryptoConfiguration(cryptoConfigurationV2);
        AmazonS3 client = (AmazonS3)builder.build();
        IGNORE_CSE_WARN.info("S3 client-side encryption enabled: Ignore S3-CSE Warnings.", new Object[0]);
        return client;
    }

    protected AmazonS3 buildAmazonS3Client(ClientConfiguration awsConf, S3ClientFactory.S3ClientCreationParameters parameters) {
        AmazonS3ClientBuilder b = AmazonS3Client.builder();
        this.configureBasicParams(b, awsConf, parameters);
        AwsClientBuilder.EndpointConfiguration epr = DefaultS3ClientFactory.createEndpointConfiguration(parameters.getEndpoint(), awsConf, this.getConf().getTrimmed("fs.s3a.endpoint.region"));
        this.configureEndpoint(b, epr);
        AmazonS3 client = (AmazonS3)b.build();
        return client;
    }

    private void configureBasicParams(AmazonS3Builder builder, ClientConfiguration awsConf, S3ClientFactory.S3ClientCreationParameters parameters) {
        builder.withCredentials(parameters.getCredentialSet());
        builder.withClientConfiguration(awsConf);
        builder.withPathStyleAccessEnabled(parameters.isPathStyleAccess());
        if (parameters.getMetrics() != null) {
            builder.withMetricsCollector(new AwsStatisticsCollector(parameters.getMetrics()));
        }
        if (parameters.getRequestHandlers() != null) {
            builder.withRequestHandlers(parameters.getRequestHandlers().toArray(new RequestHandler2[0]));
        }
        if (parameters.getMonitoringListener() != null) {
            builder.withMonitoringListener(parameters.getMonitoringListener());
        }
    }

    private void configureEndpoint(AmazonS3Builder builder, AwsClientBuilder.EndpointConfiguration epr) {
        if (epr != null) {
            builder.withEndpointConfiguration(epr);
        } else {
            builder.withForceGlobalBucketAccessEnabled(true);
            String region = this.getConf().getTrimmed("fs.s3a.endpoint.region", "us-east-1");
            LOG.debug("fs.s3a.endpoint.region=\"{}\"", (Object)region);
            if (!region.isEmpty()) {
                LOG.debug("Using default endpoint; setting region to {}", (Object)region);
                builder.setRegion(region);
            } else {
                WARN_OF_DEFAULT_REGION_CHAIN.warn(SDK_REGION_CHAIN_IN_USE, new Object[0]);
                LOG.debug(SDK_REGION_CHAIN_IN_USE);
            }
        }
    }

    protected static AmazonS3 configureAmazonS3Client(AmazonS3 s3, String endPoint, boolean pathStyleAccess) throws IllegalArgumentException {
        if (!endPoint.isEmpty()) {
            try {
                s3.setEndpoint(endPoint);
            }
            catch (IllegalArgumentException e) {
                String msg = "Incorrect endpoint: " + e.getMessage();
                LOG.error(msg);
                throw new IllegalArgumentException(msg, e);
            }
        }
        if (pathStyleAccess) {
            LOG.debug("Enabling path style access!");
            s3.setS3ClientOptions(S3ClientOptions.builder().setPathStyleAccess(true).build());
        }
        return s3;
    }

    @VisibleForTesting
    public static AwsClientBuilder.EndpointConfiguration createEndpointConfiguration(String endpoint, ClientConfiguration awsConf, String awsRegion) {
        LOG.debug("Creating endpoint configuration for \"{}\"", (Object)endpoint);
        if (endpoint == null || endpoint.isEmpty()) {
            LOG.debug("Using default endpoint -no need to generate a configuration");
            return null;
        }
        URI epr = RuntimeHttpUtils.toUri(endpoint, awsConf);
        LOG.debug("Endpoint URI = {}", (Object)epr);
        String region = awsRegion;
        if (StringUtils.isBlank(region)) {
            if (!ServiceUtils.isS3USStandardEndpoint(endpoint)) {
                LOG.debug("Endpoint {} is not the default; parsing", (Object)epr);
                region = AwsHostNameUtils.parseRegion(epr.getHost(), S3_SERVICE_NAME);
            } else {
                LOG.debug("Endpoint {} is the standard one; declare region as null", (Object)epr);
                region = null;
            }
        }
        LOG.debug("Region for endpoint {}, URI {} is determined as {}", new Object[]{endpoint, epr, region});
        return new AwsClientBuilder.EndpointConfiguration(endpoint, region);
    }
}

