/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CannedAccessControlList;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecretOperations;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.impl.HeaderProcessing;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFactoryImpl
implements RequestFactory {
    public static final Logger LOG = LoggerFactory.getLogger(RequestFactoryImpl.class);
    private final String bucket;
    private EncryptionSecrets encryptionSecrets;
    private final CannedAccessControlList cannedACL;
    private final long multipartPartCountLimit;
    private final boolean requesterPays;
    private final PrepareRequest requestPreparer;

    protected RequestFactoryImpl(RequestFactoryBuilder builder) {
        this.bucket = builder.bucket;
        this.cannedACL = builder.cannedACL;
        this.encryptionSecrets = builder.encryptionSecrets;
        this.multipartPartCountLimit = builder.multipartPartCountLimit;
        this.requesterPays = builder.requesterPays;
        this.requestPreparer = builder.requestPreparer;
    }

    private <T extends AmazonWebServiceRequest> T prepareRequest(T t) {
        return this.requestPreparer != null ? this.requestPreparer.prepareRequest(t) : t;
    }

    @Override
    public CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    protected String getBucket() {
        return this.bucket;
    }

    @Override
    public Optional<SSEAwsKeyManagementParams> generateSSEAwsKeyParams() {
        return EncryptionSecretOperations.createSSEAwsKeyManagementParams(this.encryptionSecrets);
    }

    @Override
    public Optional<SSECustomerKey> generateSSECustomerKey() {
        return EncryptionSecretOperations.createSSECustomerKey(this.encryptionSecrets);
    }

    @Override
    public S3AEncryptionMethods getServerSideEncryptionAlgorithm() {
        return this.encryptionSecrets.getEncryptionMethod();
    }

    protected void setOptionalUploadPartRequestParameters(UploadPartRequest request) {
        this.generateSSECustomerKey().ifPresent(request::setSSECustomerKey);
    }

    protected void setOptionalGetObjectMetadataParameters(GetObjectMetadataRequest request) {
        this.generateSSECustomerKey().ifPresent(request::setSSECustomerKey);
    }

    protected void setOptionalMultipartUploadRequestParameters(InitiateMultipartUploadRequest request) {
        this.generateSSEAwsKeyParams().ifPresent(request::setSSEAwsKeyManagementParams);
        this.generateSSECustomerKey().ifPresent(request::setSSECustomerKey);
    }

    protected void setOptionalPutRequestParameters(PutObjectRequest request) {
        this.generateSSEAwsKeyParams().ifPresent(request::setSSEAwsKeyManagementParams);
        this.generateSSECustomerKey().ifPresent(request::setSSECustomerKey);
    }

    protected void setOptionalObjectMetadata(ObjectMetadata metadata) {
        S3AEncryptionMethods algorithm = this.getServerSideEncryptionAlgorithm();
        if (S3AEncryptionMethods.SSE_S3 == algorithm) {
            metadata.setSSEAlgorithm(algorithm.getMethod());
        }
    }

    @Override
    public ObjectMetadata newObjectMetadata(long length) {
        ObjectMetadata om = new ObjectMetadata();
        this.setOptionalObjectMetadata(om);
        if (length >= 0L) {
            om.setContentLength(length);
        }
        return om;
    }

    @Override
    public CopyObjectRequest newCopyObjectRequest(String srcKey, String dstKey, ObjectMetadata srcom) {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.getBucket(), srcKey, this.getBucket(), dstKey);
        ObjectMetadata dstom = this.newObjectMetadata(srcom.getContentLength());
        HeaderProcessing.cloneObjectMetadata(srcom, dstom);
        this.setOptionalObjectMetadata(dstom);
        this.copyEncryptionParameters(srcom, copyObjectRequest);
        copyObjectRequest.setCannedAccessControlList(this.cannedACL);
        copyObjectRequest.setNewObjectMetadata(dstom);
        Optional.ofNullable(srcom.getStorageClass()).ifPresent(copyObjectRequest::setStorageClass);
        return this.prepareRequest(copyObjectRequest);
    }

    protected void copyEncryptionParameters(ObjectMetadata srcom, CopyObjectRequest copyObjectRequest) {
        String sourceKMSId = srcom.getSSEAwsKmsKeyId();
        if (StringUtils.isNotEmpty(sourceKMSId)) {
            LOG.debug("Propagating SSE-KMS settings from source {}", (Object)sourceKMSId);
            copyObjectRequest.setSSEAwsKeyManagementParams(new SSEAwsKeyManagementParams(sourceKMSId));
        }
        switch (this.getServerSideEncryptionAlgorithm()) {
            case SSE_S3: {
                break;
            }
            case SSE_C: {
                this.generateSSECustomerKey().ifPresent(customerKey -> {
                    copyObjectRequest.setSourceSSECustomerKey((SSECustomerKey)customerKey);
                    copyObjectRequest.setDestinationSSECustomerKey((SSECustomerKey)customerKey);
                });
                break;
            }
            case SSE_KMS: {
                this.generateSSEAwsKeyParams().ifPresent(copyObjectRequest::setSSEAwsKeyManagementParams);
                break;
            }
        }
    }

    @Override
    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, File srcfile) {
        Preconditions.checkNotNull(srcfile);
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucket(), key, srcfile);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        putObjectRequest.setMetadata(metadata);
        return this.prepareRequest(putObjectRequest);
    }

    @Override
    public PutObjectRequest newPutObjectRequest(String key, ObjectMetadata metadata, InputStream inputStream) {
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkArgument(StringUtils.isNotEmpty(key), "Null/empty key");
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getBucket(), key, inputStream, metadata);
        this.setOptionalPutRequestParameters(putObjectRequest);
        putObjectRequest.setCannedAcl(this.cannedACL);
        return this.prepareRequest(putObjectRequest);
    }

    @Override
    public PutObjectRequest newDirectoryMarkerRequest(String directory) {
        String key = directory.endsWith("/") ? directory : directory + "/";
        InputStream im = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        ObjectMetadata md = this.newObjectMetadata(0L);
        md.setContentType("application/x-directory");
        PutObjectRequest putObjectRequest = this.newPutObjectRequest(key, md, im);
        return putObjectRequest;
    }

    @Override
    public ListMultipartUploadsRequest newListMultipartUploadsRequest(String prefix) {
        ListMultipartUploadsRequest request = new ListMultipartUploadsRequest(this.getBucket());
        if (prefix != null) {
            request.setPrefix(prefix);
        }
        return this.prepareRequest(request);
    }

    @Override
    public AbortMultipartUploadRequest newAbortMultipartUploadRequest(String destKey, String uploadId) {
        return this.prepareRequest(new AbortMultipartUploadRequest(this.getBucket(), destKey, uploadId));
    }

    @Override
    public InitiateMultipartUploadRequest newMultipartUploadRequest(String destKey) {
        InitiateMultipartUploadRequest initiateMPURequest = new InitiateMultipartUploadRequest(this.getBucket(), destKey, this.newObjectMetadata(-1L));
        initiateMPURequest.setCannedACL(this.getCannedACL());
        this.setOptionalMultipartUploadRequestParameters(initiateMPURequest);
        return this.prepareRequest(initiateMPURequest);
    }

    @Override
    public CompleteMultipartUploadRequest newCompleteMultipartUploadRequest(String destKey, String uploadId, List<PartETag> partETags) {
        return this.prepareRequest(new CompleteMultipartUploadRequest(this.bucket, destKey, uploadId, new ArrayList<PartETag>(partETags)));
    }

    @Override
    public GetObjectMetadataRequest newGetObjectMetadataRequest(String key) {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.getBucket(), key);
        this.setOptionalGetObjectMetadataParameters(request);
        return this.prepareRequest(request);
    }

    @Override
    public GetObjectRequest newGetObjectRequest(String key) {
        GetObjectRequest request = new GetObjectRequest(this.bucket, key);
        this.generateSSECustomerKey().ifPresent(request::setSSECustomerKey);
        return this.prepareRequest(request);
    }

    @Override
    public UploadPartRequest newUploadPartRequest(String destKey, String uploadId, int partNumber, int size, InputStream uploadStream, File sourceFile, long offset) throws PathIOException {
        Preconditions.checkNotNull(uploadId);
        Preconditions.checkArgument(uploadStream != null ^ sourceFile != null, "Data source");
        Preconditions.checkArgument(size >= 0, "Invalid partition size %s", size);
        Preconditions.checkArgument(partNumber > 0, "partNumber must be between 1 and %s inclusive, but is %s", 10000, partNumber);
        LOG.debug("Creating part upload request for {} #{} size {}", new Object[]{uploadId, partNumber, size});
        String pathErrorMsg = "Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ";
        if ((long)partNumber > this.multipartPartCountLimit) {
            throw new PathIOException(destKey, String.format("Number of parts in multipart upload exceeded. Current part count = %s, Part count limit = %s ", partNumber, this.multipartPartCountLimit));
        }
        UploadPartRequest request = new UploadPartRequest().withBucketName(this.getBucket()).withKey(destKey).withUploadId(uploadId).withPartNumber(partNumber).withPartSize(size);
        if (uploadStream != null) {
            request.setInputStream(uploadStream);
        } else {
            Preconditions.checkArgument(sourceFile.exists(), "Source file does not exist: %s", (Object)sourceFile);
            Preconditions.checkArgument(sourceFile.isFile(), "Source is not a file: %s", (Object)sourceFile);
            Preconditions.checkArgument(offset >= 0L, "Invalid offset %s", offset);
            long length = sourceFile.length();
            Preconditions.checkArgument(offset == 0L || offset < length, "Offset %s beyond length of file %s", offset, length);
            request.setFile(sourceFile);
            request.setFileOffset(offset);
        }
        this.setOptionalUploadPartRequestParameters(request);
        return this.prepareRequest(request);
    }

    @Override
    public SelectObjectContentRequest newSelectRequest(String key) {
        SelectObjectContentRequest request = new SelectObjectContentRequest();
        request.setBucketName(this.bucket);
        request.setKey(key);
        this.generateSSECustomerKey().ifPresent(request::setSSECustomerKey);
        return this.prepareRequest(request);
    }

    @Override
    public ListObjectsRequest newListObjectsV1Request(String key, String delimiter, int maxKeys) {
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(this.bucket).withMaxKeys(maxKeys).withPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        return this.prepareRequest(request);
    }

    @Override
    public ListNextBatchOfObjectsRequest newListNextBatchOfObjectsRequest(ObjectListing prev) {
        return this.prepareRequest(new ListNextBatchOfObjectsRequest(prev));
    }

    @Override
    public ListObjectsV2Request newListObjectsV2Request(String key, String delimiter, int maxKeys) {
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.bucket).withMaxKeys(maxKeys).withPrefix(key);
        if (delimiter != null) {
            request.setDelimiter(delimiter);
        }
        return this.prepareRequest(request);
    }

    @Override
    public DeleteObjectRequest newDeleteObjectRequest(String key) {
        return this.prepareRequest(new DeleteObjectRequest(this.bucket, key));
    }

    @Override
    public DeleteObjectsRequest newBulkDeleteRequest(List<DeleteObjectsRequest.KeyVersion> keysToDelete, boolean quiet) {
        return this.prepareRequest(new DeleteObjectsRequest(this.bucket).withKeys(keysToDelete).withQuiet(quiet));
    }

    @Override
    public void setEncryptionSecrets(EncryptionSecrets secrets) {
        this.encryptionSecrets = secrets;
    }

    public static RequestFactoryBuilder builder() {
        return new RequestFactoryBuilder();
    }

    @FunctionalInterface
    public static interface PrepareRequest {
        public <T extends AmazonWebServiceRequest> T prepareRequest(T var1);
    }

    public static final class RequestFactoryBuilder {
        private String bucket;
        private EncryptionSecrets encryptionSecrets = new EncryptionSecrets();
        private CannedAccessControlList cannedACL = null;
        private boolean requesterPays = false;
        private long multipartPartCountLimit = 10000L;
        private PrepareRequest requestPreparer;

        private RequestFactoryBuilder() {
        }

        public RequestFactory build() {
            return new RequestFactoryImpl(this);
        }

        public RequestFactoryBuilder withBucket(String value) {
            this.bucket = value;
            return this;
        }

        public RequestFactoryBuilder withEncryptionSecrets(EncryptionSecrets value) {
            this.encryptionSecrets = value;
            return this;
        }

        public RequestFactoryBuilder withCannedACL(CannedAccessControlList value) {
            this.cannedACL = value;
            return this;
        }

        public RequestFactoryBuilder withRequesterPays(boolean value) {
            this.requesterPays = value;
            return this;
        }

        public RequestFactoryBuilder withMultipartPartCountLimit(long value) {
            this.multipartPartCountLimit = value;
            return this;
        }

        public RequestFactoryBuilder withRequestPreparer(PrepareRequest value) {
            this.requestPreparer = value;
            return this;
        }
    }
}

