/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.amazonaws.SdkBaseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.s3a.s3guard.BulkOperationState;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.apache.hadoop.fs.s3a.s3guard.PathOrderComparators;
import org.apache.hadoop.fs.s3a.s3guard.RenameTracker;
import org.apache.hadoop.fs.s3a.s3guard.S3Guard;
import org.apache.hadoop.util.DurationInfo;

public class DelayedUpdateRenameTracker
extends RenameTracker {
    private final MetadataStore metadataStore;
    private final Collection<Path> sourcePaths = new HashSet<Path>();
    private final List<PathMetadata> destMetas = new ArrayList<PathMetadata>();
    private final List<Path> deletedPaths = new ArrayList<Path>();

    public DelayedUpdateRenameTracker(StoreContext storeContext, MetadataStore metadataStore, Path sourceRoot, Path dest, BulkOperationState operationState) {
        super("DelayedUpdateRenameTracker", storeContext, metadataStore, sourceRoot, dest, operationState);
        this.metadataStore = storeContext.getMetadataStore();
    }

    @Override
    public synchronized void fileCopied(Path sourcePath, S3ObjectAttributes sourceAttributes, S3ObjectAttributes destAttributes, Path destPath, long blockSize, boolean addAncestors) throws IOException {
        S3Guard.addMoveFile(this.metadataStore, this.sourcePaths, this.destMetas, sourcePath, destPath, sourceAttributes.getLen(), blockSize, this.getOwner(), destAttributes.getETag(), destAttributes.getVersionId());
        if (addAncestors) {
            S3Guard.addMoveAncestors(this.metadataStore, this.sourcePaths, this.destMetas, this.getSourceRoot(), sourcePath, destPath, this.getOwner());
        }
    }

    @Override
    public synchronized void directoryMarkerCopied(Path sourcePath, Path destPath, boolean addAncestors) throws IOException {
        S3Guard.addMoveDir(this.metadataStore, this.sourcePaths, this.destMetas, sourcePath, destPath, this.getOwner());
        if (addAncestors) {
            S3Guard.addMoveAncestors(this.metadataStore, this.sourcePaths, this.destMetas, this.getSourceRoot(), sourcePath, destPath, this.getOwner());
        }
    }

    @Override
    public synchronized void moveSourceDirectory() throws IOException {
        if (!this.sourcePaths.contains(this.getSourceRoot())) {
            S3Guard.addMoveDir(this.metadataStore, this.sourcePaths, this.destMetas, this.getSourceRoot(), this.getDest(), this.getOwner());
        }
    }

    @Override
    public synchronized void sourceObjectsDeleted(Collection<Path> paths) throws IOException {
        this.deletedPaths.addAll(paths);
    }

    @Override
    public void completeRename() throws IOException {
        this.metadataStore.move(this.sourcePaths, this.destMetas, this.getOperationState());
        super.completeRename();
    }

    @Override
    public IOException renameFailed(Exception ex) {
        LOG.warn("Rename has failed; updating s3guard with destination state");
        try (DurationInfo ignored = new DurationInfo(LOG, "Cleaning up deleted paths", new Object[0]);){
            this.metadataStore.move(new ArrayList<Path>(0), this.destMetas, this.getOperationState());
            for (Path deletedPath : this.deletedPaths) {
                this.metadataStore.delete(deletedPath, this.getOperationState());
            }
            this.deleteParentPaths();
        }
        catch (SdkBaseException | IOException e) {
            LOG.warn("Ignoring error raised in AWS SDK ", (Throwable)e);
        }
        return super.renameFailed(ex);
    }

    private void deleteParentPaths() throws IOException {
        HashSet<Path> parentPaths = new HashSet<Path>();
        for (Path deletedPath : this.deletedPaths) {
            Path parent = deletedPath.getParent();
            if (parent.equals(this.getSourceRoot())) continue;
            parentPaths.add(parent);
        }
        ArrayList<Path> parents = new ArrayList<Path>(parentPaths);
        parents.sort(PathOrderComparators.TOPMOST_PATH_LAST);
        for (Path parent : parents) {
            PathMetadata md = this.metadataStore.get(parent, true);
            if (md == null || md.isEmptyDirectory() != Tristate.TRUE) continue;
            this.metadataStore.delete(parent, this.getOperationState());
        }
    }
}

