/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.spdy;

import java.util.zip.Deflater;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.spdy.SpdyCodecUtil;
import org.apache.flink.shaded.hadoop2.org.jboss.netty.handler.codec.spdy.SpdyHeaderBlockCompressor;

class SpdyHeaderBlockZlibCompressor
extends SpdyHeaderBlockCompressor {
    private final byte[] out = new byte[8192];
    private final Deflater compressor;

    public SpdyHeaderBlockZlibCompressor(int version, int compressionLevel) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("compressionLevel: " + compressionLevel + " (expected: 0-9)");
        }
        this.compressor = new Deflater(compressionLevel);
        if (version < 3) {
            this.compressor.setDictionary(SpdyCodecUtil.SPDY2_DICT);
        } else {
            this.compressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
        }
    }

    public void setInput(ChannelBuffer decompressed) {
        byte[] in = new byte[decompressed.readableBytes()];
        decompressed.readBytes(in);
        this.compressor.setInput(in);
    }

    public void encode(ChannelBuffer compressed) {
        int numBytes = this.out.length;
        while (numBytes == this.out.length) {
            numBytes = this.compressor.deflate(this.out, 0, this.out.length, 2);
            compressed.writeBytes(this.out, 0, numBytes);
        }
    }

    public void end() {
        this.compressor.end();
    }
}

