/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;

@InterfaceAudience.Private
public class BlockPlacementPolicyRackFaultTolerant
extends BlockPlacementPolicyDefault {
    @Override
    protected int[] getMaxNodesPerRack(int numOfChosen, int numOfReplicas) {
        int numOfRacks;
        int totalNumOfReplicas = numOfChosen + numOfReplicas;
        int clusterSize = this.clusterMap.getNumOfLeaves();
        if (totalNumOfReplicas > clusterSize) {
            numOfReplicas -= totalNumOfReplicas - clusterSize;
            totalNumOfReplicas = clusterSize;
        }
        if ((numOfRacks = this.clusterMap.getNumOfRacks()) == 1 || totalNumOfReplicas <= 1) {
            return new int[]{numOfReplicas, totalNumOfReplicas};
        }
        if (totalNumOfReplicas < numOfRacks) {
            return new int[]{numOfReplicas, 1};
        }
        int maxNodesPerRack = (totalNumOfReplicas - 1) / numOfRacks + 1;
        return new int[]{numOfReplicas, maxNodesPerRack};
    }

    @Override
    protected Node chooseTargetInOrder(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, boolean newBlock, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        int numOfRacks;
        int totalReplicaExpected = results.size() + numOfReplicas;
        if (totalReplicaExpected < (numOfRacks = this.clusterMap.getNumOfRacks()) || totalReplicaExpected % numOfRacks == 0) {
            writer = this.chooseOnce(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
            return writer;
        }
        assert (totalReplicaExpected > (maxNodesPerRack - 1) * numOfRacks);
        HashMap<String, Integer> rackCounts = new HashMap<String, Integer>();
        for (DatanodeStorageInfo dsInfo : results) {
            String rack = dsInfo.getDatanodeDescriptor().getNetworkLocation();
            Integer count = (Integer)rackCounts.get(rack);
            if (count != null) {
                rackCounts.put(rack, count + 1);
                continue;
            }
            rackCounts.put(rack, 1);
        }
        int excess = 0;
        Iterator<Object> i$ = rackCounts.values().iterator();
        while (i$.hasNext()) {
            int count = (Integer)i$.next();
            if (count <= maxNodesPerRack - 1) continue;
            excess += count - (maxNodesPerRack - 1);
        }
        numOfReplicas = Math.min(totalReplicaExpected - results.size(), (maxNodesPerRack - 1) * numOfRacks - (results.size() - excess));
        writer = this.chooseOnce(numOfReplicas, writer, new HashSet<Node>(excludedNodes), blocksize, maxNodesPerRack - 1, results, avoidStaleNodes, storageTypes);
        for (DatanodeStorageInfo resultStorage : results) {
            this.addToExcludedNodes(resultStorage.getDatanodeDescriptor(), excludedNodes);
        }
        numOfReplicas = totalReplicaExpected - results.size();
        this.chooseOnce(numOfReplicas, writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        return writer;
    }

    private Node chooseOnce(int numOfReplicas, Node writer, Set<Node> excludedNodes, long blocksize, int maxNodesPerRack, List<DatanodeStorageInfo> results, boolean avoidStaleNodes, EnumMap<StorageType, Integer> storageTypes) throws BlockPlacementPolicy.NotEnoughReplicasException {
        if (numOfReplicas == 0) {
            return writer;
        }
        writer = this.chooseLocalStorage(writer, excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes, true).getDatanodeDescriptor();
        if (--numOfReplicas == 0) {
            return writer;
        }
        this.chooseRandom(numOfReplicas, "", excludedNodes, blocksize, maxNodesPerRack, results, avoidStaleNodes, storageTypes);
        return writer;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(DatanodeInfo[] locs, int numberOfReplicas) {
        if (locs == null) {
            locs = DatanodeDescriptor.EMPTY_ARRAY;
        }
        if (!this.clusterMap.hasClusterEverBeenMultiRack()) {
            return new BlockPlacementStatusDefault(1, 1);
        }
        TreeSet<String> racks = new TreeSet<String>();
        for (DatanodeInfo dn : locs) {
            racks.add(dn.getNetworkLocation());
        }
        return new BlockPlacementStatusDefault(racks.size(), numberOfReplicas);
    }

    @Override
    protected Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, Map<String, List<DatanodeStorageInfo>> rackMap) {
        return moreThanOne.isEmpty() ? exactlyOne : moreThanOne;
    }
}

