/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.net.InetSocketAddress;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.hadoop2.io.netty.channel.ChannelPipeline;
import org.apache.flink.shaded.hadoop2.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.hadoop2.io.netty.handler.codec.http.HttpRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.web.SimpleHttpProxyHandler;
import org.apache.hadoop.hdfs.server.datanode.web.webhdfs.WebHdfsHandler;

class URLDispatcher
extends SimpleChannelInboundHandler<HttpRequest> {
    private final InetSocketAddress proxyHost;
    private final Configuration conf;
    private final Configuration confForCreate;

    URLDispatcher(InetSocketAddress proxyHost, Configuration conf, Configuration confForCreate) {
        this.proxyHost = proxyHost;
        this.conf = conf;
        this.confForCreate = confForCreate;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        String uri = req.getUri();
        ChannelPipeline p = ctx.pipeline();
        if (uri.startsWith("/webhdfs/v1")) {
            WebHdfsHandler h = new WebHdfsHandler(this.conf, this.confForCreate);
            p.replace(this, WebHdfsHandler.class.getSimpleName(), (ChannelHandler)h);
            h.channelRead0(ctx, req);
        } else {
            SimpleHttpProxyHandler h = new SimpleHttpProxyHandler(this.proxyHost);
            p.replace(this, SimpleHttpProxyHandler.class.getSimpleName(), (ChannelHandler)h);
            h.channelRead0(ctx, req);
        }
    }
}

