/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.model;

import com.aliyun.oss.ClientException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tag
implements Serializable {
    private String key;
    private String value;
    private final String KEY_REGEX = "^(?=^.{1,128}$)[a-zA-Z0-9+=\\-._: /]{1,128}";
    private final String VALUE_REGEX = "^(?=^.{0,256}$)[a-zA-Z0-9+=\\-._: /]{0,256}";

    public Tag(String key, String value) {
        this.setKey(key);
        this.setValue(value);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) throws ClientException {
        Pattern pattern = Pattern.compile("^(?=^.{1,128}$)[a-zA-Z0-9+=\\-._: /]{1,128}");
        Matcher matcher = pattern.matcher(key);
        if (!matcher.matches()) {
            throw new ClientException("your key is invalid", "InvalidArgument", null);
        }
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws ClientException {
        Pattern pattern = Pattern.compile("^(?=^.{0,256}$)[a-zA-Z0-9+=\\-._: /]{0,256}");
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            throw new ClientException("your value is invalid", "InvalidArgument", null);
        }
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.key != null ? !this.key.equals(tag.key) : tag.key != null) {
            return false;
        }
        return this.value != null ? this.value.equals(tag.value) : tag.value == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

