/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.fs.oss;

import java.io.IOException;
import org.apache.fluss.fs.hdfs.HadoopFileSystem;
import org.apache.fluss.fs.oss.token.OSSSecurityTokenProvider;
import org.apache.fluss.fs.token.ObtainedSecurityToken;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

class OSSFileSystem
extends HadoopFileSystem {
    private final Configuration conf;
    private volatile OSSSecurityTokenProvider ossSecurityTokenProvider;
    private final String scheme;

    OSSFileSystem(FileSystem hadoopFileSystem, String scheme, Configuration conf) {
        super(hadoopFileSystem);
        this.scheme = scheme;
        this.conf = conf;
    }

    public ObtainedSecurityToken obtainSecurityToken() throws IOException {
        try {
            this.mayCreateSecurityTokenProvider();
            return this.ossSecurityTokenProvider.obtainSecurityToken(this.scheme);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mayCreateSecurityTokenProvider() throws IOException {
        if (this.ossSecurityTokenProvider == null) {
            OSSFileSystem oSSFileSystem = this;
            synchronized (oSSFileSystem) {
                if (this.ossSecurityTokenProvider == null) {
                    this.ossSecurityTokenProvider = new OSSSecurityTokenProvider(this.conf);
                }
            }
        }
    }
}

