/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.shaded.org.apache.commons.configuration2.builder.combined;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.fluss.shaded.org.apache.commons.beanutils.DynaBean;
import org.apache.fluss.shaded.org.apache.commons.beanutils.DynaClass;
import org.apache.fluss.shaded.org.apache.commons.beanutils.DynaProperty;
import org.apache.fluss.shaded.org.apache.commons.configuration2.beanutils.BeanHelper;
import org.apache.fluss.shaded.org.apache.commons.configuration2.builder.combined.MultiWrapDynaClass;

class MultiWrapDynaBean
implements DynaBean {
    private final DynaClass dynaClass;
    private final Map<String, DynaBean> propsToBeans = new HashMap<String, DynaBean>();

    public MultiWrapDynaBean(Collection<?> beans) {
        ArrayList<DynaClass> beanClasses = new ArrayList<DynaClass>(beans.size());
        for (Object bean : beans) {
            DynaBean dynaBean = MultiWrapDynaBean.createDynaBean(bean);
            DynaClass beanClass = dynaBean.getDynaClass();
            for (DynaProperty prop : beanClass.getDynaProperties()) {
                if (this.propsToBeans.containsKey(prop.getName())) continue;
                this.propsToBeans.put(prop.getName(), dynaBean);
            }
            beanClasses.add(beanClass);
        }
        this.dynaClass = new MultiWrapDynaClass(beanClasses);
    }

    @Override
    public boolean contains(String name, String key) {
        throw new UnsupportedOperationException("contains() operation not supported!");
    }

    @Override
    public Object get(String name) {
        return this.fetchBean(name).get(name);
    }

    @Override
    public Object get(String name, int index) {
        return this.fetchBean(name).get(name, index);
    }

    @Override
    public Object get(String name, String key) {
        return this.fetchBean(name).get(name, key);
    }

    @Override
    public DynaClass getDynaClass() {
        return this.dynaClass;
    }

    @Override
    public void remove(String name, String key) {
        throw new UnsupportedOperationException("remove() operation not supported!");
    }

    @Override
    public void set(String name, Object value) {
        this.fetchBean(name).set(name, value);
    }

    @Override
    public void set(String name, int index, Object value) {
        this.fetchBean(name).set(name, index, value);
    }

    @Override
    public void set(String name, String key, Object value) {
        this.fetchBean(name).set(name, key, value);
    }

    private DynaBean fetchBean(String property) {
        DynaBean dynaBean = this.propsToBeans.get(property);
        if (dynaBean == null) {
            dynaBean = this.propsToBeans.values().iterator().next();
        }
        return dynaBean;
    }

    private static DynaBean createDynaBean(Object bean) {
        if (bean instanceof DynaBean) {
            return (DynaBean)bean;
        }
        return BeanHelper.createWrapDynaBean(bean);
    }
}

