/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.impl.rest.httpclient;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.fluss.shaded.org.apache.commons.logging.Log;
import org.apache.fluss.shaded.org.apache.commons.logging.LogFactory;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.jets3t.service.Constants;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.impl.rest.XmlResponsesSaxParser;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;
import org.jets3t.service.model.GSBucket;
import org.jets3t.service.model.GSBucketLoggingStatus;
import org.jets3t.service.model.GSObject;
import org.jets3t.service.model.StorageBucket;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.mx.MxDelegate;
import org.jets3t.service.security.OAuth2Credentials;
import org.jets3t.service.security.OAuth2Tokens;
import org.jets3t.service.security.ProviderCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleStorageService
extends RestStorageService {
    private static final Log log = LogFactory.getLog(GoogleStorageService.class);
    private static final String GOOGLE_SIGNATURE_IDENTIFIER = "GOOG1";
    private static final String GOOGLE_REST_HEADER_PREFIX = "x-goog-";
    private static final String GOOGLE_REST_METADATA_PREFIX = "x-goog-meta-";

    public GoogleStorageService(ProviderCredentials credentials) throws ServiceException {
        this(credentials, (String)null, (CredentialsProvider)null);
    }

    public GoogleStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws ServiceException {
        this(credentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public GoogleStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws ServiceException {
        super(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties);
    }

    @Override
    protected HttpUriRequest setupConnection(RestStorageService.HTTP_METHOD method, String bucketName, String objectKey, Map<String, String> requestParameters) throws ServiceException {
        HttpUriRequest request = super.setupConnection(method, bucketName, objectKey, requestParameters);
        if (this.credentials instanceof OAuth2Credentials) {
            request.setHeader("x-goog-api-version", "2");
        }
        return request;
    }

    @Override
    protected boolean isTargettingGoogleStorageService() {
        return true;
    }

    @Override
    public String getEndpoint() {
        return this.jets3tProperties.getStringProperty("gsservice.gs-endpoint", Constants.GS_DEFAULT_HOSTNAME);
    }

    @Override
    protected String getVirtualPath() {
        return this.jets3tProperties.getStringProperty("gsservice.gs-endpoint-virtual-path", "");
    }

    @Override
    protected String getSignatureIdentifier() {
        return GOOGLE_SIGNATURE_IDENTIFIER;
    }

    @Override
    public String getRestHeaderPrefix() {
        return GOOGLE_REST_HEADER_PREFIX;
    }

    @Override
    public String getRestMetadataPrefix() {
        return GOOGLE_REST_METADATA_PREFIX;
    }

    @Override
    public List<String> getResourceParameterNames() {
        return Arrays.asList("acl", "logging", "location");
    }

    @Override
    protected int getHttpPort() {
        return this.jets3tProperties.getIntProperty("gsservice.gs-endpoint-http-port", 80);
    }

    @Override
    protected int getHttpsPort() {
        return this.jets3tProperties.getIntProperty("gsservice.gs-endpoint-https-port", 443);
    }

    @Override
    protected boolean getHttpsOnly() {
        return this.jets3tProperties.getBoolProperty("gsservice.https-only", true);
    }

    @Override
    protected boolean getDisableDnsBuckets() {
        return this.jets3tProperties.getBoolProperty("gsservice.disable-dns-buckets", false);
    }

    @Override
    protected boolean getEnableStorageClasses() {
        return false;
    }

    @Override
    protected boolean getEnableServerSideEncryption() {
        return false;
    }

    @Override
    protected XmlResponsesSaxParser getXmlResponseSaxParser() throws ServiceException {
        return new XmlResponsesSaxParser(this.jets3tProperties, true);
    }

    @Override
    protected StorageBucket newBucket() {
        return new GSBucket();
    }

    @Override
    protected StorageObject newObject() {
        return new GSObject();
    }

    public GSBucket[] listAllBuckets() throws ServiceException {
        return this.listAllBuckets(null);
    }

    public GSBucket[] listAllBuckets(String projectId) throws ServiceException {
        this.assertAuthenticatedConnection("List all buckets");
        StorageBucket[] buckets = this.listAllBucketsImpl(projectId);
        MxDelegate.getInstance().registerStorageBucketMBeans(buckets);
        return GSBucket.cast(buckets);
    }

    public GSObject[] listObjects(String bucketName) throws ServiceException {
        return GSObject.cast(super.listObjects(bucketName));
    }

    public GSObject[] listObjects(String bucketName, String prefix, String delimiter) throws ServiceException {
        return GSObject.cast(super.listObjects(bucketName, prefix, delimiter));
    }

    @Override
    public GSBucket createBucket(String bucketName) throws ServiceException {
        return (GSBucket)super.createBucket(bucketName);
    }

    public GSBucket createBucket(String bucketName, String location, AccessControlList acl, String projectId) throws ServiceException {
        return (GSBucket)this.createBucketImpl(bucketName, location, acl, projectId);
    }

    public GSBucket createBucket(String bucketName, String location, AccessControlList acl) throws ServiceException {
        return this.createBucket(bucketName, location, acl, null);
    }

    public GSBucketLoggingStatus getBucketLoggingStatus(String bucketName) throws ServiceException {
        return (GSBucketLoggingStatus)super.getBucketLoggingStatusImpl(bucketName);
    }

    public void setBucketLoggingStatus(String bucketName, GSBucketLoggingStatus status) throws ServiceException {
        super.setBucketLoggingStatusImpl(bucketName, status);
    }

    public String getBucketLocation(String bucketName) throws ServiceException {
        return this.getBucketLocationImpl(bucketName);
    }

    @Override
    public GSAccessControlList getBucketAcl(String bucketName) throws ServiceException {
        return (GSAccessControlList)super.getBucketAcl(bucketName);
    }

    public void putBucketAcl(String bucketName, GSAccessControlList acl) throws ServiceException {
        if (acl == null) {
            throw new ServiceException("The bucket '" + bucketName + "' does not include ACL information");
        }
        this.putBucketAclImpl(bucketName, acl);
    }

    public void putBucketAcl(GSBucket bucket) throws ServiceException {
        this.assertValidBucket(bucket, "Put Bucket Access Control List");
        this.putBucketAcl(bucket.getName(), bucket.getAcl());
    }

    @Override
    public GSObject getObject(String bucketName, String objectKey) throws ServiceException {
        return (GSObject)super.getObject(bucketName, objectKey);
    }

    public GSObject putObject(String bucketName, GSObject object) throws ServiceException {
        return (GSObject)super.putObject(bucketName, object);
    }

    @Override
    public GSObject getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws ServiceException {
        return (GSObject)super.getObject(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    @Override
    public GSObject getObjectDetails(String bucketName, String objectKey) throws ServiceException {
        return (GSObject)super.getObjectDetails(bucketName, objectKey);
    }

    @Override
    public void authorizeHttpRequest(HttpUriRequest httpMethod, HttpContext context) throws ServiceException {
        if (this.credentials instanceof OAuth2Credentials) {
            OAuth2Tokens tokens;
            try {
                tokens = ((OAuth2Credentials)this.credentials).getOAuth2Tokens();
            }
            catch (IOException e) {
                throw new ServiceException("Failure retrieving OAuth2 tokens", e);
            }
            if (tokens == null) {
                throw new ServiceException("Cannot authenticate using OAuth2 until initial tokens are provided, i.e. via setOAuth2Tokens()");
            }
            log.debug("Authorizing service request with OAuth2 access token: " + tokens.getAccessToken());
            httpMethod.setHeader("Authorization", "OAuth " + tokens.getAccessToken());
        } else {
            super.authorizeHttpRequest(httpMethod, context);
        }
    }

    @Override
    protected boolean isRecoverable403(HttpUriRequest httpRequest, Exception exception) {
        if (this.credentials instanceof OAuth2Credentials) {
            OAuth2Tokens tokens;
            try {
                tokens = ((OAuth2Credentials)this.credentials).getOAuth2Tokens();
            }
            catch (IOException e) {
                return false;
            }
            if (tokens != null) {
                tokens.expireAccessToken();
                return true;
            }
        }
        return super.isRecoverable403(httpRequest, exception);
    }

    protected StorageBucket[] listAllBucketsImpl(String projectId) throws ServiceException {
        if (null == projectId) {
            return super.listAllBucketsImpl();
        }
        return super.listAllBucketsImpl(Collections.singletonMap("x-goog-project-id", projectId));
    }

    protected StorageBucket createBucketImpl(String bucketName, String location, AccessControlList acl, String projectId) throws ServiceException {
        if (null == projectId) {
            return super.createBucketImpl(bucketName, location, acl);
        }
        return super.createBucketImpl(bucketName, location, acl, Collections.singletonMap("x-goog-project-id", projectId));
    }
}

