/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.stream;

import com.clickhouse.data.ClickHouseByteBuffer;
import com.clickhouse.data.ClickHouseChecker;
import com.clickhouse.data.stream.AbstractByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;

public class IterableObjectInputStream<T>
extends AbstractByteArrayInputStream {
    private final Function<T, byte[]> func;
    private final Iterator<T> it;

    public IterableObjectInputStream(Iterable<T> source, Function<T, byte[]> converter, Runnable postCloseAction) {
        super(null, null, postCloseAction);
        this.func = ClickHouseChecker.nonNull(converter, "Converter");
        this.it = ClickHouseChecker.nonNull(source, "Source").iterator();
    }

    @Override
    protected int updateBuffer() throws IOException {
        this.position = 0;
        while (this.it.hasNext()) {
            T obj = this.it.next();
            byte[] bytes = obj != null ? this.func.apply(obj) : null;
            if (bytes == null || bytes.length <= 0) continue;
            this.buffer = bytes;
            if (this.copyTo != null) {
                this.copyTo.write(bytes);
            }
            this.limit = bytes.length;
            return this.limit;
        }
        this.buffer = ClickHouseByteBuffer.EMPTY_BYTES;
        this.limit = 0;
        return 0;
    }
}

