/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.coordination.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluent;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseFluentImpl;
import java.util.Objects;

public class LeaseBuilder
extends LeaseFluentImpl<LeaseBuilder>
implements VisitableBuilder<Lease, LeaseBuilder> {
    LeaseFluent<?> fluent;
    Boolean validationEnabled;

    public LeaseBuilder() {
        this(true);
    }

    public LeaseBuilder(Boolean validationEnabled) {
        this(new Lease(), validationEnabled);
    }

    public LeaseBuilder(LeaseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LeaseBuilder(LeaseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Lease(), validationEnabled);
    }

    public LeaseBuilder(LeaseFluent<?> fluent, Lease instance) {
        this(fluent, instance, true);
    }

    public LeaseBuilder(LeaseFluent<?> fluent, Lease instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public LeaseBuilder(Lease instance) {
        this(instance, (Boolean)true);
    }

    public LeaseBuilder(Lease instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public Lease build() {
        Lease buildable = new Lease(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LeaseBuilder that = (LeaseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

