/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public class StaticTableOperations
implements TableOperations {
    private TableMetadata staticMetadata;
    private final String metadataFileLocation;
    private final FileIO io;
    private final LocationProvider locationProvider;

    public StaticTableOperations(String metadataFileLocation, FileIO io) {
        this(metadataFileLocation, io, null);
    }

    public StaticTableOperations(String metadataFileLocation, FileIO io, LocationProvider locationProvider) {
        this.io = io;
        this.metadataFileLocation = metadataFileLocation;
        this.locationProvider = locationProvider;
    }

    public StaticTableOperations(TableMetadata staticMetadata, FileIO io) {
        this(staticMetadata, io, null);
    }

    public StaticTableOperations(TableMetadata staticMetadata, FileIO io, LocationProvider locationProvider) {
        this.staticMetadata = staticMetadata;
        this.metadataFileLocation = staticMetadata.metadataFileLocation();
        this.io = io;
        this.locationProvider = locationProvider;
    }

    @Override
    public TableMetadata current() {
        if (this.staticMetadata == null) {
            this.staticMetadata = TableMetadataParser.read(this.io, this.metadataFileLocation);
        }
        return this.staticMetadata;
    }

    @Override
    public TableMetadata refresh() {
        return this.current();
    }

    @Override
    public void commit(TableMetadata base, TableMetadata metadata) {
        throw new UnsupportedOperationException("Cannot modify a static table");
    }

    @Override
    public FileIO io() {
        return this.io;
    }

    @Override
    public String metadataFileLocation(String fileName) {
        throw new UnsupportedOperationException("Cannot modify a static table");
    }

    @Override
    public LocationProvider locationProvider() {
        return this.locationProvider;
    }
}

