/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.NonBlockingConfig;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class NonBlockingConfigImpl
implements NonBlockingConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final NonBlocking instance;

    private NonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(NonBlocking.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.nonBlocking;
    }

    public static NonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.nonBlocking == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"non-blocking.enabled", (String)"NonBlocking/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new NonBlockingConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return NonBlocking.class;
    }

    public void materialize() {
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @NonBlocking on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @NonBlocking." + member + " on " + this.description + ": " + reason);
    }
}

