/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantArray;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantValue;

public class VariantVisitor<R> {
    public R object(VariantObject object, List<String> fieldNames, List<R> fieldResults) {
        return null;
    }

    public R array(VariantArray array, List<R> elementResults) {
        return null;
    }

    public R primitive(VariantPrimitive<?> primitive) {
        return null;
    }

    public void beforeArrayElement(int index) {
    }

    public void afterArrayElement(int index) {
    }

    public void beforeObjectField(String fieldName) {
    }

    public void afterObjectField(String fieldName) {
    }

    public static <R> R visit(Variant variant, VariantVisitor<R> visitor) {
        return VariantVisitor.visit(variant.value(), visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R visit(VariantValue value, VariantVisitor<R> visitor) {
        switch (value.type()) {
            case ARRAY: {
                VariantArray array = value.asArray();
                ArrayList elementResults = Lists.newArrayList();
                for (int index = 0; index < array.numElements(); ++index) {
                    visitor.beforeArrayElement(index);
                    try {
                        elementResults.add(VariantVisitor.visit(array.get(index), visitor));
                        continue;
                    }
                    finally {
                        visitor.afterArrayElement(index);
                    }
                }
                return visitor.array(array, elementResults);
            }
            case OBJECT: {
                VariantObject object = value.asObject();
                ArrayList fieldNames = Lists.newArrayList();
                ArrayList fieldResults = Lists.newArrayList();
                for (String fieldName : object.fieldNames()) {
                    fieldNames.add(fieldName);
                    visitor.beforeObjectField(fieldName);
                    try {
                        fieldResults.add(VariantVisitor.visit(object.get(fieldName), visitor));
                    }
                    finally {
                        visitor.afterObjectField(fieldName);
                    }
                }
                return visitor.object(object, fieldNames, fieldResults);
            }
        }
        return visitor.primitive(value.asPrimitive());
    }
}

