/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.protocol.detector;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.AsciiString;
import java.io.IOException;
import org.apache.seata.core.protocol.detector.ProtocolDetector;
import org.apache.seata.core.rpc.netty.http.Http2HttpHandler;
import org.apache.seata.core.rpc.netty.http.HttpDispatchHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDetector
implements ProtocolDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDetector.class);
    private static final String[] HTTP_METHODS = new String[]{"GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH"};

    @Override
    public boolean detect(ByteBuf in) {
        if (in.readableBytes() < 8) {
            return false;
        }
        for (String method : HTTP_METHODS) {
            if (!this.startsWith(in, method)) continue;
            return true;
        }
        return false;
    }

    private boolean startsWith(ByteBuf buffer, String prefix) {
        for (int i = 0; i < prefix.length(); ++i) {
            if (buffer.getByte(i) == (byte)prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ChannelHandler[] getHandlers() {
        HttpServerCodec sourceCodec = new HttpServerCodec();
        HttpServerUpgradeHandler upgradeHandler = HttpDetector.getHttpServerUpgradeHandler(sourceCodec);
        ChannelInboundHandlerAdapter upgradeCleanupHandler = new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
                    ChannelPipeline p = ctx.pipeline();
                    p.remove(HttpObjectAggregator.class);
                    p.remove(HttpDispatchHandler.class);
                }
                super.userEventTriggered(ctx, evt);
            }
        };
        ChannelInboundHandlerAdapter finalExceptionHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                if (cause instanceof IOException) {
                    LOGGER.trace("Connection closed by client: {}", (Object)cause.getMessage());
                } else {
                    LOGGER.error("Exception caught in HTTP pipeline: ", cause);
                }
                ctx.close();
            }
        };
        return new ChannelHandler[]{sourceCodec, upgradeHandler, upgradeCleanupHandler, new HttpObjectAggregator(0x100000), new HttpDispatchHandler(), finalExceptionHandler};
    }

    private static HttpServerUpgradeHandler getHttpServerUpgradeHandler(HttpServerCodec sourceCodec) {
        HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = protocol -> {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(Http2FrameCodecBuilder.forServer().build(), new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new ChannelInitializer<Http2StreamChannel>(){

                    protected void initChannel(Http2StreamChannel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{new Http2HttpHandler()});
                    }
                })});
            }
            return null;
        };
        return new HttpServerUpgradeHandler((HttpServerUpgradeHandler.SourceCodec)sourceCodec, upgradeCodecFactory, 0x100000);
    }
}

