/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.collection;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.fory.annotation.Internal;
import org.apache.fory.collection.ObjectArray;

@Internal
public class MapSnapshot<K, V>
extends AbstractMap<K, V> {
    private static final int CLEAR_ARRAY_SIZE_THRESHOLD = 2048;
    ObjectArray<Map.Entry<K, V>> array = new ObjectArray(16);
    Map<K, V> map;
    int size;
    int iterIndex;
    private final EntrySet entrySet = new EntrySet();
    private final EntryIterator iterator = new EntryIterator();

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    public void setMap(Map<K, V> map) {
        ObjectArray<Map.Entry<K, V>> array = this.array;
        int size = 0;
        for (Map.Entry<K, V> kvEntry : map.entrySet()) {
            array.add(kvEntry);
            ++size;
        }
        this.size = size;
    }

    @Override
    public void clear() {
        if (this.size > 2048) {
            this.array = new ObjectArray(16);
        } else {
            this.array.clear();
        }
        this.iterIndex = 0;
        this.size = 0;
    }

    class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return MapSnapshot.this.iterIndex < MapSnapshot.this.size;
        }

        @Override
        public Map.Entry<K, V> next() {
            return MapSnapshot.this.array.get(MapSnapshot.this.iterIndex++);
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            MapSnapshot.this.iterIndex = 0;
            return MapSnapshot.this.iterator;
        }

        @Override
        public int size() {
            return MapSnapshot.this.size;
        }
    }
}

