/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.exception.runtime.StorageEngineFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThreadUtils.class);

    public static void stopThreadPool(ExecutorService pool, ThreadName poolName) {
        if (pool != null) {
            pool.shutdownNow();
            try {
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    logger.warn("Waiting {} to be terminated is timeout", (Object)poolName.getName());
                }
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 60s", (Object)poolName.getName());
                Thread.currentThread().interrupt();
                throw new StorageEngineFailureException(String.format("StorageEngine failed to stop because of %s.", poolName.getName()), (Throwable)e);
            }
        }
    }
}

