/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.agent;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMetaKeeper;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.mpp.rpc.thrift.TPushConsumerGroupMetaRespExceptionMessage;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionConsumerAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionConsumerAgent.class);
    private final ConsumerGroupMetaKeeper consumerGroupMetaKeeper = new ConsumerGroupMetaKeeper();

    protected void acquireReadLock() {
        this.consumerGroupMetaKeeper.acquireReadLock();
    }

    protected void releaseReadLock() {
        this.consumerGroupMetaKeeper.releaseReadLock();
    }

    protected void acquireWriteLock() {
        this.consumerGroupMetaKeeper.acquireWriteLock();
    }

    protected void releaseWriteLock() {
        this.consumerGroupMetaKeeper.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushConsumerGroupMetaRespExceptionMessage handleSingleConsumerGroupMetaChanges(ConsumerGroupMeta consumerGroupMetaFromCoordinator) {
        this.acquireWriteLock();
        try {
            if (consumerGroupMetaFromCoordinator.isEmpty()) {
                this.handleDropConsumerGroupInternal(consumerGroupMetaFromCoordinator.getConsumerGroupId());
            } else {
                this.handleSingleConsumerGroupMetaChangesInternal(consumerGroupMetaFromCoordinator);
            }
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = null;
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        catch (Exception e) {
            String consumerGroupId = consumerGroupMetaFromCoordinator.getConsumerGroupId();
            LOGGER.warn("Exception occurred when handling single consumer group meta changes for consumer group {}", (Object)consumerGroupId, (Object)e);
            String exceptionMessage = String.format("Subscription: Failed to handle single consumer group meta changes for consumer group %s, because %s", consumerGroupId, e);
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = new TPushConsumerGroupMetaRespExceptionMessage(consumerGroupId, exceptionMessage, System.currentTimeMillis());
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleSingleConsumerGroupMetaChangesInternal(ConsumerGroupMeta metaFromCoordinator) {
        String consumerGroupId = metaFromCoordinator.getConsumerGroupId();
        ConsumerGroupMeta metaInAgent = this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupId);
        if (Objects.isNull(metaInAgent)) {
            this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
            this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupId, metaFromCoordinator);
            SubscriptionAgent.broker().createBrokerIfNotExist(consumerGroupId);
            return;
        }
        if (metaInAgent.getCreationTime() != metaFromCoordinator.getCreationTime()) {
            if (SubscriptionAgent.broker().isBrokerExist(consumerGroupId)) {
                LOGGER.warn("Subscription: broker bound to consumer group [{}] has already existed when the creation time of consumer group meta on local agent {} is inconsistent with meta from coordinator {}, drop it", new Object[]{consumerGroupId, metaInAgent, metaFromCoordinator});
                if (!SubscriptionAgent.broker().dropBroker(consumerGroupId)) {
                    String exceptionMessage = String.format("Failed to drop stale broker bound to consumer group [%s]", consumerGroupId);
                    LOGGER.warn(exceptionMessage);
                    throw new SubscriptionException(exceptionMessage);
                }
            }
            this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
            this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupId, metaFromCoordinator);
            return;
        }
        Set topicsUnsubByGroup = ConsumerGroupMeta.getTopicsUnsubByGroup((ConsumerGroupMeta)metaInAgent, (ConsumerGroupMeta)metaFromCoordinator);
        for (String topicName : topicsUnsubByGroup) {
            SubscriptionAgent.broker().removePrefetchingQueue(consumerGroupId, topicName);
        }
        this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
        this.consumerGroupMetaKeeper.addConsumerGroupMeta(consumerGroupId, metaFromCoordinator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushConsumerGroupMetaRespExceptionMessage handleConsumerGroupMetaChanges(List<ConsumerGroupMeta> consumerGroupMetasFromCoordinator) {
        this.acquireWriteLock();
        try {
            for (ConsumerGroupMeta consumerGroupMetaFromCoordinator : consumerGroupMetasFromCoordinator) {
                try {
                    this.handleSingleConsumerGroupMetaChangesInternal(consumerGroupMetaFromCoordinator);
                }
                catch (Exception e) {
                    String consumerGroupId = consumerGroupMetaFromCoordinator.getConsumerGroupId();
                    LOGGER.warn("Exception occurred when handling single consumer group meta changes for consumer group {}", (Object)consumerGroupId, (Object)e);
                    String exceptionMessage = String.format("Subscription: Failed to handle single consumer group meta changes for consumer group %s, because %s", consumerGroupId, e);
                    TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = new TPushConsumerGroupMetaRespExceptionMessage(consumerGroupId, exceptionMessage, System.currentTimeMillis());
                    this.releaseWriteLock();
                    return tPushConsumerGroupMetaRespExceptionMessage;
                }
            }
            Iterator<ConsumerGroupMeta> iterator = null;
            return iterator;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TPushConsumerGroupMetaRespExceptionMessage handleDropConsumerGroup(String consumerGroupId) {
        this.acquireWriteLock();
        try {
            this.handleDropConsumerGroupInternal(consumerGroupId);
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = null;
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when dropping consumer group {}", (Object)consumerGroupId, (Object)e);
            String exceptionMessage = String.format("Subscription: Failed to drop consumer group %s, because %s", consumerGroupId, e);
            TPushConsumerGroupMetaRespExceptionMessage tPushConsumerGroupMetaRespExceptionMessage = new TPushConsumerGroupMetaRespExceptionMessage(consumerGroupId, exceptionMessage, System.currentTimeMillis());
            return tPushConsumerGroupMetaRespExceptionMessage;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void handleDropConsumerGroupInternal(String consumerGroupId) {
        if (SubscriptionAgent.broker().isBrokerExist(consumerGroupId)) {
            if (!SubscriptionAgent.broker().dropBroker(consumerGroupId)) {
                String exceptionMessage = String.format("Failed to drop broker bound to consumer group [%s]", consumerGroupId);
                LOGGER.warn(exceptionMessage);
                throw new SubscriptionException(exceptionMessage);
            }
        } else {
            LOGGER.warn("Subscription: broker bound to consumer group [{}] does not existed when the corresponding consumer group meta has already existed on local agent, ignore it", (Object)consumerGroupId);
        }
        this.consumerGroupMetaKeeper.removeConsumerGroupMeta(consumerGroupId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsumerExisted(String consumerGroupId, String consumerId) {
        this.acquireReadLock();
        try {
            ConsumerGroupMeta consumerGroupMeta = this.consumerGroupMetaKeeper.getConsumerGroupMeta(consumerGroupId);
            boolean bl = Objects.nonNull(consumerGroupMeta) && consumerGroupMeta.containsConsumer(consumerId);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getTopicNamesSubscribedByConsumer(String consumerGroupId, String consumerId) {
        this.acquireReadLock();
        try {
            Set set = this.consumerGroupMetaKeeper.getTopicsSubscribedByConsumer(consumerGroupId, consumerId);
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }
}

