/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.udf.access.RecordIterator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.MaskedRecordIterator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.udf.api.State;
import org.apache.iotdb.udf.api.customizer.analysis.AggregateFunctionAnalysis;
import org.apache.iotdb.udf.api.relational.AggregateFunction;
import org.apache.iotdb.udf.api.utils.ResultValue;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class UserDefinedAggregateFunctionAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(UserDefinedAggregateFunctionAccumulator.class);
    private final AggregateFunctionAnalysis analysis;
    private final AggregateFunction aggregateFunction;
    private final List<Type> inputDataTypes;
    private final State state;

    public UserDefinedAggregateFunctionAccumulator(AggregateFunctionAnalysis analysis, AggregateFunction aggregateFunction, List<Type> inputDataTypes) {
        this.analysis = analysis;
        this.aggregateFunction = aggregateFunction;
        this.inputDataTypes = inputDataTypes;
        this.state = aggregateFunction.createState();
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new UserDefinedAggregateFunctionAccumulator(this.analysis, this.aggregateFunction, this.inputDataTypes);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        RecordIterator iterator;
        Object object = iterator = mask.isSelectAll() ? new RecordIterator(Arrays.asList(arguments), this.inputDataTypes, arguments[0].getPositionCount()) : new MaskedRecordIterator(Arrays.asList(arguments), this.inputDataTypes, mask);
        while (iterator.hasNext()) {
            this.aggregateFunction.addInput(this.state, iterator.next());
        }
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of UDAF should be BinaryColumn");
        State otherState = this.aggregateFunction.createState();
        for (int i = 0; i < argument.getPositionCount(); ++i) {
            otherState.reset();
            Binary otherStateBinary = argument.getBinary(i);
            otherState.deserialize(otherStateBinary.getValues());
            this.aggregateFunction.combineState(this.state, otherState);
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of UDAF should be BinaryColumn");
        byte[] bytes = this.state.serialize();
        columnBuilder.writeBinary(new Binary(bytes));
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        ResultValue resultValue = new ResultValue(columnBuilder);
        this.aggregateFunction.outputFinal(this.state, resultValue);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        throw new UnsupportedOperationException("UDAF not support calculate from statistics now");
    }

    @Override
    public void reset() {
        this.state.reset();
    }

    @Override
    public void removeInput(Column[] arguments) {
        if (!this.analysis.isRemovable()) {
            throw new UnsupportedOperationException("This Accumulator does not support removing inputs!");
        }
        RecordIterator iterator = new RecordIterator(Arrays.asList(arguments), this.inputDataTypes, arguments[0].getPositionCount());
        while (iterator.hasNext()) {
            this.aggregateFunction.remove(this.state, iterator.next());
        }
    }

    @Override
    public boolean removable() {
        return this.analysis.isRemovable();
    }

    @Override
    public void close() {
        this.aggregateFunction.beforeDestroy();
        this.state.destroyState();
    }
}

