/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.TimeWindowStateProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskProcessorRuntimeEnvironment;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.agent.plugin.dataregion.PipeDataRegionPluginAgent;
import org.apache.iotdb.db.pipe.event.common.row.PipeResetTabletRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRow;
import org.apache.iotdb.db.pipe.event.common.row.PipeRowCollector;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.processor.aggregate.TimeSeriesRuntimeState;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.aggregatedresult.AggregatedResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.IntermediateResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.processor.AbstractOperatorProcessor;
import org.apache.iotdb.db.pipe.processor.aggregate.window.datastructure.WindowOutput;
import org.apache.iotdb.db.pipe.processor.aggregate.window.processor.AbstractWindowingProcessor;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.annotation.TreeModel;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeRuntimeEnvironment;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;

@TreeModel
public class AggregateProcessor
implements PipeProcessor {
    private static final String WINDOWING_PROCESSOR_SUFFIX = "-windowing-processor";
    private String pipeName;
    private String databaseWithPathSeparator;
    private PipeTaskMeta pipeTaskMeta;
    private long outputMaxDelayMilliseconds;
    private long outputMinReportIntervalMilliseconds;
    private String outputDatabaseWithPathSeparator;
    private final Map<String, AggregatedResultOperator> outputName2OperatorMap = new HashMap<String, AggregatedResultOperator>();
    private final Map<String, Supplier<IntermediateResultOperator>> intermediateResultName2OperatorSupplierMap = new HashMap<String, Supplier<IntermediateResultOperator>>();
    private final Map<String, String> systemParameters = new HashMap<String, String>();
    private static final Map<String, Integer> pipeName2referenceCountMap = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, AtomicLong> pipeName2LastValueReceiveTimeMap = new ConcurrentHashMap<String, AtomicLong>();
    private static final ConcurrentMap<String, ConcurrentMap<String, AtomicReference<TimeSeriesRuntimeState>>> pipeName2timeSeries2TimeSeriesRuntimeStateMap = new ConcurrentHashMap<String, ConcurrentMap<String, AtomicReference<TimeSeriesRuntimeState>>>();
    private AbstractWindowingProcessor windowingProcessor;
    private final List<AbstractOperatorProcessor> operatorProcessors = new ArrayList<AbstractOperatorProcessor>();
    private String[] columnNameStringList;
    private String dataBaseName;
    private Boolean isTableModel;

    public void validate(PipeParameterValidator validator) throws Exception {
        PipeParameters parameters = validator.getParameters();
        validator.validate(arg -> !((String)arg).isEmpty(), String.format("The parameter %s must not be empty.", "processor.operators"), (Object)parameters.getStringOrDefault("processor.operators", "")).validate(arg -> !((String)arg).isEmpty(), String.format("The parameter %s must not be empty.", "processor.windowing-strategy"), (Object)parameters.getStringOrDefault("processor.windowing-strategy", "tumbling")).validate(arg -> ((String)arg).isEmpty() || ((String)arg).startsWith("root."), String.format("The output database %s shall start with root.", parameters.getStringOrDefault("processor.output.database", "")), (Object)parameters.getStringOrDefault("processor.output.database", "")).validate(arg -> ((String)arg).isEmpty() || Arrays.stream(((String)arg).replace(" ", "").split(",")).allMatch(this::isLegalMeasurement), String.format("The output measurements %s contains illegal measurements, the measurements must be the last level of a legal path", parameters.getStringOrDefault("processor.output.measurements", "")), (Object)parameters.getStringOrDefault("processor.output.measurements", ""));
    }

    private boolean isLegalMeasurement(String measurement) {
        try {
            PathUtils.isLegalPath((String)("root." + measurement));
        }
        catch (IllegalPathException e) {
            return false;
        }
        return measurement.startsWith("`") && measurement.endsWith("`") || !measurement.contains(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
        PipeRuntimeEnvironment environment = configuration.getRuntimeEnvironment();
        this.pipeName = environment.getPipeName();
        this.dataBaseName = StorageEngine.getInstance().getDataRegion(new DataRegionId(environment.getRegionId())).getDatabaseName();
        if (this.dataBaseName != null) {
            this.isTableModel = PathUtils.isTableModelDatabase((String)this.dataBaseName);
        }
        pipeName2referenceCountMap.compute(this.pipeName, (name, count) -> Objects.nonNull(count) ? count + 1 : 1);
        pipeName2timeSeries2TimeSeriesRuntimeStateMap.putIfAbsent(this.pipeName, new ConcurrentHashMap());
        this.databaseWithPathSeparator = StorageEngine.getInstance().getDataRegion(new DataRegionId(configuration.getRuntimeEnvironment().getRegionId())).getDatabaseName() + ".";
        this.pipeTaskMeta = ((PipeTaskProcessorRuntimeEnvironment)configuration.getRuntimeEnvironment()).getPipeTaskMeta();
        long outputMaxDelaySeconds = parameters.getLongOrDefault("processor.output.max-delay-seconds", -1L);
        this.outputMaxDelayMilliseconds = outputMaxDelaySeconds < 0L ? Long.MAX_VALUE : Math.max(outputMaxDelaySeconds * 1000L, 1L);
        this.outputMinReportIntervalMilliseconds = parameters.getLongOrDefault("processor.output.min-report-interval-seconds", 30L) * 1000L;
        String outputDatabase = parameters.getStringOrDefault("processor.output.database", "");
        this.outputDatabaseWithPathSeparator = outputDatabase.isEmpty() ? outputDatabase : outputDatabase + ".";
        List operatorNameList = Arrays.stream(parameters.getStringOrDefault("processor.operators", "").replace(" ", "").split(",")).collect(Collectors.toList());
        String outputMeasurementString = parameters.getStringOrDefault("processor.output.measurements", "");
        List outputMeasurementNameList = outputMeasurementString.isEmpty() ? Collections.emptyList() : Arrays.stream(outputMeasurementString.replace(" ", "").split(",")).collect(Collectors.toList());
        HashMap<String, String> aggregatorName2OutputNameMap = new HashMap<String, String>();
        for (int i = 0; i < operatorNameList.size(); ++i) {
            if (i < outputMeasurementNameList.size()) {
                aggregatorName2OutputNameMap.put(((String)operatorNameList.get(i)).toLowerCase(), (String)outputMeasurementNameList.get(i));
                continue;
            }
            aggregatorName2OutputNameMap.put(((String)operatorNameList.get(i)).toLowerCase(), (String)operatorNameList.get(i));
        }
        HashSet declaredIntermediateResultSet = new HashSet();
        PipeDataRegionPluginAgent agent = PipeDataNodeAgent.plugin().dataRegion();
        for (String pipePluginName : agent.getSubProcessorNamesWithSpecifiedParent(AbstractOperatorProcessor.class)) {
            AbstractOperatorProcessor operatorProcessor = (AbstractOperatorProcessor)agent.getConfiguredProcessor(pipePluginName, parameters, configuration);
            operatorProcessor.getAggregatorOperatorSet().stream().filter(operator -> aggregatorName2OutputNameMap.containsKey(operator.getName().toLowerCase())).forEach(operator -> {
                this.outputName2OperatorMap.put((String)aggregatorName2OutputNameMap.get(operator.getName().toLowerCase()), (AggregatedResultOperator)operator);
                declaredIntermediateResultSet.addAll(operator.getDeclaredIntermediateValueNames());
            });
            operatorProcessor.getIntermediateResultOperatorSupplierSet().forEach(supplier -> this.intermediateResultName2OperatorSupplierMap.put(((IntermediateResultOperator)supplier.get()).getName(), (Supplier<IntermediateResultOperator>)supplier));
            this.operatorProcessors.add(operatorProcessor);
        }
        aggregatorName2OutputNameMap.entrySet().removeIf(entry -> this.outputName2OperatorMap.containsKey(entry.getValue()));
        if (!aggregatorName2OutputNameMap.isEmpty()) {
            throw new PipeException(String.format("The aggregator and output name %s is invalid.", aggregatorName2OutputNameMap));
        }
        this.intermediateResultName2OperatorSupplierMap.keySet().retainAll(declaredIntermediateResultSet);
        declaredIntermediateResultSet.removeAll(this.intermediateResultName2OperatorSupplierMap.keySet());
        if (!declaredIntermediateResultSet.isEmpty()) {
            throw new PipeException(String.format("The needed intermediate values %s are not defined.", declaredIntermediateResultSet));
        }
        this.columnNameStringList = new String[this.outputName2OperatorMap.size()];
        ArrayList<String> operatorNames = new ArrayList<String>(this.outputName2OperatorMap.keySet());
        for (int i = 0; i < this.outputName2OperatorMap.size(); ++i) {
            this.columnNameStringList[i] = (String)operatorNames.get(i);
        }
        String processorName = parameters.getStringOrDefault("processor.windowing-strategy", "tumbling") + WINDOWING_PROCESSOR_SUFFIX;
        PipeProcessor windowProcessor = agent.getConfiguredProcessor(processorName, parameters, configuration);
        if (!(windowProcessor instanceof AbstractWindowingProcessor)) {
            throw new PipeException(String.format("The processor %s is not a windowing processor.", processorName));
        }
        this.windowingProcessor = (AbstractWindowingProcessor)windowProcessor;
        this.systemParameters.put("timestampPrecision", CommonDescriptor.getInstance().getConfig().getTimestampPrecision());
        this.outputName2OperatorMap.values().forEach(operator -> operator.configureSystemParameters(this.systemParameters));
        ProgressIndex index = this.pipeTaskMeta.getProgressIndex();
        if (index == MinimumProgressIndex.INSTANCE) {
            return;
        }
        if (!(index instanceof TimeWindowStateProgressIndex)) {
            throw new PipeException(String.format("The aggregate processor does not support progressIndexType %s", index.getType()));
        }
        TimeWindowStateProgressIndex timeWindowStateProgressIndex = (TimeWindowStateProgressIndex)index;
        for (Map.Entry entry2 : timeWindowStateProgressIndex.getTimeSeries2TimestampWindowBufferPairMap().entrySet()) {
            AtomicReference stateReference;
            AtomicReference atomicReference = stateReference = ((ConcurrentMap)pipeName2timeSeries2TimeSeriesRuntimeStateMap.get(this.pipeName)).computeIfAbsent((String)entry2.getKey(), key -> new AtomicReference<TimeSeriesRuntimeState>(new TimeSeriesRuntimeState(this.outputName2OperatorMap, this.intermediateResultName2OperatorSupplierMap, this.systemParameters, this.windowingProcessor)));
            synchronized (atomicReference) {
                try {
                    ((TimeSeriesRuntimeState)stateReference.get()).restoreTimestampAndWindows((Pair<Long, ByteBuffer>)((Pair)entry2.getValue()));
                }
                catch (IOException e) {
                    throw new PipeException("Encountered exception when deserializing from PipeTaskMeta", (Throwable)e);
                }
            }
        }
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            eventCollector.collect((Event)tabletInsertionEvent);
            return;
        }
        pipeName2LastValueReceiveTimeMap.computeIfAbsent(this.pipeName, key -> new AtomicLong(System.currentTimeMillis())).set(System.currentTimeMillis());
        AtomicReference exception = new AtomicReference();
        TimeWindowStateProgressIndex[] progressIndex = new TimeWindowStateProgressIndex[]{new TimeWindowStateProgressIndex(new ConcurrentHashMap())};
        Iterable outputEvents = tabletInsertionEvent.processRowByRow((row, rowCollector) -> {
            progressIndex[0] = (TimeWindowStateProgressIndex)progressIndex[0].updateToMinimumEqualOrIsAfterProgressIndex((ProgressIndex)new TimeWindowStateProgressIndex(this.processRow((Row)row, (RowCollector)rowCollector, exception)));
        });
        ((EnrichedEvent)tabletInsertionEvent).bindProgressIndex((ProgressIndex)progressIndex[0]);
        outputEvents.forEach(event -> {
            try {
                eventCollector.collect((Event)event);
            }
            catch (Exception e) {
                exception.set(e);
            }
        });
        if (Objects.nonNull(exception.get())) {
            throw (Exception)exception.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Pair<Long, ByteBuffer>> processRow(Row row, RowCollector rowCollector, AtomicReference<Exception> exception) {
        HashMap<String, Pair<Long, ByteBuffer>> resultMap = new HashMap<String, Pair<Long, ByteBuffer>>();
        long timestamp = row.getTime();
        int size = row.size();
        for (int index = 0; index < size; ++index) {
            AtomicReference stateReference;
            if (row.isNull(index)) continue;
            String timeSeries = (this.outputDatabaseWithPathSeparator.isEmpty() ? row.getDeviceId() : row.getDeviceId().replaceFirst(this.databaseWithPathSeparator, "")) + "." + row.getColumnName(index);
            AtomicReference atomicReference = stateReference = ((ConcurrentMap)pipeName2timeSeries2TimeSeriesRuntimeStateMap.get(this.pipeName)).computeIfAbsent(timeSeries, key -> new AtomicReference<TimeSeriesRuntimeState>(new TimeSeriesRuntimeState(this.outputName2OperatorMap, this.intermediateResultName2OperatorSupplierMap, this.systemParameters, this.windowingProcessor)));
            synchronized (atomicReference) {
                TimeSeriesRuntimeState state = (TimeSeriesRuntimeState)stateReference.get();
                try {
                    Pair<List<WindowOutput>, Pair<Long, ByteBuffer>> result;
                    switch (row.getDataType(index)) {
                        case BOOLEAN: {
                            result = state.updateWindows(timestamp, row.getBoolean(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case INT32: {
                            result = state.updateWindows(timestamp, row.getInt(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case DATE: {
                            result = state.updateWindows(timestamp, row.getDate(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            result = state.updateWindows(timestamp, row.getLong(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case FLOAT: {
                            result = state.updateWindows(timestamp, row.getFloat(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case DOUBLE: {
                            result = state.updateWindows(timestamp, row.getDouble(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case TEXT: 
                        case STRING: {
                            result = state.updateWindows(timestamp, row.getString(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        case BLOB: {
                            result = state.updateWindows(timestamp, row.getBinary(index), this.outputMinReportIntervalMilliseconds);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("The type %s is not supported", row.getDataType(index)));
                        }
                    }
                    if (Objects.nonNull(result)) {
                        this.collectWindowOutputs((List)result.getLeft(), timeSeries, rowCollector);
                        if (Objects.nonNull(result.getRight())) {
                            resultMap.put(timeSeries, (Pair<Long, ByteBuffer>)((Pair)result.getRight()));
                        }
                    }
                }
                catch (IOException | UnsupportedOperationException e) {
                    exception.set(e);
                }
                continue;
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        try {
            if (tsFileInsertionEvent instanceof PipeTsFileInsertionEvent) {
                AtomicReference ex = new AtomicReference();
                ((PipeTsFileInsertionEvent)tsFileInsertionEvent).consumeTabletInsertionEventsWithRetry(event -> {
                    try {
                        this.process(event, eventCollector);
                    }
                    catch (Exception e) {
                        ex.set(e);
                    }
                }, "AggregateProcessor::process");
                if (ex.get() != null) {
                    throw (Exception)ex.get();
                }
            } else {
                for (TabletInsertionEvent tabletInsertionEvent : tsFileInsertionEvent.toTabletInsertionEvents()) {
                    this.process(tabletInsertionEvent, eventCollector);
                }
            }
        }
        finally {
            tsFileInsertionEvent.close();
        }
        if (tsFileInsertionEvent instanceof PipeTsFileInsertionEvent) {
            ((PipeTsFileInsertionEvent)tsFileInsertionEvent).skipReportOnCommit();
        }
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        AtomicLong lastReceiveTime = pipeName2LastValueReceiveTimeMap.computeIfAbsent(this.pipeName, key -> new AtomicLong(System.currentTimeMillis()));
        long previousTime = lastReceiveTime.get();
        if (System.currentTimeMillis() - previousTime > this.outputMaxDelayMilliseconds) {
            AtomicReference exception = new AtomicReference();
            ((ConcurrentMap)pipeName2timeSeries2TimeSeriesRuntimeStateMap.get(this.pipeName)).keySet().forEach(timeSeries -> {
                AtomicReference stateReference;
                AtomicReference atomicReference = stateReference = (AtomicReference)((ConcurrentMap)pipeName2timeSeries2TimeSeriesRuntimeStateMap.get(this.pipeName)).get(timeSeries);
                synchronized (atomicReference) {
                    PipeRowCollector rowCollector = new PipeRowCollector(this.pipeTaskMeta, null, this.dataBaseName, this.isTableModel);
                    try {
                        this.collectWindowOutputs(((TimeSeriesRuntimeState)stateReference.get()).forceOutput(), (String)timeSeries, rowCollector);
                    }
                    catch (IOException e) {
                        exception.set(e);
                    }
                    rowCollector.convertToTabletInsertionEvents(false).forEach(tabletEvent -> {
                        try {
                            eventCollector.collect((Event)tabletEvent);
                        }
                        catch (Exception e) {
                            exception.set(e);
                        }
                    });
                }
            });
            if (exception.get() != null) {
                lastReceiveTime.set(System.currentTimeMillis());
                throw (Exception)exception.get();
            }
            lastReceiveTime.compareAndSet(previousTime, Long.MAX_VALUE);
        }
        eventCollector.collect(event);
    }

    public void collectWindowOutputs(List<WindowOutput> outputs, String timeSeries, RowCollector collector) throws IOException {
        String outputTimeSeries;
        if (Objects.isNull(outputs) || outputs.isEmpty()) {
            return;
        }
        outputs.sort(Comparator.comparingLong(WindowOutput::getTimestamp));
        AtomicLong lastValue = new AtomicLong(Long.MIN_VALUE);
        ArrayList distinctOutputs = new ArrayList();
        outputs.forEach(output -> {
            long timeStamp = output.getTimestamp();
            if (timeStamp != lastValue.get()) {
                lastValue.set(timeStamp);
                distinctOutputs.add(output);
            }
        });
        MeasurementSchema[] measurementSchemaList = new MeasurementSchema[this.columnNameStringList.length];
        TSDataType[] valueColumnTypes = new TSDataType[this.columnNameStringList.length];
        Object[] valueColumns = new Object[this.columnNameStringList.length];
        BitMap[] bitMaps = new BitMap[this.columnNameStringList.length];
        long[] timestampColumn = new long[distinctOutputs.size()];
        for (int i = 0; i < distinctOutputs.size(); ++i) {
            timestampColumn[i] = ((WindowOutput)distinctOutputs.get(i)).getTimestamp();
        }
        for (int columnIndex = 0; columnIndex < this.columnNameStringList.length; ++columnIndex) {
            bitMaps[columnIndex] = new BitMap(distinctOutputs.size());
            block21: for (int rowIndex = 0; rowIndex < distinctOutputs.size(); ++rowIndex) {
                Map<String, Pair<TSDataType, Object>> aggregatedResults = ((WindowOutput)distinctOutputs.get(rowIndex)).getAggregatedResults();
                if (aggregatedResults.containsKey(this.columnNameStringList[columnIndex])) {
                    if (Objects.isNull(valueColumnTypes[columnIndex])) {
                        valueColumnTypes[columnIndex] = (TSDataType)aggregatedResults.get(this.columnNameStringList[columnIndex]).getLeft();
                        measurementSchemaList[columnIndex] = new MeasurementSchema(this.columnNameStringList[columnIndex], valueColumnTypes[columnIndex]);
                        switch (valueColumnTypes[columnIndex]) {
                            case BOOLEAN: {
                                valueColumns[columnIndex] = new boolean[distinctOutputs.size()];
                                break;
                            }
                            case INT32: {
                                valueColumns[columnIndex] = new int[distinctOutputs.size()];
                                break;
                            }
                            case DATE: {
                                valueColumns[columnIndex] = new LocalDate[distinctOutputs.size()];
                                break;
                            }
                            case INT64: 
                            case TIMESTAMP: {
                                valueColumns[columnIndex] = new long[distinctOutputs.size()];
                                break;
                            }
                            case FLOAT: {
                                valueColumns[columnIndex] = new float[distinctOutputs.size()];
                                break;
                            }
                            case DOUBLE: {
                                valueColumns[columnIndex] = new double[distinctOutputs.size()];
                                break;
                            }
                            case TEXT: 
                            case BLOB: 
                            case STRING: {
                                valueColumns[columnIndex] = new Binary[distinctOutputs.size()];
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException(String.format("The output tablet does not support column type %s", valueColumnTypes[columnIndex]));
                            }
                        }
                    }
                    switch (valueColumnTypes[columnIndex]) {
                        case BOOLEAN: {
                            ((boolean[])valueColumns[columnIndex])[rowIndex] = (Boolean)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight();
                            continue block21;
                        }
                        case INT32: {
                            ((int[])valueColumns[columnIndex])[rowIndex] = (Integer)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight();
                            continue block21;
                        }
                        case DATE: {
                            ((LocalDate[])valueColumns[columnIndex])[rowIndex] = (LocalDate)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight();
                            continue block21;
                        }
                        case INT64: 
                        case TIMESTAMP: {
                            ((long[])valueColumns[columnIndex])[rowIndex] = (Long)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight();
                            continue block21;
                        }
                        case FLOAT: {
                            ((float[])valueColumns[columnIndex])[rowIndex] = ((Float)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight()).floatValue();
                            continue block21;
                        }
                        case DOUBLE: {
                            ((double[])valueColumns[columnIndex])[rowIndex] = (Double)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight();
                            continue block21;
                        }
                        case TEXT: 
                        case STRING: {
                            ((Binary[])valueColumns[columnIndex])[rowIndex] = aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight() instanceof Binary ? (Binary)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight() : new Binary((String)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight(), TSFileConfig.STRING_CHARSET);
                            continue block21;
                        }
                        case BLOB: {
                            ((Binary[])valueColumns[columnIndex])[rowIndex] = (Binary)aggregatedResults.get(this.columnNameStringList[columnIndex]).getRight();
                            continue block21;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("The output tablet does not support column type %s", valueColumnTypes[rowIndex]));
                        }
                    }
                }
                bitMaps[columnIndex].mark(rowIndex);
            }
        }
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[this.columnNameStringList.length];
        int filteredCount = 0;
        for (int i = 0; i < this.columnNameStringList.length; ++i) {
            if (bitMaps[i].isAllMarked()) continue;
            originColumnIndex2FilteredColumnIndexMapperList[i] = ++filteredCount;
        }
        String string = outputTimeSeries = this.outputDatabaseWithPathSeparator.isEmpty() ? timeSeries : this.outputDatabaseWithPathSeparator + timeSeries;
        if (filteredCount == this.columnNameStringList.length) {
            for (int rowIndex = 0; rowIndex < distinctOutputs.size(); ++rowIndex) {
                collector.collectRow((Row)(rowIndex == 0 ? new PipeResetTabletRow(rowIndex, outputTimeSeries, false, measurementSchemaList, timestampColumn, valueColumnTypes, valueColumns, bitMaps, this.columnNameStringList) : new PipeRow(rowIndex, outputTimeSeries, false, (IMeasurementSchema[])measurementSchemaList, timestampColumn, valueColumnTypes, valueColumns, bitMaps, this.columnNameStringList)));
            }
        } else {
            MeasurementSchema[] filteredMeasurementSchemaList = new MeasurementSchema[filteredCount];
            String[] filteredColumnNameStringList = new String[filteredCount];
            TSDataType[] filteredValueColumnTypes = new TSDataType[filteredCount];
            Object[] filteredValueColumns = new Object[filteredCount];
            BitMap[] filteredBitMaps = new BitMap[filteredCount];
            for (int i = 0; i < originColumnIndex2FilteredColumnIndexMapperList.length; ++i) {
                if (originColumnIndex2FilteredColumnIndexMapperList[i] == null) continue;
                int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i];
                filteredMeasurementSchemaList[filteredColumnIndex] = measurementSchemaList[i];
                filteredColumnNameStringList[filteredColumnIndex] = this.columnNameStringList[i];
                filteredValueColumnTypes[filteredColumnIndex] = valueColumnTypes[i];
                filteredBitMaps[filteredColumnIndex] = bitMaps[i];
                filteredValueColumns[filteredColumnIndex] = valueColumns[i];
            }
            for (int rowIndex = 0; rowIndex < distinctOutputs.size(); ++rowIndex) {
                collector.collectRow((Row)(rowIndex == 0 ? new PipeResetTabletRow(rowIndex, outputTimeSeries, false, filteredMeasurementSchemaList, timestampColumn, filteredValueColumnTypes, filteredValueColumns, filteredBitMaps, filteredColumnNameStringList) : new PipeRow(rowIndex, outputTimeSeries, false, (IMeasurementSchema[])filteredMeasurementSchemaList, timestampColumn, filteredValueColumnTypes, filteredValueColumns, filteredBitMaps, filteredColumnNameStringList)));
            }
        }
    }

    public void close() throws Exception {
        if (Objects.nonNull(this.pipeName) && pipeName2referenceCountMap.compute(this.pipeName, (name, count) -> Objects.nonNull(count) ? count - 1 : 0) == 0) {
            ((ConcurrentMap)pipeName2timeSeries2TimeSeriesRuntimeStateMap.get(this.pipeName)).clear();
            pipeName2timeSeries2TimeSeriesRuntimeStateMap.remove(this.pipeName);
            pipeName2LastValueReceiveTimeMap.remove(this.pipeName);
        }
        if (Objects.nonNull(this.windowingProcessor)) {
            this.windowingProcessor.close();
        }
        for (PipeProcessor pipeProcessor : this.operatorProcessors) {
            pipeProcessor.close();
        }
    }
}

