/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.mail.optional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jsieve.exception.SyntaxException;
import org.apache.jsieve.mail.Action;

public class ActionVacation
implements Action {
    private final String subject;
    private final String from;
    private final List<String> addresses;
    private final String handle;
    private final String reason;
    private final String mime;
    private final int duration;

    public static ActionVacationBuilder builder() {
        return new ActionVacationBuilder();
    }

    private ActionVacation(String subject, String from, List<String> addresses, String reason, int duration, String handle, String mime) {
        this.subject = subject;
        this.from = from;
        this.addresses = Collections.unmodifiableList(addresses);
        this.reason = reason;
        this.duration = duration;
        this.handle = handle;
        this.mime = mime;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getFrom() {
        return this.from;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getReason() {
        return this.reason;
    }

    public int getDuration() {
        return this.duration;
    }

    public String getMime() {
        return this.mime;
    }

    public String toString() {
        return "Action: " + this.getClass().getName();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionVacation that = (ActionVacation)o;
        return this.duration == that.duration && this.equalsNullProtected(this.subject, this.subject) && this.equalsNullProtected(this.from, this.from) && this.equalsNullProtected(this.handle, this.handle) && this.equalsNullProtected(this.reason, this.reason) && this.equalsNullProtected(this.mime, this.mime);
    }

    private boolean equalsNullProtected(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        return object1.equals(object2);
    }

    public int hashCode() {
        int result = this.hashCodeNullProtected(this.subject);
        result = 31 * result + this.hashCodeNullProtected(this.from);
        result = 31 * result + this.hashCodeNullProtected(this.handle);
        result = 31 * result + this.hashCodeNullProtected(this.reason);
        result = 31 * result + this.hashCodeNullProtected(this.mime);
        result = 31 * result + this.hashCodeNullProtected(this.subject);
        result = 31 * result + this.duration;
        return result;
    }

    public int hashCodeNullProtected(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    public static class ActionVacationBuilder {
        private static final int SITE_DEFINED_DEFAULT_VACATION_DURATION = 7;
        private static final int MINIMUM_VACATION_DURATION = 1;
        private String subject;
        private String from;
        private List<String> addresses = new ArrayList<String>();
        private String handle;
        private String reason;
        private String mime;
        private Integer duration = 7;

        public ActionVacationBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public ActionVacationBuilder from(String from) {
            this.from = from;
            return this;
        }

        public ActionVacationBuilder addresses(List<String> addresses) {
            this.addresses = addresses;
            return this;
        }

        public ActionVacationBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public ActionVacationBuilder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public ActionVacationBuilder mime(String mime) {
            this.mime = mime;
            return this;
        }

        public ActionVacationBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public ActionVacation build() throws SyntaxException {
            if (!this.eitherReasonOrMime()) {
                throw new SyntaxException("vacation need you to set you either the reason string or a MIME message after tag :mime");
            }
            return new ActionVacation(this.subject, this.from, this.addresses, this.reason, this.computeDuration(this.duration), this.handle, this.mime);
        }

        private int computeDuration(Integer duration) {
            if (duration == null) {
                return 7;
            }
            if (duration < 1) {
                return 1;
            }
            return duration;
        }

        private boolean eitherReasonOrMime() {
            return this.reason == null ^ this.mime == null;
        }
    }
}

