/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.EscapeStr;
import org.apache.jena.riot.RiotParseException;

public class LangParserLib {
    public static String stripChars(String s, int n) {
        return s.substring(n, s.length());
    }

    public static String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    public static String stripQuotes3(String s) {
        return s.substring(3, s.length() - 3);
    }

    public static String unescapeStr(String s, int line, int column) {
        return LangParserLib.unescape(s, '\\', false, line, column);
    }

    private static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) {
        try {
            return EscapeStr.unescape((String)s, (char)escape, (boolean)pointCodeOnly);
        }
        catch (AtlasException ex) {
            throw new RiotParseException(ex.getMessage(), line, column);
        }
    }

    public static String unescapeUnicode(String s, int line, int column) {
        return LangParserLib.unescape(s, '\\', true, line, column);
    }

    public static String unescapePName(String s, int line, int column) {
        char escape = '\\';
        int idx = s.indexOf(escape);
        if (idx == -1) {
            return s;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
                continue;
            }
            if (i >= s.length() - 1) {
                LangParserLib.throwParseException("Illegal escape at end of string", line, column);
            }
            char ch2 = s.charAt(i + 1);
            ++column;
            ++i;
            switch (ch2) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '_': 
                case '~': {
                    sb.append(ch2);
                    continue block6;
                }
                default: {
                    LangParserLib.throwParseException("Illegal prefix name escape: " + ch2, line, column);
                }
            }
        }
        return sb.toString();
    }

    public static void throwParseException(String msg, int line, int column) {
        throw new RiotParseException("Line " + line + ", column " + column + ": " + msg, line, column);
    }

    public static void throwParseException(String msg) {
        throw new RiotParseException(msg, -1L, -1L);
    }
}

