/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.objects;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.ontapi.OntJenaException;
import org.apache.jena.ontapi.OntModelControls;
import org.apache.jena.ontapi.common.OntEnhGraph;
import org.apache.jena.ontapi.common.OntEnhNodeFactories;
import org.apache.jena.ontapi.common.OntPersonalities;
import org.apache.jena.ontapi.impl.HierarchySupport;
import org.apache.jena.ontapi.impl.OntGraphModelImpl;
import org.apache.jena.ontapi.impl.objects.OntListImpl;
import org.apache.jena.ontapi.impl.objects.OntObjectImpl;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntDataProperty;
import org.apache.jena.ontapi.model.OntDataRange;
import org.apache.jena.ontapi.model.OntDisjoint;
import org.apache.jena.ontapi.model.OntEntity;
import org.apache.jena.ontapi.model.OntIndividual;
import org.apache.jena.ontapi.model.OntList;
import org.apache.jena.ontapi.model.OntModel;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntObjectProperty;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntRelationalProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public abstract class OntClassImpl
extends OntObjectImpl
implements OntClass {
    public OntClassImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static boolean isQualified(OntObject c) {
        return c != null && OntGraphModelImpl.configValue(c.getModel(), OntModelControls.USE_OWL2_QUALIFIED_CARDINALITY_RESTRICTION_FEATURE) && !OWL2.Thing.equals((Object)c) && !RDFS.Literal.equals((Object)c);
    }

    protected static CardinalityType getCardinalityType(Class<? extends OntClass.CardinalityRestriction<?, ?>> view) {
        if (OntClass.ObjectMinCardinality.class.equals(view) || OntClass.DataMinCardinality.class.equals(view)) {
            return CardinalityType.MIN;
        }
        if (OntClass.ObjectMaxCardinality.class.equals(view) || OntClass.DataMaxCardinality.class.equals(view)) {
            return CardinalityType.MAX;
        }
        return CardinalityType.EXACTLY;
    }

    protected static Literal createNonNegativeIntegerLiteral(int n) {
        if (n < 0) {
            throw new OntJenaException.IllegalArgument("Can't accept negative value: " + n);
        }
        return ResourceFactory.createTypedLiteral((String)String.valueOf(n), (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
    }

    private static Resource createRestriction(OntModel model) {
        return model.createResource(OWL2.Restriction);
    }

    protected static Resource createOnPropertyRestriction(OntGraphModelImpl model, OntProperty onProperty) {
        OntJenaException.notNull(onProperty, "Null property.");
        return OntClassImpl.createRestriction(model).addProperty(OWL2.onProperty, (RDFNode)onProperty);
    }

    public static <CE extends OntClass.ComponentRestriction<?, ?>> CE createComponentRestrictionCE(OntGraphModelImpl model, Class<CE> view, OntProperty onProperty, RDFNode other, Property predicate) {
        OntJenaException.notNull(other, "Null expression.");
        Resource res = OntClassImpl.createOnPropertyRestriction(model, onProperty).addProperty(predicate, other);
        return (CE)((OntClass.ComponentRestriction)model.getNodeAs(res.asNode(), view));
    }

    public static <CE extends OntClass.CardinalityRestriction<?, ?>> CE createCardinalityRestrictionCE(OntGraphModelImpl model, Class<CE> view, OntProperty onProperty, int cardinality, OntObject object) {
        Literal value = OntClassImpl.createNonNegativeIntegerLiteral(cardinality);
        Resource res = OntClassImpl.createOnPropertyRestriction(model, onProperty);
        boolean qualified = OntClassImpl.isQualified(object);
        model.add(res, OntClassImpl.getCardinalityType(view).getPredicate(qualified), (RDFNode)value);
        if (qualified) {
            model.add(res, onProperty instanceof OntObjectProperty ? OWL2.onClass : OWL2.onDataRange, (RDFNode)object);
        }
        return (CE)((OntClass.CardinalityRestriction)model.getNodeAs(res.asNode(), view));
    }

    public static <CE extends OntClass.NaryRestriction<?, ?>> CE createNaryRestrictionCE(OntGraphModelImpl model, Class<CE> type, OntDataRange dr, Collection<OntDataProperty> properties) {
        NaryRestrictionImpl.validateArity(dr, properties);
        Property predicate = OntClass.NaryDataAllValuesFrom.class.equals(type) ? OWL2.allValuesFrom : OWL2.someValuesFrom;
        Resource res = OntClassImpl.createRestriction(model).addProperty(predicate, (RDFNode)dr).addProperty(OWL2.onProperties, (RDFNode)model.createList(properties.iterator()));
        return (CE)((OntClass.NaryRestriction)model.getNodeAs(res.asNode(), type));
    }

    public static <CE extends OntClass.CollectionOf<?>, R extends OntObject> CE createComponentsCE(OntGraphModelImpl model, Class<CE> returnType, Class<R> componentType, Property predicate, Stream<R> components) {
        OntJenaException.notNull(components, "Null components stream.");
        RDFList items = model.createList(components.peek(x -> OntJenaException.notNull(x, OntEnhNodeFactories.viewAsString(returnType) + ": null " + OntEnhNodeFactories.viewAsString(componentType) + " member")).iterator());
        Resource res = model.createResource(OWL2.Class).addProperty(predicate, (RDFNode)items);
        return (CE)((OntClass.CollectionOf)model.getNodeAs(res.asNode(), returnType));
    }

    public static OntClass.HasSelf createHasSelf(OntGraphModelImpl model, OntObjectProperty onProperty) {
        Resource res = OntClassImpl.createOnPropertyRestriction(model, onProperty).addProperty(OWL2.hasSelf, (RDFNode)StdModels.TRUE);
        return model.getNodeAs(res.asNode(), OntClass.HasSelf.class);
    }

    public static OntClass.ComplementOf createComplementOf(OntGraphModelImpl model, OntClass other) {
        OntJenaException.notNull(other, "Null class expression.");
        Resource res = model.createResource(OWL2.Class).addProperty(OWL2.complementOf, (RDFNode)other);
        return model.getNodeAs(res.asNode(), OntClass.ComplementOf.class);
    }

    public static OntIndividual.Anonymous createAnonymousIndividual(OntGraphModelImpl model, OntClass source) {
        model.checkType(OntIndividual.Anonymous.class);
        OntJenaException.checkSupported(source.canAsAssertionClass(), "Class " + OntEnhNodeFactories.viewAsString(source.getClass()) + " cannot have individuals. Profile: " + model.getOntPersonality().getName());
        return model.getNodeAs(model.createResource(source).asNode(), OntIndividual.Anonymous.class);
    }

    public static OntIndividual.Named createNamedIndividual(OntGraphModelImpl model, OntClass source, String uri) {
        OntJenaException.notNull(uri, "Null uri");
        OntJenaException.checkSupported(source.canAsAssertionClass(), "Class " + OntEnhNodeFactories.viewAsString(source.getClass()) + " cannot have individuals. Profile: " + model.getOntPersonality().getName());
        Resource res = model.createResource(uri, source);
        if (OntGraphModelImpl.configValue(model, OntModelControls.USE_OWL2_NAMED_INDIVIDUAL_DECLARATION_FEATURE)) {
            res.addProperty(RDF.type, (RDFNode)OWL2.NamedIndividual);
        }
        return (OntIndividual.Named)res.as(OntIndividual.Named.class);
    }

    public static OntList<OntRelationalProperty> createHasKey(OntGraphModelImpl m, OntClass clazz, Stream<? extends OntRelationalProperty> collection) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL2_CLASS_HAS_KEY_FEATURE, "owl:hasKey");
        OntJenaException.checkSupported(clazz.canAsSubClass(), "Class " + OntEnhNodeFactories.viewAsString(clazz.getClass()) + " cannot have keys. Profile: " + m.getOntPersonality().getName());
        return m.createOntList(clazz, OWL2.hasKey, OntRelationalProperty.class, collection.distinct().map(OntRelationalProperty.class::cast).iterator());
    }

    public static Stream<OntList<OntRelationalProperty>> listHasKeys(OntGraphModelImpl m, OntClass clazz) {
        if (!OntGraphModelImpl.configValue(m, OntModelControls.USE_OWL2_CLASS_HAS_KEY_FEATURE)) {
            return Stream.empty();
        }
        if (!clazz.canAsSubClass()) {
            return Stream.empty();
        }
        return OntListImpl.stream(m, clazz, OWL2.hasKey, OntRelationalProperty.class);
    }

    public static void removeHasKey(OntGraphModelImpl m, OntClass clazz, RDFNode rdfList) throws OntJenaException.IllegalArgument {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL2_CLASS_HAS_KEY_FEATURE, "owl:hasKey");
        if (rdfList == null) {
            clazz.hasKeys().toList().forEach(it -> m.deleteOntList(clazz, OWL2.hasKey, (OntList<?>)it));
        } else {
            m.deleteOntList(clazz, OWL2.hasKey, clazz.findHasKey(rdfList).orElseThrow(() -> new OntJenaException.IllegalArgument("can't find list " + String.valueOf(rdfList))));
        }
    }

    public static Stream<OntClass> disjointClasses(OntGraphModelImpl m, OntClass clazz) {
        if (!OntGraphModelImpl.configValue(m, OntModelControls.USE_OWL_CLASS_DISJOINT_WITH_FEATURE)) {
            return Stream.empty();
        }
        if (!clazz.canAsDisjointClass()) {
            return Stream.empty();
        }
        return Stream.of(clazz.objects(OWL2.disjointWith, OntClass.class), m.statements(null, OWL2.disjointWith, (RDFNode)clazz).filter(it -> it.getSubject().canAs(OntClass.class)).map(it -> it.getSubject(OntClass.class)), clazz.disjoints().flatMap(OntDisjoint::members)).flatMap(it -> it).filter(it -> !it.equals(clazz)).filter(OntClass::canAsDisjointClass).map(OntClass::asDisjointClass).distinct();
    }

    public static void addDisjoint(OntGraphModelImpl m, OntClass clazz, OntClass other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_CLASS_DISJOINT_WITH_FEATURE, "owl:disjointWith");
        OntJenaException.checkSupported(clazz.canAsDisjointClass() && other.canAsDisjointClass(), "Classes " + OntEnhNodeFactories.viewAsString(clazz.getClass()) + " and " + OntEnhNodeFactories.viewAsString(other.getClass()) + " cannot be disjoint. Profile " + m.getOntPersonality().getName());
        clazz.addStatement(OWL2.disjointWith, (RDFNode)other);
    }

    public static void removeDisjoint(OntGraphModelImpl m, OntClass clazz, Resource other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_CLASS_DISJOINT_WITH_FEATURE, "owl:disjointWith");
        Objects.requireNonNull(clazz).remove(OWL2.disjointWith, (RDFNode)other);
    }

    public static OntStatement addDisjointWithStatement(OntGraphModelImpl m, OntClass clazz, OntClass other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_CLASS_DISJOINT_WITH_FEATURE, "owl:disjointWith");
        OntJenaException.checkSupported(clazz.canAsDisjointClass() && other.canAsDisjointClass(), "Classes " + OntEnhNodeFactories.viewAsString(clazz.getClass()) + " and " + OntEnhNodeFactories.viewAsString(other.getClass()) + " cannot be disjoint. Profile " + m.getOntPersonality().getName());
        return clazz.addStatement(OWL2.disjointWith, (RDFNode)other);
    }

    public static Stream<OntClass> equivalentClasses(OntGraphModelImpl m, OntClass clazz) {
        if (!OntGraphModelImpl.configValue(m, OntModelControls.USE_OWL_CLASS_EQUIVALENT_FEATURE)) {
            return Stream.empty();
        }
        if (!clazz.canAsEquivalentClass()) {
            return Stream.empty();
        }
        return Stream.of(clazz.objects(OWL2.equivalentClass, OntClass.class), m.statements(null, OWL2.equivalentClass, (RDFNode)clazz).filter(it -> it.getSubject().canAs(OntClass.class)).map(it -> it.getSubject(OntClass.class))).flatMap(it -> it).filter(it -> !it.equals(clazz)).filter(OntClass::canAsEquivalentClass).map(OntClass::asEquivalentClass).distinct();
    }

    public static OntStatement addEquivalentClass(OntGraphModelImpl m, OntClass clazz, OntClass other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_CLASS_EQUIVALENT_FEATURE, "owl:equivalentClass");
        OntJenaException.checkSupported(clazz.canAsEquivalentClass() && other.canAsEquivalentClass(), "Classes " + OntEnhNodeFactories.viewAsString(clazz.getClass()) + " and " + OntEnhNodeFactories.viewAsString(other.getClass()) + " cannot be equivalent. Profile " + m.getOntPersonality().getName());
        return clazz.addStatement(OWL2.equivalentClass, (RDFNode)other);
    }

    public static void removeEquivalentClass(OntGraphModelImpl m, OntClass clazz, Resource other) {
        OntGraphModelImpl.checkFeature(m, OntModelControls.USE_OWL_CLASS_EQUIVALENT_FEATURE, "owl:equivalentClass");
        clazz.remove(OWL2.equivalentClass, (RDFNode)other);
    }

    public static Stream<OntProperty> declaredProperties(OntClass clazz, boolean direct) {
        OntModel m = clazz.getModel();
        Stream<OntProperty> properties = OntPersonalities.isRDFS(OntEnhGraph.asPersonalityModel(m).getOntPersonality()) ? m.ontObjects(OntProperty.class) : Stream.of(m.objectProperties(), m.dataProperties(), m.annotationProperties()).flatMap(it -> it);
        HashMap indirectSuperclasses = new HashMap();
        Function<OntClass, Set> getIndirectSuperclasses = it -> indirectSuperclasses.computeIfAbsent(it, x -> x.superClasses(false).collect(Collectors.toSet()));
        return properties.distinct().filter(p -> p != null && OntClassImpl.testDomain(clazz, p, direct, getIndirectSuperclasses));
    }

    public static boolean testDomain(OntClass clazz, OntProperty property, boolean direct) {
        return OntClassImpl.testDomain(clazz, property, direct, x -> x.superClasses(false).collect(Collectors.toSet()));
    }

    protected static boolean testDomain(OntClass clazz, OntProperty property, boolean direct, Function<OntClass, Set<OntClass>> getIndirectSuperClasses) {
        if (OntClassImpl.isReservedOrBuiltin(property)) {
            return false;
        }
        AtomicBoolean isGlobal = new AtomicBoolean(true);
        AtomicBoolean seenDirect = new AtomicBoolean(false);
        try (Stream<? extends Resource> domains = property.domains();){
            if (!domains.allMatch(domain -> {
                if (domain.equals((Object)OWL2.Thing) || domain.equals((Object)RDFS.Resource)) {
                    return true;
                }
                isGlobal.set(false);
                if (!clazz.equals(domain)) {
                    return OntClassImpl.canProveSuperClass(clazz, domain, getIndirectSuperClasses);
                }
                seenDirect.set(true);
                return true;
            })) {
                boolean bl = false;
                return bl;
            }
            if (direct) {
                boolean bl = seenDirect.get() || isGlobal.get() && clazz.isHierarchyRoot();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    protected static boolean canProveSuperClass(OntClass clazz, Resource candidate, Function<OntClass, Set<OntClass>> getIndirectSuperClasses) {
        HashSet<OntClass> seen = new HashSet<OntClass>();
        ArrayDeque<OntClass> queue = new ArrayDeque<OntClass>();
        queue.add(clazz);
        while (!queue.isEmpty()) {
            OntClass current = (OntClass)queue.removeFirst();
            if (seen.contains(current)) continue;
            seen.add(current);
            if (current.equals(candidate)) {
                return true;
            }
            for (OntClass next : getIndirectSuperClasses.apply(current)) {
                if (next.equals(candidate)) {
                    return true;
                }
                queue.add(next);
            }
        }
        return false;
    }

    public static boolean isHierarchyRoot(OntClass clazz) {
        if (OWL2.Nothing.equals((Object)clazz)) {
            return false;
        }
        try (Stream<OntClass> superClasses = clazz.superClasses(true);){
            boolean bl = superClasses.allMatch(s -> s.equals(OWL2.Thing) || s.equals(RDFS.Resource) || s.equals(clazz));
            return bl;
        }
    }

    public static boolean isDisjoint(OntClass clazz, Resource candidate) {
        if (!candidate.canAs(OntClass.class)) {
            return false;
        }
        if (!clazz.canAsDisjointClass()) {
            return false;
        }
        OntClass other = (OntClass)candidate.as(OntClass.class);
        if (!other.canAsDisjointClass()) {
            return false;
        }
        try (Stream<OntObject> disjoints = other.disjointClasses();){
            if (disjoints.anyMatch(arg_0 -> ((OntClass)clazz).equals(arg_0))) {
                boolean bl = true;
                return bl;
            }
        }
        disjoints = clazz.disjointClasses();
        try {
            if (disjoints.anyMatch(arg_0 -> ((OntClass)other).equals(arg_0))) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (disjoints != null) {
                disjoints.close();
            }
        }
        disjoints = clazz.getModel().ontObjects(OntDisjoint.Classes.class);
        try {
            boolean bl = disjoints.anyMatch(d -> {
                Set members = d.members().collect(Collectors.toSet());
                return members.contains(clazz) && members.contains(other);
            });
            return bl;
        }
        finally {
            if (disjoints != null) {
                disjoints.close();
            }
        }
    }

    static Stream<OntIndividual> individuals(OntClass clazz, boolean direct) {
        if (!clazz.canAsAssertionClass()) {
            return Stream.empty();
        }
        if (OntGraphModelImpl.configValue(clazz.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT)) {
            return clazz.getModel().individuals().filter(i -> i.hasOntClass(clazz, direct));
        }
        return OntClassImpl.subjects(RDF.type, clazz, OntIndividual.class).filter(i -> i.hasOntClass(clazz, direct));
    }

    public static Stream<OntClass> subClasses(OntClass clazz, boolean direct) {
        Property reasonerProperty;
        if (!clazz.canAsSuperClass()) {
            return Stream.empty();
        }
        if (direct && (reasonerProperty = OntClassImpl.reasonerProperty(clazz.getModel(), RDFS.subClassOf)) != null) {
            return OntClassImpl.explicitSubClasses(reasonerProperty, clazz).filter(x -> !clazz.equals(x));
        }
        return HierarchySupport.treeNodes(clazz, it -> OntClassImpl.explicitSubClasses(RDFS.subClassOf, it), direct, OntGraphModelImpl.configValue(clazz.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    public static Stream<OntClass> superClasses(OntClass clazz, boolean direct) {
        Property reasonerProperty;
        if (!clazz.canAsSubClass()) {
            return Stream.empty();
        }
        if (direct && (reasonerProperty = OntClassImpl.reasonerProperty(clazz.getModel(), RDFS.subClassOf)) != null) {
            return OntClassImpl.explicitSuperClasses(reasonerProperty, clazz).filter(x -> !clazz.equals(x));
        }
        return HierarchySupport.treeNodes(clazz, it -> OntClassImpl.explicitSuperClasses(RDFS.subClassOf, it), direct, OntGraphModelImpl.configValue(clazz.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    public static boolean hasSuperClass(OntClass clazz, OntClass candidateSuper, boolean direct) {
        Property reasonerProperty;
        if (clazz.equals(candidateSuper)) {
            return true;
        }
        if (!clazz.canAsSubClass() || !candidateSuper.canAsSuperClass()) {
            return false;
        }
        if (direct && (reasonerProperty = OntClassImpl.reasonerProperty(clazz.getModel(), RDFS.subClassOf)) != null) {
            return clazz.getModel().contains(clazz, reasonerProperty, (RDFNode)candidateSuper);
        }
        return HierarchySupport.contains(clazz, candidateSuper, it -> OntClassImpl.explicitSuperClasses(RDFS.subClassOf, it), direct, OntGraphModelImpl.configValue(clazz.getModel(), OntModelControls.USE_BUILTIN_HIERARCHY_SUPPORT));
    }

    static Stream<OntClass> explicitSuperClasses(Property predicate, OntObject clazz) {
        return clazz.objects(predicate, OntClass.class).filter(OntClass::canAsSuperClass).map(OntClass::asSuperClass);
    }

    static Stream<OntClass> explicitSubClasses(OntClass clazz) {
        return OntClassImpl.explicitSubClasses(RDFS.subClassOf, clazz);
    }

    static Stream<OntClass> explicitSubClasses(Property predicate, OntClass clazz) {
        return OntClassImpl.subjects(predicate, clazz, OntClass.class).filter(OntClass::canAsSubClass).map(OntClass::asSubClass);
    }

    @Override
    public Optional<OntStatement> findRootStatement() {
        return OntClassImpl.getRequiredRootStatement(this, OWL2.Class);
    }

    public abstract Class<? extends OntClass> objectType();

    @Override
    public OntIndividual.Anonymous createIndividual() {
        return OntClassImpl.createAnonymousIndividual(this.getModel(), this);
    }

    @Override
    public OntIndividual.Named createIndividual(String uri) {
        return OntClassImpl.createNamedIndividual(this.getModel(), this, uri);
    }

    @Override
    public OntList<OntRelationalProperty> createHasKey(Collection<OntObjectProperty> ope, Collection<OntDataProperty> dpe) {
        Stream<OntDataProperty> stream = Stream.concat(ope.stream(), dpe.stream());
        return OntClassImpl.createHasKey(this.getModel(), this, stream);
    }

    @Override
    public OntStatement addHasKeyStatement(OntRelationalProperty ... properties) {
        return OntClassImpl.createHasKey(this.getModel(), this, Arrays.stream(properties)).getMainStatement();
    }

    @Override
    public Stream<OntList<OntRelationalProperty>> hasKeys() {
        return OntClassImpl.listHasKeys(this.getModel(), this);
    }

    @Override
    public OntClassImpl removeHasKey(Resource list) throws OntJenaException.IllegalArgument {
        OntClassImpl.removeHasKey(this.getModel(), this, (RDFNode)list);
        return this;
    }

    @Override
    public boolean isDisjoint(Resource candidate) {
        return OntClassImpl.isDisjoint(this, candidate);
    }

    @Override
    public Stream<OntClass> disjointClasses() {
        return OntClassImpl.disjointClasses(this.getModel(), this);
    }

    @Override
    public OntClass addDisjointClass(OntClass other) {
        OntClassImpl.addDisjoint(this.getModel(), this, other);
        return this;
    }

    @Override
    public OntStatement addDisjointWithStatement(OntClass other) {
        return OntClassImpl.addDisjointWithStatement(this.getModel(), this, other);
    }

    @Override
    public OntClass removeDisjointClass(Resource other) {
        OntClassImpl.removeDisjoint(this.getModel(), this, other);
        return this;
    }

    @Override
    public Stream<OntClass> equivalentClasses() {
        return OntClassImpl.equivalentClasses(this.getModel(), this);
    }

    @Override
    public boolean hasSuperClass(OntClass clazz, boolean direct) {
        return OntClassImpl.hasSuperClass(this, clazz, direct);
    }

    @Override
    public OntStatement addEquivalentClassStatement(OntClass other) {
        return OntClassImpl.addEquivalentClass(this.getModel(), this, other);
    }

    @Override
    public OntClass removeEquivalentClass(Resource other) {
        OntClassImpl.removeEquivalentClass(this.getModel(), this, other);
        return this;
    }

    @Override
    public Stream<OntClass> superClasses(boolean direct) {
        return OntClassImpl.superClasses(this, direct);
    }

    @Override
    public Stream<OntClass> subClasses(boolean direct) {
        return OntClassImpl.subClasses(this, direct);
    }

    @Override
    public Stream<OntIndividual> individuals(boolean direct) {
        return OntClassImpl.individuals(this, direct);
    }

    @Override
    public boolean hasDeclaredProperty(OntProperty property, boolean direct) {
        return OntClassImpl.testDomain(this, property, direct);
    }

    @Override
    public Stream<OntProperty> declaredProperties(boolean direct) {
        return OntClassImpl.declaredProperties(this, direct);
    }

    @Override
    public boolean isHierarchyRoot() {
        return OntClassImpl.isHierarchyRoot(this);
    }

    public static enum CardinalityType {
        EXACTLY(OWL2.qualifiedCardinality, OWL2.cardinality),
        MAX(OWL2.maxQualifiedCardinality, OWL2.maxCardinality),
        MIN(OWL2.minQualifiedCardinality, OWL2.minCardinality);

        static final RDFDatatype NON_NEGATIVE_INTEGER;
        static final Node CLASS_REFERENCE;
        static final Node RANGE_REFERENCE;
        private final Property qualifiedPredicate;
        private final Property predicate;

        private CardinalityType(Property qualifiedPredicate, Property predicate) {
            this.qualifiedPredicate = qualifiedPredicate;
            this.predicate = predicate;
        }

        private static boolean isObjectOfType(EnhGraph g, Node n, Class<? extends RDFNode> type) {
            return OntEnhGraph.canAs(type, n, g);
        }

        public static boolean isNonNegativeInteger(Node n) {
            return n.isLiteral() && NON_NEGATIVE_INTEGER.equals((Object)n.getLiteralDatatype());
        }

        public Property getPredicate(boolean isQualified) {
            return isQualified ? this.qualifiedPredicate : this.predicate;
        }

        public boolean isQualified(Node s, EnhGraph g, Class<? extends RDFNode> objectType) {
            Node p;
            if (!this.hasCardinality(s, this.qualifiedPredicate, g)) {
                return false;
            }
            if (objectType == OntClass.class) {
                p = CLASS_REFERENCE;
            } else if (objectType == OntDataRange.class) {
                p = RANGE_REFERENCE;
            } else {
                return false;
            }
            return Iterators.findFirst(g.asGraph().find(s, p, Node.ANY).filterKeep(t -> CardinalityType.isObjectOfType(g, t.getObject(), objectType))).isPresent();
        }

        public boolean isNonQualified(Node s, EnhGraph g) {
            return this.hasCardinality(s, this.predicate, g);
        }

        private boolean hasCardinality(Node s, Property p, EnhGraph g) {
            return Iterators.findFirst(g.asGraph().find(s, p.asNode(), Node.ANY).filterKeep(t -> CardinalityType.isNonNegativeInteger(t.getObject()))).isPresent();
        }

        static {
            NON_NEGATIVE_INTEGER = XSDDatatype.XSDnonNegativeInteger;
            CLASS_REFERENCE = OWL2.onClass.asNode();
            RANGE_REFERENCE = OWL2.onDataRange.asNode();
        }
    }

    public static abstract class NaryRestrictionImpl<O extends OntObject, P extends OntRelationalProperty, R extends NaryRestrictionImpl<?, ?, ?>>
    extends OntClassImpl
    implements OntClass.NaryRestriction<O, P> {
        protected final Property predicate;
        protected final Class<O> objectType;
        protected final Class<P> propertyType;

        protected NaryRestrictionImpl(Node n, EnhGraph m, Property predicate, Class<O> objectType, Class<P> propertyType) {
            super(n, m);
            this.predicate = predicate;
            this.objectType = objectType;
            this.propertyType = propertyType;
        }

        public static void validateArity(OntDataRange dr, Collection<OntDataProperty> properties) {
            properties.forEach(x -> OntJenaException.notNull(x, "Null data property"));
            if (dr.arity() == properties.size()) {
                return;
            }
            throw new OntJenaException.IllegalArgument("The number of data properties (" + properties.size() + ") must be equal to the data range arity (" + dr.arity() + ").");
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return NaryRestrictionImpl.getRequiredRootStatement(this, OWL2.Restriction);
        }

        @Override
        public O getValue() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectType));
        }

        public R setValue(O value) {
            Objects.requireNonNull(value);
            this.removeAll(this.predicate).addProperty(this.predicate, value);
            return (R)this;
        }

        public R setComponents(Collection<P> properties) {
            NaryRestrictionImpl.validateArity((OntDataRange)this.getValue(), properties);
            ((OntListImpl)this.getList()).clear().addAll(properties);
            return (R)this;
        }

        @Override
        public Class<? extends OntClass> objectType() {
            return OntClass.NaryRestriction.class;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listRequired(this.predicate), ((OntListImpl)this.getList()).listContent());
        }

        @Override
        public OntListImpl<P> getList() {
            return this.getModel().asOntList(this.getRequiredObject(OWL2.onProperties, RDFList.class), this, OWL2.onProperties, this.propertyType);
        }
    }

    public static abstract class CardinalityRestrictionImpl<O extends OntObject, P extends OntRelationalProperty, R extends CardinalityRestrictionImpl<?, ?, ?>>
    extends ComponentRestrictionImpl<O, P, R>
    implements OntClass.CardinalityRestriction<O, P> {
        protected final CardinalityType cardinalityType;

        protected CardinalityRestrictionImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<P> propertyView, CardinalityType cardinalityType) {
            super(n, m, predicate, objectView, propertyView);
            this.cardinalityType = cardinalityType;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            boolean q = this.isQualified();
            return Iterators.concat(super.listSpec(q), this.listRequired(this.getCardinalityPredicate(q)));
        }

        @Override
        public O getValue() {
            return (O)this.object(this.predicate, this.objectView).orElseGet(this::getUnqualifiedValue);
        }

        @Override
        public R setValue(O value) {
            Literal c = this.getCardinalityLiteral();
            this.removeAll(this.predicate);
            if (!CardinalityRestrictionImpl.isQualified(value)) {
                this.removeAll(this.getCardinalityPredicate(true)).addProperty(this.getCardinalityPredicate(false), (RDFNode)c);
            } else {
                this.removeAll(this.getCardinalityPredicate(false)).addProperty(this.getCardinalityPredicate(true), (RDFNode)c).addProperty(this.predicate, value);
            }
            return (R)this;
        }

        private O getUnqualifiedValue() {
            OntGraphModelImpl m = this.getModel();
            OntEntity res = OntClass.class.isAssignableFrom(this.objectView) ? m.getOWLThing() : m.getRDFSLiteral();
            return (O)res;
        }

        @Override
        public int getCardinality() {
            return this.getCardinalityLiteral().getInt();
        }

        public R setCardinality(int cardinality) {
            Literal value = CardinalityRestrictionImpl.createNonNegativeIntegerLiteral(cardinality);
            Property property = this.getCardinalityPredicate();
            this.removeAll(property).addLiteral(property, value);
            return (R)this;
        }

        private Literal getCardinalityLiteral() {
            return this.getRequiredObject(this.getCardinalityPredicate(), Literal.class);
        }

        protected Property getCardinalityPredicate() {
            return this.getCardinalityPredicate(this.isQualified());
        }

        private Property getCardinalityPredicate(boolean q) {
            return this.cardinalityType.getPredicate(q);
        }

        @Override
        public boolean isQualified() {
            return CardinalityRestrictionImpl.isQualified(this.getValue()) && this.hasProperty(this.cardinalityType.getPredicate(true));
        }
    }

    public static abstract class ComponentRestrictionImpl<O extends RDFNode, P extends OntRelationalProperty, R extends ComponentRestrictionImpl<?, ?, ?>>
    extends OnPropertyRestrictionImpl<P, R>
    implements OntClass.ComponentRestriction<O, P> {
        protected final Property predicate;
        protected final Class<O> objectView;

        protected ComponentRestrictionImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<P> propertyView) {
            super(n, m, propertyView);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.objectView = OntJenaException.notNull(objectView, "Null object view.");
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return this.listSpec(true);
        }

        protected ExtendedIterator<OntStatement> listSpec(boolean requireObject) {
            return requireObject ? Iterators.concat(super.listSpec(), this.listRequired(this.predicate)) : super.listSpec();
        }

        @Override
        public O getValue() {
            return this.getModel().getNodeAs(this.getRequiredProperty(this.predicate).getObject().asNode(), this.objectView);
        }

        public R setValue(O c) {
            Objects.requireNonNull(c, "Null filler");
            this.removeAll(this.predicate).addProperty(this.predicate, c);
            return (R)this;
        }
    }

    public static class OnPropertyRestrictionImpl<P extends OntRelationalProperty, R extends OntClassImpl>
    extends RestrictionImpl
    implements OntClass.UnaryRestriction<P> {
        protected final Class<P> propertyView;

        public OnPropertyRestrictionImpl(Node n, EnhGraph m, Class<P> propertyType) {
            super(n, m);
            this.propertyView = propertyType;
        }

        @Override
        public Class<? extends OntClass> objectType() {
            return OntClass.UnaryRestriction.class;
        }

        @Override
        public P getProperty() {
            return (P)((OntRelationalProperty)this.getRequiredObject(OWL2.onProperty, this.propertyView));
        }

        public R setProperty(P property) {
            Objects.requireNonNull(property, "Null " + OntEnhNodeFactories.viewAsString(this.propertyView));
            this.removeAll(OWL2.onProperty).addProperty(OWL2.onProperty, property);
            return (R)this;
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listRequired(OWL2.onProperty));
        }
    }

    public static class RestrictionImpl
    extends OntClassImpl
    implements OntClass.Restriction {
        public RestrictionImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return RestrictionImpl.getRequiredRootStatement(this, OWL2.Restriction);
        }

        @Override
        public Class<? extends OntClass> objectType() {
            return OntClass.Restriction.class;
        }
    }

    protected static abstract class CollectionOfImpl<O extends OntObject>
    extends OntClassImpl
    implements OntClass.CollectionOf<O> {
        protected final Property predicate;
        protected final Class<O> type;

        protected CollectionOfImpl(Node n, EnhGraph m, Property predicate, Class<O> type) {
            super(n, m);
            this.predicate = OntJenaException.notNull(predicate, "Null predicate.");
            this.type = OntJenaException.notNull(type, "Null view.");
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), ((OntListImpl)this.getList()).listContent());
        }

        @Override
        public OntListImpl<O> getList() {
            return this.getModel().asOntList(this.getRequiredObject(this.predicate, RDFList.class), this, this.predicate, true, null, this.type);
        }
    }

    public static class NaryDataSomeValuesFromImpl
    extends NaryRestrictionImpl<OntDataRange, OntDataProperty, NaryDataSomeValuesFromImpl>
    implements OntClass.NaryDataSomeValuesFrom {
        public NaryDataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.someValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        @Override
        public Class<? extends OntClass> objectType() {
            return OntClass.NaryDataSomeValuesFrom.class;
        }
    }

    public static class NaryDataAllValuesFromImpl
    extends NaryRestrictionImpl<OntDataRange, OntDataProperty, NaryDataAllValuesFromImpl>
    implements OntClass.NaryDataAllValuesFrom {
        public NaryDataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.allValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        @Override
        public Class<? extends OntClass> objectType() {
            return OntClass.NaryDataAllValuesFrom.class;
        }
    }

    public static class ComplementOfImpl
    extends OntClassImpl
    implements OntClass.ComplementOf {
        public ComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listRequired(OWL2.complementOf));
        }

        public Class<OntClass.ComplementOf> objectType() {
            return OntClass.ComplementOf.class;
        }

        @Override
        public OntClass getValue() {
            return this.getRequiredObject(OWL2.complementOf, OntClass.class);
        }

        @Override
        public ComplementOfImpl setValue(OntClass c) {
            Objects.requireNonNull(c, "Null component");
            this.clear();
            this.addProperty(OWL2.complementOf, (RDFNode)c);
            return this;
        }

        void clear() {
            this.removeAll(OWL2.complementOf);
        }
    }

    public static class RLComplementOfImpl
    extends ComplementOfImpl {
        public RLComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public OntClass asSuperClass() {
            if (this.getValue().canAsSubClass()) {
                return this;
            }
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an super class");
        }

        @Override
        public boolean canAsSuperClass() {
            return this.getValue().canAsSubClass();
        }

        @Override
        public OntClass asAssertionClass() {
            if (this.getValue().canAsSubClass()) {
                return this;
            }
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an individual type");
        }

        @Override
        public boolean canAsAssertionClass() {
            return this.getValue().canAsSubClass();
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public OntClass asDisjointClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return false;
        }
    }

    public static class QLComplementOfImpl
    extends ComplementOfImpl {
        public QLComplementOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public boolean canAsSuperClass() {
            return this.getValue().canAsSubClass();
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an individual type");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }
    }

    public static class HasSelfImpl
    extends OnPropertyRestrictionImpl<OntObjectProperty, HasSelfImpl>
    implements OntClass.HasSelf {
        public HasSelfImpl(Node n, EnhGraph m) {
            super(n, m, OntObjectProperty.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iterators.concat(super.listSpec(), this.listRequired(OWL2.hasSelf));
        }

        @Override
        public Class<OntClass.HasSelf> objectType() {
            return OntClass.HasSelf.class;
        }
    }

    public static class ObjectCardinalityImpl
    extends CardinalityRestrictionImpl<OntClass, OntObjectProperty, ObjectCardinalityImpl>
    implements OntClass.ObjectCardinality {
        public ObjectCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.onClass, OntClass.class, OntObjectProperty.class, CardinalityType.EXACTLY);
        }

        @Override
        public Class<OntClass.ObjectCardinality> objectType() {
            return OntClass.ObjectCardinality.class;
        }
    }

    public static class DataCardinalityImpl
    extends CardinalityRestrictionImpl<OntDataRange, OntDataProperty, DataCardinalityImpl>
    implements OntClass.DataCardinality {
        public DataCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.onDataRange, OntDataRange.class, OntDataProperty.class, CardinalityType.EXACTLY);
        }

        @Override
        public Class<OntClass.DataCardinality> objectType() {
            return OntClass.DataCardinality.class;
        }
    }

    public static class ObjectMaxCardinalityImpl
    extends CardinalityRestrictionImpl<OntClass, OntObjectProperty, ObjectMaxCardinalityImpl>
    implements OntClass.ObjectMaxCardinality {
        public ObjectMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.onClass, OntClass.class, OntObjectProperty.class, CardinalityType.MAX);
        }

        @Override
        public Class<OntClass.ObjectMaxCardinality> objectType() {
            return OntClass.ObjectMaxCardinality.class;
        }
    }

    public static class RLObjectMaxCardinalityImpl
    extends ObjectMaxCardinalityImpl {
        public RLObjectMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public OntClass asDisjointClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return false;
        }
    }

    public static class DataMaxCardinalityImpl
    extends CardinalityRestrictionImpl<OntDataRange, OntDataProperty, DataMaxCardinalityImpl>
    implements OntClass.DataMaxCardinality {
        public DataMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.onDataRange, OntDataRange.class, OntDataProperty.class, CardinalityType.MAX);
        }

        @Override
        public Class<OntClass.DataMaxCardinality> objectType() {
            return OntClass.DataMaxCardinality.class;
        }
    }

    public static class RLDataMaxCardinalityImpl
    extends DataMaxCardinalityImpl {
        public RLDataMaxCardinalityImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public OntClass asDisjointClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return false;
        }
    }

    public static class ObjectMinCardinalityImpl
    extends CardinalityRestrictionImpl<OntClass, OntObjectProperty, ObjectMinCardinalityImpl>
    implements OntClass.ObjectMinCardinality {
        public ObjectMinCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.onClass, OntClass.class, OntObjectProperty.class, CardinalityType.MIN);
        }

        @Override
        public Class<OntClass.ObjectMinCardinality> objectType() {
            return OntClass.ObjectMinCardinality.class;
        }
    }

    public static class DataMinCardinalityImpl
    extends CardinalityRestrictionImpl<OntDataRange, OntDataProperty, DataMinCardinalityImpl>
    implements OntClass.DataMinCardinality {
        public DataMinCardinalityImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.onDataRange, OntDataRange.class, OntDataProperty.class, CardinalityType.MIN);
        }

        @Override
        public Class<OntClass.DataMinCardinality> objectType() {
            return OntClass.DataMinCardinality.class;
        }
    }

    public static class OneOfImpl
    extends CollectionOfImpl<OntIndividual>
    implements OntClass.OneOf {
        public OneOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.oneOf, OntIndividual.class);
        }

        public Class<OntClass.OneOf> objectType() {
            return OntClass.OneOf.class;
        }
    }

    public static class RLOneOfImpl
    extends OneOfImpl {
        public RLOneOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSuperClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a superclass");
        }

        @Override
        public boolean canAsSuperClass() {
            return false;
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a type of individual");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }
    }

    public static class IntersectionOfImpl
    extends CollectionOfImpl<OntClass>
    implements OntClass.IntersectionOf {
        public IntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.intersectionOf, OntClass.class);
        }

        public Class<OntClass.IntersectionOf> objectType() {
            return OntClass.IntersectionOf.class;
        }
    }

    public static class RLIntersectionOfImpl
    extends IntersectionOfImpl {
        public RLIntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            return this.asSubClass(() -> "Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return this.hasMemberSubClasses();
        }

        @Override
        public OntClass asSuperClass() {
            return this.asSuperClass(() -> "Specification does not allow this class to be a superclass");
        }

        @Override
        public boolean canAsSuperClass() {
            return this.hasMemberSuperClasses();
        }

        @Override
        public OntClass asEquivalentClass() {
            final Collection<OntClass> res = this.collectEquivalentClasses();
            if (res.isEmpty()) {
                throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
            }
            return new RLIntersectionOfImpl(this, this.node, this.enhGraph){

                @Override
                public Stream<OntClass> components() {
                    return res.stream();
                }
            };
        }

        @Override
        public boolean canAsEquivalentClass() {
            return this.hasMemberEquivalentClasses();
        }

        @Override
        public OntClass asAssertionClass() {
            return this.asSuperClass(() -> "Specification does not allow this class to be a type of individual");
        }

        @Override
        public boolean canAsAssertionClass() {
            return this.hasMemberSuperClasses();
        }

        @Override
        public OntClass asDisjointClass() {
            return this.asSubClass(() -> "Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return this.hasMemberSubClasses();
        }

        private OntClass asSuperClass(Supplier<String> message) {
            final Collection<OntClass> res = this.collectMemberSuperClasses();
            if (res.isEmpty()) {
                throw new OntJenaException.Unsupported(message.get());
            }
            return new RLIntersectionOfImpl(this, this.node, this.enhGraph){

                @Override
                public Stream<OntClass> components() {
                    return res.stream();
                }
            };
        }

        private OntClass asSubClass(Supplier<String> message) {
            final Collection<OntClass> res = this.collectMemberSubClasses();
            if (res.isEmpty()) {
                throw new OntJenaException.Unsupported(message.get());
            }
            return new RLIntersectionOfImpl(this, this.node, this.enhGraph){

                @Override
                public Stream<OntClass> components() {
                    return res.stream();
                }
            };
        }

        private Collection<OntClass> collectMemberSubClasses() {
            LinkedHashSet res = new LinkedHashSet();
            this.getList().members().forEach(it -> {
                if (it.canAsSubClass()) {
                    res.add(it.asSubClass());
                }
            });
            return res.size() > 1 ? res : List.of();
        }

        private Collection<OntClass> collectMemberSuperClasses() {
            LinkedHashSet res = new LinkedHashSet();
            this.getList().members().forEach(it -> {
                if (it.canAsSuperClass()) {
                    res.add(it.asSuperClass());
                }
            });
            return res.size() > 1 ? res : List.of();
        }

        private Collection<OntClass> collectEquivalentClasses() {
            LinkedHashSet res = new LinkedHashSet();
            this.getList().members().forEach(it -> {
                if (it.canAsEquivalentClass()) {
                    res.add(it.asEquivalentClass());
                }
            });
            return res.size() > 1 ? res : List.of();
        }

        private boolean hasMemberSubClasses() {
            try (Stream<OntClass> members = this.getList().members().filter(OntClass::canAsSubClass);){
                boolean bl = Iterators.hasAtLeast(members.iterator(), 2);
                return bl;
            }
        }

        private boolean hasMemberSuperClasses() {
            try (Stream<OntClass> members = this.getList().members().filter(OntClass::canAsSuperClass);){
                boolean bl = Iterators.hasAtLeast(members.iterator(), 2);
                return bl;
            }
        }

        private boolean hasMemberEquivalentClasses() {
            try (Stream<OntClass> members = this.getList().members().filter(OntClass::canAsEquivalentClass);){
                boolean bl = Iterators.hasAtLeast(members.iterator(), 2);
                return bl;
            }
        }
    }

    public static class QLIntersectionOfImpl
    extends IntersectionOfImpl {
        public QLIntersectionOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a object position of class assertion");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public OntClass asDisjointClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return false;
        }

        @Override
        public Stream<OntClass> components() {
            return this.getList().members().filter(OntClass::canAsSuperClass).map(OntClass::asSuperClass);
        }
    }

    public static class UnionOfImpl
    extends CollectionOfImpl<OntClass>
    implements OntClass.UnionOf {
        public UnionOfImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.unionOf, OntClass.class);
        }

        public Class<OntClass.UnionOf> objectType() {
            return OntClass.UnionOf.class;
        }
    }

    public static class RLUnionOfImpl
    extends UnionOfImpl {
        public RLUnionOfImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSuperClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a superclass");
        }

        @Override
        public boolean canAsSuperClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public Stream<OntClass> components() {
            return this.getList().members().filter(OntClass::canAsSubClass);
        }
    }

    public static class DataHasValueImpl
    extends ComponentRestrictionImpl<Literal, OntDataProperty, DataHasValueImpl>
    implements OntClass.DataHasValue {
        public DataHasValueImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.hasValue, Literal.class, OntDataProperty.class);
        }

        @Override
        public Class<OntClass.DataHasValue> objectType() {
            return OntClass.DataHasValue.class;
        }
    }

    public static class ObjectHasValueImpl
    extends ComponentRestrictionImpl<OntIndividual, OntObjectProperty, ObjectHasValueImpl>
    implements OntClass.ObjectHasValue {
        public ObjectHasValueImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.hasValue, OntIndividual.class, OntObjectProperty.class);
        }

        @Override
        public Class<OntClass.ObjectHasValue> objectType() {
            return OntClass.ObjectHasValue.class;
        }
    }

    public static class DataAllValuesFromImpl
    extends ComponentRestrictionImpl<OntDataRange, OntDataProperty, DataAllValuesFromImpl>
    implements OntClass.DataAllValuesFrom {
        public DataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.allValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        @Override
        public Class<OntClass.DataAllValuesFrom> objectType() {
            return OntClass.DataAllValuesFrom.class;
        }
    }

    public static class RLDataAllValuesFromImpl
    extends DataAllValuesFromImpl {
        public RLDataAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public OntClass asDisjointClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return false;
        }
    }

    public static class ObjectAllValuesFromImpl
    extends ComponentRestrictionImpl<OntClass, OntObjectProperty, ObjectAllValuesFromImpl>
    implements OntClass.ObjectAllValuesFrom {
        public ObjectAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.allValuesFrom, OntClass.class, OntObjectProperty.class);
        }

        @Override
        public Class<OntClass.ObjectAllValuesFrom> objectType() {
            return OntClass.ObjectAllValuesFrom.class;
        }
    }

    public static class RLObjectAllValuesFromImpl
    extends ObjectAllValuesFromImpl {
        public RLObjectAllValuesFromImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }

        @Override
        public OntClass asDisjointClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return false;
        }
    }

    public static class DataSomeValuesFromImpl
    extends ComponentRestrictionImpl<OntDataRange, OntDataProperty, DataSomeValuesFromImpl>
    implements OntClass.DataSomeValuesFrom {
        public DataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.someValuesFrom, OntDataRange.class, OntDataProperty.class);
        }

        @Override
        public Class<OntClass.DataSomeValuesFrom> objectType() {
            return OntClass.DataSomeValuesFrom.class;
        }
    }

    public static class RLDataSomeValuesFromImpl
    extends DataSomeValuesFromImpl {
        public RLDataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSuperClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a superclass");
        }

        @Override
        public boolean canAsSuperClass() {
            return false;
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a type of individual");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }
    }

    public static class QLDataSomeValuesFromImpl
    extends DataSomeValuesFromImpl {
        public QLDataSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a object position of class assertion");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }
    }

    public static class ObjectSomeValuesFromImpl
    extends ComponentRestrictionImpl<OntClass, OntObjectProperty, ObjectSomeValuesFromImpl>
    implements OntClass.ObjectSomeValuesFrom {
        public ObjectSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m, OWL2.someValuesFrom, OntClass.class, OntObjectProperty.class);
        }

        @Override
        public Class<OntClass.ObjectSomeValuesFrom> objectType() {
            return OntClass.ObjectSomeValuesFrom.class;
        }
    }

    public static class RLObjectSomeValuesFromImpl
    extends ObjectSomeValuesFromImpl {
        public RLObjectSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSuperClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a superclass");
        }

        @Override
        public boolean canAsSuperClass() {
            return false;
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a type of individual");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }

        @Override
        public OntClass asEquivalentClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return false;
        }
    }

    public static class QLObjectSomeValuesFromImpl
    extends ObjectSomeValuesFromImpl {
        public QLObjectSomeValuesFromImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public OntClass asSubClass() {
            if (OWL2.Thing.equals(this.getValue())) {
                return this;
            }
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a subclass");
        }

        @Override
        public boolean canAsSubClass() {
            return OWL2.Thing.equals(this.getValue());
        }

        @Override
        public OntClass asSuperClass() {
            if (((OntClass)this.getValue()).isURIResource()) {
                return this;
            }
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a superclass");
        }

        @Override
        public boolean canAsSuperClass() {
            return ((OntClass)this.getValue()).isURIResource();
        }

        @Override
        public OntClass asEquivalentClass() {
            if (OWL2.Thing.equals(this.getValue())) {
                return this;
            }
            throw new OntJenaException.Unsupported("Specification does not allow this class to be an equivalent class");
        }

        @Override
        public boolean canAsEquivalentClass() {
            return OWL2.Thing.equals(this.getValue());
        }

        @Override
        public OntClass asDisjointClass() {
            if (OWL2.Thing.equals(this.getValue())) {
                return this;
            }
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a disjoint class");
        }

        @Override
        public boolean canAsDisjointClass() {
            return OWL2.Thing.equals(this.getValue());
        }

        @Override
        public OntClass asAssertionClass() {
            throw new OntJenaException.Unsupported("Specification does not allow this class to be a object position of class assertion");
        }

        @Override
        public boolean canAsAssertionClass() {
            return false;
        }
    }
}

