/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.logging.Logging;

public class OptionKey<T>
implements Serializable {
    private static final long serialVersionUID = -7580514229639750246L;
    public static final OptionKey<Locale> LOCALE = new OptionKey<Locale>("LOCALE", Locale.class);
    public static final OptionKey<TimeZone> TIMEZONE = new OptionKey<TimeZone>("TIMEZONE", TimeZone.class);
    public static final OptionKey<Charset> ENCODING = new OptionKey<Charset>("ENCODING", Charset.class);
    public static final OptionKey<String> URL_ENCODING = new OptionKey<String>("URL_ENCODING", String.class);
    public static final OptionKey<OpenOption[]> OPEN_OPTIONS = new OptionKey<OpenOption[]>("OPEN_OPTIONS", OpenOption[].class);
    public static final OptionKey<ByteBuffer> BYTE_BUFFER = new OptionKey<ByteBuffer>("BYTE_BUFFER", ByteBuffer.class);
    public static final OptionKey<GeometryLibrary> GEOMETRY_LIBRARY = new OptionKey<GeometryLibrary>("GEOMETRY_LIBRARY", GeometryLibrary.class);
    public static final OptionKey<Integer> INDENTATION = new OptionKey<Integer>("INDENTATION", Integer.class);
    private final String name;
    private final Class<T> type;

    protected OptionKey(String name, Class<T> type) {
        ArgumentChecks.ensureNonEmpty("name", name);
        ArgumentChecks.ensureNonNull("type", type);
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public final Class<T> getElementType() {
        return this.type;
    }

    public T getValueFrom(Map<OptionKey<?>, ?> options) {
        return options != null ? (T)this.type.cast(options.get(this)) : null;
    }

    public Map<OptionKey<?>, Object> setValueInto(Map<OptionKey<?>, Object> options, T value) {
        if (value != null) {
            if (options == null) {
                options = new HashMap();
            }
            options.put(this, value);
        } else if (options != null) {
            options.remove(this);
        }
        return options;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            OptionKey that = (OptionKey)object;
            return this.name.equals(that.name) && this.type == that.type;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ 0xAF875D9A;
    }

    public String toString() {
        return this.getName();
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return OptionKey.class.getField(this.name).get(null);
        }
        catch (ReflectiveOperationException e2) {
            Logging.recoverableException(Logger.getLogger("org.apache.sis.util"), OptionKey.class, "readResolve", e2);
            return this;
        }
    }
}

