/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial.index.compat;

import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import org.apache.jena.geosparql.spatial.SpatialIndex;
import org.apache.jena.geosparql.spatial.SpatialIndexException;
import org.apache.jena.geosparql.spatial.index.v1.SpatialIndexAdapterV1;
import org.apache.jena.geosparql.spatial.index.v1.SpatialIndexV1;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexIoKryo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexIo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static final SpatialIndex load(Path spatialIndexFile) throws SpatialIndexException {
        return SpatialIndexIo.load(spatialIndexFile, false);
    }

    public static final SpatialIndex load(Path spatialIndexFile, boolean suppressLegacyWarnings) throws SpatialIndexException {
        SpatialIndex result;
        try {
            result = SpatialIndexIoKryo.load(spatialIndexFile);
        }
        catch (Throwable t1) {
            if (!suppressLegacyWarnings) {
                LOGGER.warn("Failed to load spatial index with latest format. Trying legacy formats...", t1);
            }
            try {
                SpatialIndexV1 v1 = SpatialIndexV1.load(spatialIndexFile.toFile());
                result = new SpatialIndexAdapterV1(v1);
                if (!suppressLegacyWarnings) {
                    LOGGER.warn("Successfully loaded spatial index with legacy format v1. Upgrade advised.");
                }
            }
            catch (Throwable t2) {
                LOGGER.warn("Failed to load spatial index legacy format.", t2);
                t1.addSuppressed(new RuntimeException("Failed to load spatial index with any format.", t2));
                throw t1;
            }
        }
        return result;
    }
}

