/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;

public class TotalTermFreqValueSource
extends ValueSource {
    protected final String field;
    protected final String indexedField;
    protected final String val;
    protected final BytesRef indexedBytes;

    public TotalTermFreqValueSource(String field, String val, String indexedField, BytesRef indexedBytes) {
        this.field = field;
        this.val = val;
        this.indexedField = indexedField;
        this.indexedBytes = indexedBytes;
    }

    public String name() {
        return "totaltermfreq";
    }

    @Override
    public String description() {
        return this.name() + "(" + this.field + "," + this.val + ")";
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context2, LeafReaderContext readerContext) throws IOException {
        return (FunctionValues)context2.get(this);
    }

    @Override
    public void createWeight(Map<Object, Object> context2, IndexSearcher searcher) throws IOException {
        long totalTermFreq = 0L;
        for (LeafReaderContext readerContext : searcher.getTopReaderContext().leaves()) {
            long val = readerContext.reader().totalTermFreq(new Term(this.indexedField, this.indexedBytes));
            assert (val != -1L);
            totalTermFreq += val;
        }
        final long ttf = totalTermFreq;
        context2.put(this, new LongDocValues(this){

            @Override
            public long longVal(int doc) {
                return ttf;
            }
        });
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() + this.indexedField.hashCode() * 29 + this.indexedBytes.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TotalTermFreqValueSource other = (TotalTermFreqValueSource)o;
        return this.indexedField.equals(other.indexedField) && this.indexedBytes.equals(other.indexedBytes);
    }
}

