/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationConvention;

public class DefaultGrpcServerObservationConvention
implements GrpcServerObservationConvention {
    private static final KeyValue STATUS_CODE_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue("UNKNOWN");
    private static final KeyValue PEER_NAME_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue("UNKNOWN");
    private static final KeyValue PEER_PORT_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue("UNKNOWN");
    private static final KeyValue METHOD_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue("UNKNOWN");
    private static final KeyValue SERVICE_UNKNOWN = GrpcObservationDocumentation.LowCardinalityKeyNames.SERVICE.withValue("UNKNOWN");

    @Override
    public String getName() {
        return "grpc.server";
    }

    @Override
    public String getContextualName(GrpcServerObservationContext context2) {
        return context2.getFullMethodName();
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(GrpcServerObservationContext context2) {
        KeyValue statusCodeKeyValue = context2.getStatusCode() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.STATUS_CODE.withValue(context2.getStatusCode().name()) : STATUS_CODE_UNKNOWN;
        KeyValue peerNameKeyValue = context2.getPeerName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_NAME.withValue(context2.getPeerName()) : PEER_NAME_UNKNOWN;
        KeyValue peerPortKeyValue = context2.getPeerPort() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.PEER_PORT.withValue(context2.getPeerPort().toString()) : PEER_PORT_UNKNOWN;
        KeyValue method = context2.getMethodName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue(context2.getMethodName()) : METHOD_UNKNOWN;
        KeyValue service = context2.getServiceName() != null ? GrpcObservationDocumentation.LowCardinalityKeyNames.SERVICE.withValue(context2.getServiceName()) : SERVICE_UNKNOWN;
        return KeyValues.of(statusCodeKeyValue, peerNameKeyValue, peerPortKeyValue, method, service, GrpcObservationDocumentation.LowCardinalityKeyNames.METHOD_TYPE.withValue(context2.getMethodType().name()));
    }
}

