/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.channels;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.channels.AsynchronousChannel;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.InterruptibleChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class CloseShieldChannelHandler
implements InvocationHandler {
    private static final Set<Class<? extends Channel>> SUPPORTED_INTERFACES;
    private final Channel delegate;
    private volatile boolean closed;

    private static boolean isAllowedAfterClose(Class<?> declaringClass, String name, int parameterCount) {
        return parameterCount == 0 && name.equals("supportedOptions") && NetworkChannel.class.equals(declaringClass);
    }

    static boolean isSupported(Class<?> interfaceClass) {
        return SUPPORTED_INTERFACES.contains(interfaceClass);
    }

    private static boolean returnsThis(Class<?> declaringClass, String name, int parameterCount) {
        if (SeekableByteChannel.class.equals(declaringClass)) {
            return parameterCount == 1 && (name.equals("position") || name.equals("truncate"));
        }
        if (NetworkChannel.class.equals(declaringClass)) {
            return parameterCount == 1 && name.equals("bind") || parameterCount == 2 && name.equals("setOption");
        }
        return false;
    }

    CloseShieldChannelHandler(Channel delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> declaringClass = method.getDeclaringClass();
        String name = method.getName();
        int parameterCount = method.getParameterCount();
        if (declaringClass == Object.class) {
            return this.invokeObjectMethod(proxy, method, args);
        }
        if (parameterCount == 0 && name.equals("close")) {
            this.closed = true;
            return null;
        }
        if (parameterCount == 0 && name.equals("isOpen")) {
            return !this.closed && this.delegate.isOpen();
        }
        if (this.closed && !CloseShieldChannelHandler.isAllowedAfterClose(declaringClass, name, parameterCount)) {
            throw new ClosedChannelException();
        }
        try {
            Object result = method.invoke((Object)this.delegate, args);
            return CloseShieldChannelHandler.returnsThis(declaringClass, name, parameterCount) ? proxy : result;
        }
        catch (InvocationTargetException e2) {
            throw e2.getCause();
        }
    }

    private Object invokeObjectMethod(Object proxy, Method method, Object[] args) {
        switch (method.getName()) {
            case "toString": {
                return "CloseShieldChannel(" + this.delegate + ")";
            }
            case "hashCode": {
                return Objects.hashCode(this.delegate);
            }
            case "equals": {
                InvocationHandler h;
                Object other = args[0];
                if (other == null) {
                    return false;
                }
                if (proxy == other) {
                    return true;
                }
                if (Proxy.isProxyClass(other.getClass()) && (h = Proxy.getInvocationHandler(other)) instanceof CloseShieldChannelHandler) {
                    return Objects.equals(((CloseShieldChannelHandler)h).delegate, this.delegate);
                }
                return false;
            }
        }
        return null;
    }

    static {
        HashSet<Class> interfaces = new HashSet<Class>();
        interfaces.add(AsynchronousChannel.class);
        interfaces.add(ByteChannel.class);
        interfaces.add(Channel.class);
        interfaces.add(GatheringByteChannel.class);
        interfaces.add(InterruptibleChannel.class);
        interfaces.add(NetworkChannel.class);
        interfaces.add(ReadableByteChannel.class);
        interfaces.add(ScatteringByteChannel.class);
        interfaces.add(SeekableByteChannel.class);
        interfaces.add(WritableByteChannel.class);
        SUPPORTED_INTERFACES = Collections.unmodifiableSet(interfaces);
    }
}

