/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.micrometer.core.instrument.binder.grpc.DefaultGrpcServerObservationConvention;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationContext;
import io.micrometer.core.instrument.binder.grpc.GrpcServerObservationConvention;
import io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerCall;
import io.micrometer.core.instrument.binder.grpc.ObservationGrpcServerCallListener;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.observation.transport.Propagator;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class ObservationGrpcServerInterceptor
implements ServerInterceptor {
    private static final GrpcServerObservationConvention DEFAULT_CONVENTION = new DefaultGrpcServerObservationConvention();
    private static final Map<String, Metadata.Key<String>> KEY_CACHE = new ConcurrentHashMap<String, Metadata.Key<String>>();
    private final ObservationRegistry registry;
    private @Nullable GrpcServerObservationConvention customConvention;

    public ObservationGrpcServerInterceptor(ObservationRegistry registry) {
        this.registry = registry;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Supplier<GrpcServerObservationContext> contextSupplier = () -> {
            GrpcServerObservationContext context2 = new GrpcServerObservationContext(new Propagator.Getter<Metadata>(){

                @Override
                public @Nullable String get(Metadata carrier, String keyName) {
                    return (String)carrier.get(this.getKey(keyName));
                }

                private Metadata.Key<String> getKey(String keyName) {
                    return KEY_CACHE.computeIfAbsent(keyName, k -> Metadata.Key.of((String)keyName, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                }

                @Override
                public Iterable<String> getAll(Metadata carrier, String keyName) {
                    Iterable all = carrier.getAll(this.getKey(keyName));
                    return all == null ? Collections.emptyList() : all;
                }
            });
            context2.setCarrier(headers);
            MethodDescriptor methodDescriptor = call.getMethodDescriptor();
            String serviceName = methodDescriptor.getServiceName();
            String methodName = methodDescriptor.getBareMethodName();
            String fullMethodName = methodDescriptor.getFullMethodName();
            MethodDescriptor.MethodType methodType = methodDescriptor.getType();
            if (serviceName != null) {
                context2.setServiceName(serviceName);
            }
            if (methodName != null) {
                context2.setMethodName(methodName);
            }
            context2.setFullMethodName(fullMethodName);
            context2.setMethodType(methodType);
            String authority = call.getAuthority();
            if (authority != null) {
                context2.setAuthority(authority);
                try {
                    URI uri = new URI(null, authority, null, null, null);
                    context2.setPeerName(uri.getHost());
                    context2.setPeerPort(uri.getPort());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return context2;
        };
        Observation observation = GrpcObservationDocumentation.SERVER.observation(this.customConvention, DEFAULT_CONVENTION, contextSupplier, this.registry).start();
        if (observation.isNoop()) {
            return next.startCall(call, headers);
        }
        ObservationGrpcServerCall<ReqT, RespT> serverCall = new ObservationGrpcServerCall<ReqT, RespT>(call, observation);
        Observation.Scope scope = observation.openScope();
        try {
            ServerCall.Listener result = next.startCall(serverCall, headers);
            ObservationGrpcServerCallListener observationGrpcServerCallListener = new ObservationGrpcServerCallListener(result, observation);
            if (scope != null) {
                scope.close();
            }
            return observationGrpcServerCallListener;
        }
        catch (Throwable throwable) {
            try {
                if (scope != null) {
                    try {
                        scope.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception ex) {
                observation.error(ex).stop();
                throw ex;
            }
        }
    }

    public void setCustomConvention(@Nullable GrpcServerObservationConvention customConvention) {
        this.customConvention = customConvention;
    }
}

