/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system.streammgr;

import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.http.HttpOp;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.streammgr.LocatorURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorFTP
extends LocatorURL {
    private static Logger log = LoggerFactory.getLogger(LocatorFTP.class);
    private static final String[] schemeNames = new String[]{"ftp"};

    public LocatorFTP() {
        super(schemeNames);
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    public TypedInputStream performOpen(String uri) {
        if (uri.startsWith("ftp://")) {
            try {
                return HttpOp.httpGet(uri);
            }
            catch (HttpException ex) {
                throw new RiotException("Bad FTP URL: " + uri, ex);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return "LocatorFTP";
    }

    @Override
    public int hashCode() {
        return 57;
    }
}

