/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene912;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.apache.lucene.backward_codecs.lucene912.Lucene912PostingsReader;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermState;
import org.apache.lucene.util.IOUtils;

public class Lucene912PostingsFormat
extends PostingsFormat {
    public static final String META_EXTENSION = "psm";
    public static final String DOC_EXTENSION = "doc";
    public static final String POS_EXTENSION = "pos";
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    static final int BLOCK_MASK = 127;
    public static final int LEVEL1_FACTOR = 32;
    public static final int LEVEL1_NUM_DOCS = 4096;
    static final int LEVEL1_MASK = 4095;
    static final String TERMS_CODEC = "Lucene90PostingsWriterTerms";
    static final String META_CODEC = "Lucene912PostingsWriterMeta";
    static final String DOC_CODEC = "Lucene912PostingsWriterDoc";
    static final String POS_CODEC = "Lucene912PostingsWriterPos";
    static final String PAY_CODEC = "Lucene912PostingsWriterPay";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    public Lucene912PostingsFormat() {
        super("Lucene912");
    }

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        throw new UnsupportedOperationException("This postings format may not be used for writing, use the current postings format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        Lucene90BlockTreeTermsReader lucene90BlockTreeTermsReader;
        block3: {
            Lucene912PostingsReader postingsReader = new Lucene912PostingsReader(state);
            boolean success = false;
            try {
                Lucene90BlockTreeTermsReader ret = new Lucene90BlockTreeTermsReader(postingsReader, state);
                success = true;
                lucene90BlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return lucene90BlockTreeTermsReader;
    }

    public static final class IntBlockTermState
    extends BlockTermState {
        public long docStartFP;
        public long posStartFP;
        public long payStartFP;
        public long lastPosBlockOffset = -1L;
        public int singletonDocID = -1;

        @Override
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(TermState _other) {
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

