/*
 * Decompiled with CFR 0.152.
 */
package shacl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdMain;
import org.apache.jena.graph.Graph;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIs;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.Shapes;
import org.apache.jena.shacl.compact.ShaclcWriter;
import org.apache.jena.shacl.compact.reader.ShaclcParseException;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ShaclParseException;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sys.JenaSystem;

public class shacl_parse
extends CmdMain {
    private static ArgDecl argOutput;
    private static ArgDecl argBase;
    private static ArgDecl argSyntax;
    private String baseIRI = null;
    private Lang lang = null;
    private boolean printCompact = false;
    private boolean printRDF = false;
    private boolean printText = false;
    private String shapesfile = null;

    public static void main(String ... argv) {
        new shacl_parse(argv).mainRun();
    }

    public shacl_parse(String[] argv) {
        super(argv);
        super.add(argOutput, "--output=", "Output formats: RDF, compact, text (default, text)");
        super.add(argSyntax, "--syntax=NAME", "Set syntax (otherwise syntax guessed from file extension)");
        super.add(argBase, "--base=URI", "Set the base URI (does not apply to N-triples and N-Quads)");
    }

    @Override
    protected String getSummary() {
        return "Usage: " + this.getCommandName() + " --out=FMT[,FMT] FILE";
    }

    @Override
    protected void processModulesAndArgs() {
        Object syntax;
        super.processModulesAndArgs();
        if (super.hasArg(argOutput)) {
            this.printCompact = false;
            this.printRDF = false;
            this.printText = false;
            Function<String, Stream> f = x -> {
                String[] a = x.split(",");
                return Arrays.stream(a);
            };
            List<String> outputValues = this.getValues(argOutput).stream().flatMap(f).map(s -> s.toLowerCase()).toList();
            ArrayList<String> values = new ArrayList<String>(outputValues);
            this.printText = values.remove("text") || values.remove("t");
            this.printCompact = values.remove("compact") || values.remove("c");
            boolean bl = this.printRDF = values.remove("rdf") || values.remove("r") || values.remove("ttl");
            if (values.remove("all") || values.remove("a")) {
                this.printCompact = true;
                this.printRDF = true;
                this.printText = true;
            }
            if (!values.isEmpty()) {
                throw new CmdException("Formats not recognized: " + String.valueOf(values) + " : Formats are 'text', 'compact', 'rdf','ttl' and 'all'");
            }
        } else {
            this.printCompact = false;
            this.printRDF = false;
            this.printText = true;
        }
        if (super.contains(argSyntax)) {
            syntax = super.getValue(argSyntax);
            Lang lang$ = RDFLanguages.nameToLang((String)syntax);
            if (lang$ == null) {
                throw new CmdException("Can not detemine the syntax from '" + (String)syntax + "'");
            }
            this.lang = lang$;
        }
        if (super.contains(argBase)) {
            this.baseIRI = super.getValue(argBase);
            try {
                syntax = IRIs.reference(this.baseIRI);
            }
            catch (IRIException ex) {
                throw new CmdException("Bad base IRI: " + this.baseIRI);
            }
        }
        if (this.positionals.isEmpty()) {
            this.positionals.add("-");
        }
    }

    @Override
    protected String getCommandName() {
        return "shacl_parse";
    }

    @Override
    protected void exec() {
        boolean filesOK = true;
        for (String fn2 : this.positionals) {
            if ("-".equals(fn2) || IO.exists(fn2)) continue;
            System.err.println("File not found: " + fn2);
            filesOK = false;
        }
        if (!filesOK) {
            throw new CmdException("File(s) not found");
        }
        boolean multipleFiles = this.positionals.size() > 1;
        this.positionals.forEach(fn -> this.exec((String)fn, multipleFiles));
    }

    private void exec(String fn, boolean multipleFiles) {
        Shapes shapes;
        PrintStream out = System.out;
        PrintStream err = System.err;
        try {
            Graph g = this.parseFile(fn);
            shapes = Shapes.parse(g);
        }
        catch (RiotNotFoundException | ShaclcParseException | ShaclParseException ex) {
            if (multipleFiles) {
                err.println(fn + " : ");
            }
            err.println(ex.getMessage());
            return;
        }
        catch (RiotException ex) {
            return;
        }
        boolean outputByPrev = false;
        if (this.printText) {
            outputByPrev = this.printText(out, err, shapes);
        }
        if (this.printCompact) {
            if (outputByPrev) {
                out.println("- - - - - - - -");
                outputByPrev = false;
            }
            outputByPrev = this.printCompact(out, err, shapes);
        }
        if (this.printRDF) {
            if (outputByPrev) {
                out.println("- - - - - - - -");
                outputByPrev = false;
            }
            outputByPrev = this.printRDF(out, err, shapes);
        }
    }

    public Graph parseFile(String filename) {
        String baseParserIRI = this.baseIRI;
        RDFParserBuilder builder = RDFParser.create();
        if (baseParserIRI != null) {
            builder.base(baseParserIRI);
        }
        if (this.lang != null) {
            builder.forceLang(this.lang);
        } else {
            Lang lang = Lang.SHACLC;
            builder.lang(lang);
        }
        if (filename.equals("-")) {
            if (baseParserIRI == null) {
                baseParserIRI = "http://base/";
                builder.base(baseParserIRI);
            }
            filename = "stdin";
            builder.source(System.in);
        } else {
            builder.source(filename);
        }
        Graph graph = GraphFactory.createDefaultGraph();
        builder.parse(graph);
        return graph;
    }

    private boolean printText(PrintStream out, PrintStream err, Shapes shapes) {
        IndentedWriter iOut = new IndentedWriter(out);
        ShLib.printShapes(iOut, shapes);
        iOut.ensureStartOfLine();
        iOut.flush();
        int numShapes = shapes.numShapes();
        int numRootShapes = shapes.numRootShapes();
        if (this.isVerbose()) {
            System.out.println();
            System.out.println("Target shapes: ");
            shapes.getShapeMap().forEach((n, shape) -> {
                if (shape.hasTarget()) {
                    System.out.println("  " + ShLib.displayStr(shape.getShapeNode()));
                }
            });
            System.out.println("Other Shapes: ");
            shapes.getShapeMap().forEach((n, shape) -> {
                if (!shape.hasTarget()) {
                    System.out.println("  " + ShLib.displayStr(shape.getShapeNode()));
                }
            });
        }
        return true;
    }

    private boolean printRDF(PrintStream out, PrintStream err, Shapes shapes) {
        RDFDataMgr.write((OutputStream)out, shapes.getGraph(), Lang.TTL);
        return shacl_parse.somethingWritten(shapes.getGraph());
    }

    private boolean printCompact(PrintStream out, PrintStream err, Shapes shapes) {
        try {
            ShaclcWriter.print(out, shapes);
        }
        catch (ShaclException ex) {
            err.println(ex.getMessage());
        }
        return shacl_parse.somethingWritten(shapes.getGraph());
    }

    private static boolean somethingWritten(Graph graph) {
        return !graph.isEmpty() || !graph.getPrefixMapping().hasNoMappings();
    }

    static {
        LogCtl.setLogging();
        JenaSystem.init();
        argOutput = new ArgDecl(true, "output", "out");
        argBase = new ArgDecl(true, "base");
        argSyntax = new ArgDecl(true, "syntax");
    }
}

