/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.atom;

import java.util.Calendar;
import org.apache.juneau.dto.atom.Category;
import org.apache.juneau.dto.atom.Common;
import org.apache.juneau.dto.atom.Id;
import org.apache.juneau.dto.atom.Link;
import org.apache.juneau.dto.atom.Person;
import org.apache.juneau.dto.atom.Text;
import org.apache.juneau.dto.atom.Utils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

@FluentSetters
public class CommonEntry
extends Common {
    private Person[] authors;
    private Category[] categories;
    private Person[] contributors;
    private Id id;
    private Link[] links;
    private Text rights;
    private Text title;
    private Calendar updated;

    public CommonEntry(Id id, Text title, Calendar updated) {
        this.setId(id).setTitle(title).setUpdated(updated);
    }

    public CommonEntry(String id, String title, String updated) {
        this.setId(id).setTitle(title).setUpdated(updated);
    }

    public CommonEntry() {
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="author")
    public Person[] getAuthors() {
        return this.authors;
    }

    @FluentSetter
    public CommonEntry setAuthors(Person ... value) {
        this.authors = value;
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="category")
    public Category[] getCategories() {
        return this.categories;
    }

    @FluentSetter
    public CommonEntry setCategories(Category ... value) {
        this.categories = value;
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="contributor")
    public Person[] getContributors() {
        return this.contributors;
    }

    @FluentSetter
    public CommonEntry setContributors(Person ... value) {
        this.contributors = value;
        return this;
    }

    public Id getId() {
        return this.id;
    }

    @FluentSetter
    public CommonEntry setId(Id value) {
        this.id = value;
        return this;
    }

    @FluentSetter
    public CommonEntry setId(String value) {
        this.setId(new Id(value));
        return this;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public Link[] getLinks() {
        return this.links;
    }

    @FluentSetter
    public CommonEntry setLinks(Link ... value) {
        this.links = value;
        return this;
    }

    public Text getRights() {
        return this.rights;
    }

    @FluentSetter
    public CommonEntry setRights(Text value) {
        this.rights = value;
        return this;
    }

    @FluentSetter
    public CommonEntry setRights(String value) {
        this.setRights(new Text().setText(value));
        return this;
    }

    public Text getTitle() {
        return this.title;
    }

    @FluentSetter
    public CommonEntry setTitle(Text value) {
        this.title = value;
        return this;
    }

    @FluentSetter
    public CommonEntry setTitle(String value) {
        this.setTitle(new Text().setText(value));
        return this;
    }

    public Calendar getUpdated() {
        return this.updated;
    }

    @FluentSetter
    public CommonEntry setUpdated(Calendar value) {
        this.updated = value;
        return this;
    }

    @FluentSetter
    public CommonEntry setUpdated(String value) {
        this.setUpdated(Utils.parseDateTime(value));
        return this;
    }

    @Override
    public CommonEntry setBase(Object value) {
        super.setBase(value);
        return this;
    }

    @Override
    public CommonEntry setLang(String value) {
        super.setLang(value);
        return this;
    }
}

