/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html;

import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ExtendedBeanPropertyMeta;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.html.HtmlMetaProvider;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;

public final class HtmlBeanPropertyMeta
extends ExtendedBeanPropertyMeta {
    public static final HtmlBeanPropertyMeta DEFAULT = new HtmlBeanPropertyMeta();
    private final boolean noTables;
    private final boolean noTableHeaders;
    private final HtmlFormat format;
    private final HtmlRender render;
    private final String link;
    private final String anchorText;

    public HtmlBeanPropertyMeta(BeanPropertyMeta bpm, HtmlMetaProvider mp) {
        super(bpm);
        Builder b = new Builder();
        if (bpm.getInnerField() != null) {
            mp.forEachAnnotation(Html.class, bpm.getInnerField(), x -> true, x -> b.findHtmlInfo((Html)x));
        }
        if (bpm.getGetter() != null) {
            mp.forEachAnnotation(Html.class, bpm.getGetter(), x -> true, x -> b.findHtmlInfo((Html)x));
        }
        if (bpm.getSetter() != null) {
            mp.forEachAnnotation(Html.class, bpm.getSetter(), x -> true, x -> b.findHtmlInfo((Html)x));
        }
        this.format = b.format;
        this.noTables = b.noTables;
        this.noTableHeaders = b.noTableHeaders;
        this.render = b.render.orElse(null);
        this.link = b.link;
        this.anchorText = b.anchorText;
    }

    private HtmlBeanPropertyMeta() {
        super(null);
        this.format = HtmlFormat.HTML;
        this.noTables = false;
        this.noTableHeaders = false;
        this.render = null;
        this.link = null;
        this.anchorText = null;
    }

    protected HtmlFormat getFormat() {
        return this.format;
    }

    protected boolean isXml() {
        return this.format == HtmlFormat.XML;
    }

    protected boolean isPlainText() {
        return this.format == HtmlFormat.PLAIN_TEXT;
    }

    protected boolean isHtml() {
        return this.format == HtmlFormat.HTML;
    }

    protected boolean isHtmlCdc() {
        return this.format == HtmlFormat.HTML_CDC;
    }

    protected boolean isHtmlSdc() {
        return this.format == HtmlFormat.HTML_SDC;
    }

    protected boolean isNoTables() {
        return this.noTables;
    }

    public boolean isNoTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlRender getRender() {
        return this.render;
    }

    public String getLink() {
        return this.link;
    }

    public String getAnchorText() {
        return this.anchorText;
    }

    static final class Builder {
        boolean noTables;
        boolean noTableHeaders;
        HtmlFormat format = HtmlFormat.HTML;
        BeanCreator<HtmlRender> render = BeanCreator.of(HtmlRender.class);
        String link;
        String anchorText;

        Builder() {
        }

        void findHtmlInfo(Html html) {
            if (html == null) {
                return;
            }
            this.format = html.format();
            if (html.noTables()) {
                this.noTables = html.noTables();
            }
            if (html.noTableHeaders()) {
                this.noTableHeaders = html.noTableHeaders();
            }
            if (html.render() != HtmlRender.class) {
                this.render.type(html.render());
            }
            if (!html.link().isEmpty()) {
                this.link = html.link();
            }
            if (!html.anchorText().isEmpty()) {
                this.anchorText = html.anchorText();
            }
        }
    }
}

