/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.openapi3;

import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.openapi3.OpenApiElement;
import org.apache.juneau.dto.openapi3.Server;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.ConverterUtils;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.MultiSet;

@Bean(properties="operationRef,operationId,description,requestBody,server,parameters,*")
@FluentSetters
public class Link
extends OpenApiElement {
    private String operationRef;
    private String operationId;
    private String description;
    private Object requestBody;
    private Server server;
    private Map<String, Object> parameters;

    public Link() {
    }

    public Link(Link copyFrom) {
        super(copyFrom);
        this.operationRef = copyFrom.operationRef;
        this.description = copyFrom.description;
        this.operationId = copyFrom.operationId;
        this.requestBody = copyFrom.requestBody;
        this.server = copyFrom.server == null ? null : copyFrom.server.copy();
        this.parameters = copyFrom.parameters == null ? null : new LinkedHashMap<String, Object>(copyFrom.parameters);
    }

    public Link copy() {
        return new Link(this);
    }

    public String getOperationRef() {
        return this.operationRef;
    }

    public Link setOperationRef(String value) {
        this.operationRef = value;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Link setDescription(String value) {
        this.description = value;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Link setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Link setRequestBody(Object val) {
        this.requestBody = val;
        return this;
    }

    public Server getServer() {
        return this.server;
    }

    public Link setServer(Server value) {
        this.server = value;
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Link setParameters(Map<String, Object> value) {
        this.parameters = CollectionUtils.copyOf(value);
        return this;
    }

    public Link addParameter(String mimeType, Object parameter) {
        this.parameters = CollectionUtils.mapBuilder(this.parameters).sparse().add(mimeType, this.parameters).build();
        return this;
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "description": {
                return ConverterUtils.toType(this.getDescription(), type);
            }
            case "operationRef": {
                return ConverterUtils.toType(this.getOperationRef(), type);
            }
            case "operationId": {
                return ConverterUtils.toType(this.getOperationId(), type);
            }
            case "requestBody": {
                return ConverterUtils.toType(this.getRequestBody(), type);
            }
            case "parameters": {
                return ConverterUtils.toType(this.getParameters(), type);
            }
            case "server": {
                return ConverterUtils.toType(this.getServer(), type);
            }
        }
        return super.get(property, type);
    }

    @Override
    public Link set(String property, Object value) {
        if (property == null) {
            return this;
        }
        switch (property) {
            case "description": {
                return this.setDescription(StringUtils.stringify(value));
            }
            case "operationId": {
                return this.setOperationId(StringUtils.stringify(value));
            }
            case "operationRef": {
                return this.setOperationRef(StringUtils.stringify(value));
            }
            case "requestBody": {
                return this.setRequestBody(value);
            }
            case "server": {
                return this.setServer(ConverterUtils.toType(value, Server.class));
            }
            case "parameters": {
                return this.setParameters(CollectionUtils.mapBuilder(String.class, Object.class, new Type[0]).sparse().addAny(value).build());
            }
        }
        super.set(property, value);
        return this;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setBuilder(String.class, new Type[0]).addIf(this.description != null, "description").addIf(this.operationId != null, "operationId").addIf(this.operationRef != null, "operationRef").addIf(this.requestBody != null, "requestBody").addIf(this.parameters != null, "parameters").addIf(this.server != null, "server").build();
        return new MultiSet<String>(s, super.keySet());
    }
}

