/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.swagger;

import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.dto.swagger.Operation;
import org.apache.juneau.internal.CollectionUtils;

public class OperationMap
extends TreeMap<String, Operation> {
    private static final long serialVersionUID = 1L;
    private static final Comparator<String> OP_SORTER = new Comparator<String>(){
        private final Map<String, String> methods = CollectionUtils.mapBuilder(String.class, String.class, new Type[0]).add("get", "0").add("put", "1").add("post", "2").add("delete", "3").add("options", "4").add("head", "5").add("patch", "6").build();

        @Override
        public int compare(String o1, String o2) {
            String s1 = this.methods.get(o1);
            String s2 = this.methods.get(o2);
            if (s1 == null) {
                s1 = o1;
            }
            if (s2 == null) {
                s2 = o2;
            }
            return StringUtils.compare(s1, s2);
        }
    };

    public OperationMap() {
        super(OP_SORTER);
    }

    public OperationMap append(String httpMethodName, Operation operation) {
        this.put(StringUtils.emptyIfNull(httpMethodName).toLowerCase(), operation);
        return this;
    }
}

