/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.apache.juneau.Enablement;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.http.response.InternalServerError;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestOpContext;
import org.apache.juneau.rest.debug.BasicDebugEnablement;
import org.apache.juneau.utils.ReflectionMap;

public abstract class DebugEnablement {
    private final Enablement defaultEnablement;
    private final ReflectionMap<Enablement> enablementMap;
    private final Predicate<HttpServletRequest> conditionalPredicate;

    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public DebugEnablement(BeanStore beanStore) {
        Builder builder = this.init(beanStore);
        this.defaultEnablement = ObjectUtils.firstNonNull(builder.defaultEnablement, Enablement.NEVER);
        this.enablementMap = builder.mapBuilder.build();
        this.conditionalPredicate = ObjectUtils.firstNonNull(builder.conditional, x -> "true".equalsIgnoreCase(x.getHeader("Debug")));
    }

    public DebugEnablement(Builder builder) {
        this.defaultEnablement = ObjectUtils.firstNonNull(builder.defaultEnablement, Enablement.NEVER);
        this.enablementMap = builder.mapBuilder.build();
        this.conditionalPredicate = ObjectUtils.firstNonNull(builder.conditional, x -> "true".equalsIgnoreCase(x.getHeader("Debug")));
    }

    protected Builder init(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public boolean isDebug(RestContext context, HttpServletRequest req) {
        Class<?> c = context.getResourceClass();
        Enablement e = this.enablementMap.find(c).orElse(this.defaultEnablement);
        return e == Enablement.ALWAYS || e == Enablement.CONDITIONAL && this.isConditionallyEnabled(req);
    }

    public boolean isDebug(RestOpContext context, HttpServletRequest req) {
        Method m = context.getJavaMethod();
        Enablement e = this.enablementMap.find(m).orElse(this.enablementMap.find(m.getDeclaringClass()).orElse(this.defaultEnablement));
        return e == Enablement.ALWAYS || e == Enablement.CONDITIONAL && this.isConditionallyEnabled(req);
    }

    protected boolean isConditionallyEnabled(HttpServletRequest req) {
        return this.conditionalPredicate.test(req);
    }

    public String toString() {
        return JsonMap.filteredMap().append("defaultEnablement", (Object)this.defaultEnablement).append("enablementMap", this.enablementMap).append("conditionalPredicate", this.conditionalPredicate).asString();
    }

    public static class Builder {
        ReflectionMap.Builder<Enablement> mapBuilder;
        Enablement defaultEnablement = Enablement.NEVER;
        Predicate<HttpServletRequest> conditional;
        BeanCreator<DebugEnablement> creator;

        protected Builder(BeanStore beanStore) {
            this.mapBuilder = ReflectionMap.create(Enablement.class);
            this.defaultEnablement = Enablement.NEVER;
            this.conditional = x -> "true".equalsIgnoreCase(x.getHeader("Debug"));
            this.creator = beanStore.createBean(DebugEnablement.class).type(BasicDebugEnablement.class).builder(Builder.class, this);
        }

        public DebugEnablement build() {
            try {
                return this.creator.run();
            }
            catch (Exception e) {
                throw new InternalServerError((Throwable)e);
            }
        }

        public Builder type(Class<? extends DebugEnablement> value) {
            this.creator.type(value == null ? BasicDebugEnablement.class : value);
            return this;
        }

        public Builder impl(DebugEnablement value) {
            this.creator.impl(value);
            return this;
        }

        public Builder enable(Enablement enablement, String ... keys) {
            for (String k : keys) {
                this.mapBuilder.append(k, enablement);
            }
            return this;
        }

        public Builder enable(Enablement enablement, Class<?> ... classes) {
            for (Class<?> c : classes) {
                this.mapBuilder.append(c.getName(), enablement);
            }
            return this;
        }

        public Builder defaultEnable(Enablement value) {
            this.defaultEnablement = value;
            return this;
        }

        public Builder conditional(Predicate<HttpServletRequest> value) {
            this.conditional = value;
            return this;
        }
    }

    public abstract class Void
    extends DebugEnablement {
        Void(BeanStore beanStore) {
            super(beanStore);
        }
    }
}

