/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.http.annotation.Request;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.svl.VarResolverSession;

public class RequestAnnotation {
    public static final Request DEFAULT = RequestAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return RequestAnnotation.create().on((Class[])on);
    }

    public static Builder create(String ... on) {
        return RequestAnnotation.create().on(on);
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderT {
        private String[] description = new String[0];
        private Class<? extends HttpPartParser> parser = HttpPartParser.Void.class;
        private Class<? extends HttpPartSerializer> serializer = HttpPartSerializer.Void.class;

        protected Builder() {
            super(Request.class);
        }

        public Request build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            this.parser = value;
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            this.serializer = value;
            return this;
        }

        @Override
        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder on(Class<?> ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(Class<?> ... value) {
            super.onClass(value);
            return this;
        }

        @Override
        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        @Override
        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Request {
        private final String[] description;
        private final Class<? extends HttpPartParser> parser;
        private final Class<? extends HttpPartSerializer> serializer;

        Object(Builder b) {
            super(b);
            this.description = CollectionUtils.copyOf(b.description);
            this.parser = b.parser;
            this.serializer = b.serializer;
        }

        @Override
        public Class<? extends HttpPartParser> parser() {
            return this.parser;
        }

        @Override
        public Class<? extends HttpPartSerializer> serializer() {
            return this.serializer;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Request[] value();
    }

    public static class Applier
    extends AnnotationApplier<Request, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Request.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Request> ai, BeanContext.Builder b) {
            Request a = ai.inner();
            if (CollectionUtils.isEmptyArray(a.on()) && CollectionUtils.isEmptyArray(a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }
}

