/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanContext;
import org.apache.juneau.Context;
import org.apache.juneau.MediaType;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.commons.collections.FluentMap;
import org.apache.juneau.commons.collections.HashKey;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.Visibility;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.swap.BeanInterceptor;

public abstract class BeanContextable
extends Context {
    protected final BeanContext beanContext;

    protected BeanContextable(Builder b) {
        super(b);
        this.beanContext = Utils.nn((Object)b.bc) ? b.bc : b.bcBuilder.build();
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    @Override
    protected FluentMap<String, Object> properties() {
        return super.properties().a((Object)"beanContext", this.beanContext.properties());
    }

    public static abstract class Builder
    extends Context.Builder {
        private BeanContext.Builder bcBuilder;
        private BeanContext bc;

        protected Builder() {
            this.bcBuilder = BeanContext.create();
            this.registerBuilders(this.bcBuilder);
        }

        protected Builder(BeanContextable copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.getBeanContext().copy();
            this.registerBuilders(this.bcBuilder);
        }

        protected Builder(Builder copyFrom) {
            super(copyFrom);
            this.bcBuilder = copyFrom.bcBuilder.copy();
            this.bc = copyFrom.bc;
            this.registerBuilders(this.bcBuilder);
        }

        @Override
        public Builder annotations(Annotation ... value) {
            this.bcBuilder.annotations(value);
            super.annotations(value);
            return this;
        }

        @Override
        public Builder apply(AnnotationWorkList work) {
            super.apply(work);
            return this;
        }

        @Override
        public Builder applyAnnotations(Class<?> ... from) {
            super.applyAnnotations(from);
            return this;
        }

        @Override
        public Builder applyAnnotations(Object ... from) {
            super.applyAnnotations(from);
            return this;
        }

        public Builder beanClassVisibility(Visibility value) {
            this.bcBuilder.beanClassVisibility((Visibility)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder beanConstructorVisibility(Visibility value) {
            this.bcBuilder.beanConstructorVisibility((Visibility)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public BeanContext.Builder beanContext() {
            return this.bcBuilder;
        }

        public Builder beanContext(BeanContext value) {
            this.bc = (BeanContext)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public Builder beanContext(BeanContext.Builder value) {
            this.bcBuilder = (BeanContext.Builder)AssertionUtils.assertArgNotNull((String)"value", (Object)value);
            return this;
        }

        public final Builder beanContext(Consumer<BeanContext.Builder> operation) {
            AssertionUtils.assertArgNotNull((String)"operation", operation);
            operation.accept(this.beanContext());
            return this;
        }

        public Builder beanDictionary(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.bcBuilder.beanDictionary(values);
            return this;
        }

        public Builder beanFieldVisibility(Visibility value) {
            this.bcBuilder.beanFieldVisibility((Visibility)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder beanInterceptor(Class<?> on, Class<? extends BeanInterceptor<?>> value) {
            this.bcBuilder.beanInterceptor((Class)AssertionUtils.assertArgNotNull((String)"on", on), (Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder beanMapPutReturnsOldValue() {
            this.bcBuilder.beanMapPutReturnsOldValue();
            return this;
        }

        public Builder beanMethodVisibility(Visibility value) {
            this.bcBuilder.beanMethodVisibility((Visibility)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder beanProperties(Class<?> beanClass, String properties) {
            this.bcBuilder.beanProperties(beanClass, (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanProperties(Map<String, Object> values) {
            this.bcBuilder.beanProperties((Map)AssertionUtils.assertArgNotNull((String)"values", values));
            return this;
        }

        public Builder beanProperties(String beanClassName, String properties) {
            this.bcBuilder.beanProperties((String)AssertionUtils.assertArgNotNull((String)"beanClassName", (Object)beanClassName), (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanPropertiesExcludes(Class<?> beanClass, String properties) {
            this.bcBuilder.beanPropertiesExcludes(beanClass, (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanPropertiesExcludes(Map<String, Object> values) {
            this.bcBuilder.beanPropertiesExcludes((Map)AssertionUtils.assertArgNotNull((String)"values", values));
            return this;
        }

        public Builder beanPropertiesExcludes(String beanClassName, String properties) {
            this.bcBuilder.beanPropertiesExcludes((String)AssertionUtils.assertArgNotNull((String)"beanClassName", (Object)beanClassName), (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanPropertiesReadOnly(Class<?> beanClass, String properties) {
            this.bcBuilder.beanPropertiesReadOnly(beanClass, (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanPropertiesReadOnly(Map<String, Object> values) {
            this.bcBuilder.beanPropertiesReadOnly((Map)AssertionUtils.assertArgNotNull((String)"values", values));
            return this;
        }

        public Builder beanPropertiesReadOnly(String beanClassName, String properties) {
            this.bcBuilder.beanPropertiesReadOnly((String)AssertionUtils.assertArgNotNull((String)"beanClassName", (Object)beanClassName), (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanPropertiesWriteOnly(Class<?> beanClass, String properties) {
            this.bcBuilder.beanPropertiesWriteOnly(beanClass, (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beanPropertiesWriteOnly(Map<String, Object> values) {
            this.bcBuilder.beanPropertiesWriteOnly((Map)AssertionUtils.assertArgNotNull((String)"values", values));
            return this;
        }

        public Builder beanPropertiesWriteOnly(String beanClassName, String properties) {
            this.bcBuilder.beanPropertiesWriteOnly((String)AssertionUtils.assertArgNotNull((String)"beanClassName", (Object)beanClassName), (String)AssertionUtils.assertArgNotNull((String)"properties", (Object)properties));
            return this;
        }

        public Builder beansRequireDefaultConstructor() {
            this.bcBuilder.beansRequireDefaultConstructor();
            return this;
        }

        public Builder beansRequireSerializable() {
            this.bcBuilder.beansRequireSerializable();
            return this;
        }

        public Builder beansRequireSettersForGetters() {
            this.bcBuilder.beansRequireSettersForGetters();
            return this;
        }

        @Override
        public Builder cache(Cache<HashKey, ? extends Context> value) {
            super.cache(value);
            return this;
        }

        @Override
        public abstract Builder copy();

        @Override
        public Builder debug() {
            this.bcBuilder.debug();
            super.debug();
            return this;
        }

        public Builder dictionaryOn(Class<?> on, Class<?> ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.bcBuilder.dictionaryOn((Class)AssertionUtils.assertArgNotNull((String)"on", on), values);
            return this;
        }

        public Builder disableBeansRequireSomeProperties() {
            this.bcBuilder.disableBeansRequireSomeProperties();
            return this;
        }

        public Builder disableIgnoreMissingSetters() {
            this.bcBuilder.disableIgnoreMissingSetters();
            return this;
        }

        public Builder disableIgnoreTransientFields() {
            this.bcBuilder.disableIgnoreTransientFields();
            return this;
        }

        public Builder disableIgnoreUnknownNullBeanProperties() {
            this.bcBuilder.disableIgnoreUnknownNullBeanProperties();
            return this;
        }

        public Builder disableInterfaceProxies() {
            this.bcBuilder.disableInterfaceProxies();
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, String json) {
            this.bcBuilder.example((Class)AssertionUtils.assertArgNotNull((String)"pojoClass", pojoClass), json);
            return this;
        }

        public <T> Builder example(Class<T> pojoClass, T o) {
            this.bcBuilder.example((Class)AssertionUtils.assertArgNotNull((String)"pojoClass", pojoClass), o);
            return this;
        }

        public Builder findFluentSetters() {
            this.bcBuilder.findFluentSetters();
            return this;
        }

        public Builder findFluentSetters(Class<?> on) {
            this.bcBuilder.findFluentSetters((Class)AssertionUtils.assertArgNotNull((String)"on", on));
            return this;
        }

        @Override
        public HashKey hashKey() {
            return HashKey.of((Object[])new Object[]{super.hashKey(), this.bcBuilder.hashKey(), this.bc == null ? Integer.valueOf(0) : this.bc.getHashKey()});
        }

        public Builder ignoreInvocationExceptionsOnGetters() {
            this.bcBuilder.ignoreInvocationExceptionsOnGetters();
            return this;
        }

        public Builder ignoreInvocationExceptionsOnSetters() {
            this.bcBuilder.ignoreInvocationExceptionsOnSetters();
            return this;
        }

        public Builder ignoreUnknownBeanProperties() {
            this.bcBuilder.ignoreUnknownBeanProperties();
            return this;
        }

        public Builder ignoreUnknownEnumValues() {
            this.bcBuilder.ignoreUnknownEnumValues();
            return this;
        }

        @Override
        public Builder impl(Context value) {
            super.impl(value);
            return this;
        }

        public Builder implClass(Class<?> interfaceClass, Class<?> implClass) {
            this.bcBuilder.implClass((Class)AssertionUtils.assertArgNotNull((String)"interfaceClass", interfaceClass), (Class)AssertionUtils.assertArgNotNull((String)"implClass", implClass));
            return this;
        }

        public Builder implClasses(Map<Class<?>, Class<?>> values) {
            this.bcBuilder.implClasses((Map)AssertionUtils.assertArgNotNull((String)"values", values));
            return this;
        }

        public Builder interfaceClass(Class<?> on, Class<?> value) {
            this.bcBuilder.interfaceClass((Class)AssertionUtils.assertArgNotNull((String)"on", on), (Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder interfaces(Class<?> ... value) {
            AssertionUtils.assertArgNoNulls((String)"value", (Object[])value);
            this.bcBuilder.interfaces(value);
            return this;
        }

        public Builder locale(Locale value) {
            this.bcBuilder.locale((Locale)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder mediaType(MediaType value) {
            this.bcBuilder.mediaType(value);
            return this;
        }

        public Builder notBeanClasses(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.bcBuilder.notBeanClasses(values);
            return this;
        }

        public Builder notBeanPackages(String ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.bcBuilder.notBeanPackages(values);
            return this;
        }

        public Builder propertyNamer(Class<?> on, Class<? extends PropertyNamer> value) {
            this.bcBuilder.propertyNamer((Class)AssertionUtils.assertArgNotNull((String)"on", on), (Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder propertyNamer(Class<? extends PropertyNamer> value) {
            this.bcBuilder.propertyNamer((Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public Builder sortProperties() {
            this.bcBuilder.sortProperties();
            return this;
        }

        public Builder sortProperties(Class<?> ... on) {
            AssertionUtils.assertArgNoNulls((String)"on", (Object[])on);
            this.bcBuilder.sortProperties(on);
            return this;
        }

        public Builder stopClass(Class<?> on, Class<?> value) {
            this.bcBuilder.stopClass((Class)AssertionUtils.assertArgNotNull((String)"on", on), (Class)AssertionUtils.assertArgNotNull((String)"value", value));
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
            this.bcBuilder.swap((Class)AssertionUtils.assertArgNotNull((String)"normalClass", normalClass), (Class)AssertionUtils.assertArgNotNull((String)"swappedClass", swappedClass), (ThrowingFunction)AssertionUtils.assertArgNotNull((String)"swapFunction", swapFunction));
            return this;
        }

        public <T, S> Builder swap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
            this.bcBuilder.swap((Class)AssertionUtils.assertArgNotNull((String)"normalClass", normalClass), (Class)AssertionUtils.assertArgNotNull((String)"swappedClass", swappedClass), (ThrowingFunction)AssertionUtils.assertArgNotNull((String)"swapFunction", swapFunction), (ThrowingFunction)AssertionUtils.assertArgNotNull((String)"unswapFunction", unswapFunction));
            return this;
        }

        public Builder swaps(Class<?> ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.bcBuilder.swaps(values);
            return this;
        }

        public Builder swaps(Object ... values) {
            AssertionUtils.assertArgNoNulls((String)"values", (Object[])values);
            this.bcBuilder.swaps(values);
            return this;
        }

        public Builder timeZone(TimeZone value) {
            this.bcBuilder.timeZone(value);
            return this;
        }

        @Override
        public Builder type(Class<? extends Context> value) {
            super.type(value);
            return this;
        }

        public Builder typeName(Class<?> on, String value) {
            this.bcBuilder.typeName(on, (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder typePropertyName(Class<?> on, String value) {
            this.bcBuilder.typePropertyName(on, (String)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder typePropertyName(String value) {
            this.bcBuilder.typePropertyName((String)AssertionUtils.assertArgNotNull((String)"value", (Object)value));
            return this;
        }

        public Builder useEnumNames() {
            this.bcBuilder.useEnumNames();
            return this;
        }

        public Builder useJavaBeanIntrospector() {
            this.bcBuilder.useJavaBeanIntrospector();
            return this;
        }
    }
}

