/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ref;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.builder.ExpressionBuilder;

@Language(value="ref")
public class RefLanguage
extends LanguageSupport {
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate((Expression)this.createExpression(expression));
    }

    public Expression createExpression(final String expression) {
        ExpressionAdapter answer = new ExpressionAdapter(){
            private Expression exp;

            public void init(CamelContext context) {
                this.exp = ExpressionBuilder.refExpression((String)expression);
                this.exp.init(context);
            }

            public Object evaluate(Exchange exchange) {
                Expression target = null;
                Object lookup = this.exp.evaluate(exchange, Object.class);
                if (lookup instanceof Expression) {
                    target = (Expression)lookup;
                } else if (lookup instanceof Predicate) {
                    target = PredicateToExpressionAdapter.toExpression((Predicate)((Predicate)lookup));
                }
                if (target != null) {
                    return target.evaluate(exchange, Object.class);
                }
                throw new IllegalArgumentException("Cannot find expression or predicate in registry with ref: " + expression);
            }

            public String toString() {
                return this.exp.toString();
            }
        };
        answer.init(this.getCamelContext());
        return answer;
    }
}

