/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.libg.glob.PathSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileTree {
    private final List<File> files = new ArrayList<File>();
    private final PathSet paths = new PathSet();

    public void addFile(File file) {
        if (file == null) {
            return;
        }
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public void addIncludes(List<String> includes) {
        this.paths.includes(includes);
    }

    public void addIncludes(String ... includes) {
        this.paths.include(includes);
    }

    public void addExcludes(String ... excludes) {
        this.paths.exclude(excludes);
    }

    public void addExcludes(List<String> excludes) {
        this.paths.excludes(excludes);
    }

    public List<File> getFiles(File baseDir, String ... defaultIncludes) throws IOException {
        return this.getFiles(baseDir, this.files.isEmpty() ? this.paths.matches(defaultIncludes) : this.paths.matches());
    }

    public List<File> getFiles(File baseDir, List<String> defaultIncludes) throws IOException {
        return this.getFiles(baseDir, this.files.isEmpty() ? this.paths.matches(defaultIncludes) : this.paths.matches());
    }

    private List<File> getFiles(File baseDir, Predicate<String> matches) throws IOException {
        Path basePath = baseDir.toPath();
        try (Stream<Path> walker = Files.walk(basePath, new FileVisitOption[0]).skip(1L);){
            List<File> result;
            List<File> list = result = Stream.concat(this.files.stream(), walker.filter(p -> matches.test(basePath.relativize((Path)p).toString())).sorted().map(Path::toFile)).distinct().collect(Collectors.toList());
            return list;
        }
    }

    public String toString() {
        return String.format("[files: %s, paths: %s]", this.files, this.paths);
    }
}

