/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.chat.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.theokanning.openai.OpenAiApi;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import com.theokanning.openai.service.OpenAiService;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.chat.provider.ChatProvider;
import retrofit2.Retrofit;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\b\u0011\u0001uA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0011\u0019\u0001\u0005\u0001)A\u0005k!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB(\u0001A\u0003%1\tC\u0004Q\u0001\u0001\u0007I\u0011B)\t\u000fU\u0003\u0001\u0019!C\u0005-\"1A\f\u0001Q!\nICq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004y\u0001\u0001\u0006Ia\u0018\u0005\u0006s\u0002!\tE\u001f\u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\ty1\t[1u\u000fB#\u0006K]8wS\u0012,'O\u0003\u0002\u0012%\u0005A\u0001O]8wS\u0012,'O\u0003\u0002\u0014)\u0005!1\r[1u\u0015\t)b#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003/a\taa[=vk\nL'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001=\u0011\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005\u0001\u0012BA\u0014\u0011\u00051\u0019\u0005.\u0019;Qe>4\u0018\u000eZ3s\u0003\u0011\u0019wN\u001c4\u0011\u0005)jS\"A\u0016\u000b\u000512\u0012AB2p]\u001aLw-\u0003\u0002/W\tQ1*_;vE&\u001cuN\u001c4\u0002\rqJg.\u001b;?)\t\t$\u0007\u0005\u0002&\u0001!)\u0001F\u0001a\u0001S\u0005Iq\r\u001d;Ba&\\U-_\u000b\u0002kA\u0011a'\u0010\b\u0003om\u0002\"\u0001\u000f\u0011\u000e\u0003eR!A\u000f\u000f\u0002\rq\u0012xn\u001c;?\u0013\ta\u0004%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f!\u0003)9\u0007\u000f^!qS.+\u0017\u0010I\u0001\u000e_B,g.Q5TKJ4\u0018nY3\u0016\u0003\r\u0003\"\u0001R'\u000e\u0003\u0015S!AR$\u0002\u000fM,'O^5dK*\u0011\u0001*S\u0001\u0007_B,g.Y5\u000b\u0005)[\u0015a\u0003;iK>\\\u0017M\u001c8j]\u001eT\u0011\u0001T\u0001\u0004G>l\u0017B\u0001(F\u00055y\u0005/\u001a8BSN+'O^5dK\u0006qq\u000e]3o\u0003&\u001cVM\u001d<jG\u0016\u0004\u0013aC:fgNLwN\\+tKJ,\u0012A\u0015\t\u0004?M+\u0014B\u0001+!\u0005\u0019y\u0005\u000f^5p]\u0006y1/Z:tS>tWk]3s?\u0012*\u0017\u000f\u0006\u0002X5B\u0011q\u0004W\u0005\u00033\u0002\u0012A!\u00168ji\"91\fCA\u0001\u0002\u0004\u0011\u0016a\u0001=%c\u0005a1/Z:tS>tWk]3sA\u0005Y1\r[1u\u0011&\u001cHo\u001c:z+\u0005y\u0006\u0003\u00021hk%l\u0011!\u0019\u0006\u0003E\u000e\fQaY1dQ\u0016T!\u0001Z3\u0002\r\r|W.\\8o\u0015\t17*\u0001\u0004h_><G.Z\u0005\u0003Q\u0006\u0014A\u0002T8bI&twmQ1dQ\u0016\u00042A[8r\u001b\u0005Y'B\u00017n\u0003\u0011)H/\u001b7\u000b\u00039\fAA[1wC&\u0011\u0001o\u001b\u0002\u000b\u0003J\u0014\u0018-\u001f#fcV,\u0007C\u0001:w\u001b\u0005\u0019(BA\nu\u0015\t)x)\u0001\u0006d_6\u0004H.\u001a;j_:L!a^:\u0003\u0017\rC\u0017\r^'fgN\fw-Z\u0001\rG\"\fG\u000fS5ti>\u0014\u0018\u0010I\u0001\u0005_B,g\u000eF\u0002XwvDQ\u0001 \u0007A\u0002U\n\u0011b]3tg&|g.\u00133\t\u000fyd\u0001\u0013!a\u0001%\u0006!Qo]3s\u0003\r\t7o\u001b\u000b\u0006k\u0005\r\u0011Q\u0001\u0005\u0006y6\u0001\r!\u000e\u0005\u0007\u0003\u000fi\u0001\u0019A\u001b\u0002\u0003E\fQa\u00197pg\u0016$2aVA\u0007\u0011\u0015ah\u00021\u00016\u0001")
public class ChatGPTProvider
implements ChatProvider {
    private final KyuubiConf conf;
    private final String gptApiKey;
    private final OpenAiService openAiService;
    private Option<String> sessionUser;
    private final LoadingCache<String, ArrayDeque<ChatMessage>> chatHistory;

    @Override
    public Option<String> open$default$2() {
        return ChatProvider.open$default$2$(this);
    }

    private String gptApiKey() {
        return this.gptApiKey;
    }

    private OpenAiService openAiService() {
        return this.openAiService;
    }

    private Option<String> sessionUser() {
        return this.sessionUser;
    }

    private void sessionUser_$eq(Option<String> x$1) {
        this.sessionUser = x$1;
    }

    private LoadingCache<String, ArrayDeque<ChatMessage>> chatHistory() {
        return this.chatHistory;
    }

    @Override
    public void open(String sessionId, Option<String> user) {
        this.sessionUser_$eq(user);
        this.chatHistory().getIfPresent((Object)sessionId);
    }

    @Override
    public String ask(String sessionId, String q) {
        String string;
        ArrayDeque messages = (ArrayDeque)this.chatHistory().get((Object)sessionId);
        try {
            String responseText;
            messages.addLast(new ChatMessage(ChatMessageRole.USER.value(), q));
            ChatCompletionRequest completionRequest = ChatCompletionRequest.builder().model((String)this.conf.get(KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_MODEL())).messages((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)messages).asScala()).toList()).asJava()).user((String)this.sessionUser().orNull(Predef$.MODULE$.$conforms())).n(Predef$.MODULE$.int2Integer(1)).build();
            string = responseText = ((ChatCompletionChoice)this.openAiService().createChatCompletion(completionRequest).getChoices().get(0)).getMessage().getContent();
        }
        catch (Throwable e) {
            messages.removeLast();
            string = new StringBuilder(20).append("Chat failed. Error: ").append(e.getMessage()).toString();
        }
        return string;
    }

    @Override
    public void close(String sessionId) {
        this.chatHistory().invalidate((Object)sessionId);
    }

    public ChatGPTProvider(KyuubiConf conf) {
        this.conf = conf;
        this.gptApiKey = (String)((Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_API_KEY())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(89).append("'").append(KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_API_KEY().key()).append("' must be configured, ").append("which could be got at https://platform.openai.com/account/api-keys").toString());
        });
        OkHttpClient.Builder builder = OpenAiService.defaultClient((String)this.gptApiKey(), (Duration)Duration.ofMillis(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_HTTP_SOCKET_TIMEOUT())))).newBuilder().connectTimeout(Duration.ofMillis(BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_HTTP_CONNECT_TIMEOUT()))));
        Option option = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.ENGINE_CHAT_GPT_HTTP_PROXY());
        if (option instanceof Some) {
            Some some = (Some)option;
            String httpProxyUrl = (String)some.value();
            URL url = new URL(httpProxyUrl);
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(url.getHost(), url.getPort()));
            builder.proxy(proxy);
        }
        Retrofit retrofit = OpenAiService.defaultRetrofit((OkHttpClient)builder.build(), (ObjectMapper)OpenAiService.defaultObjectMapper());
        OpenAiApi api = (OpenAiApi)retrofit.create(OpenAiApi.class);
        this.openAiService = new OpenAiService(api);
        this.sessionUser = None$.MODULE$;
        this.chatHistory = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ArrayDeque<ChatMessage>>(null){

            public ArrayDeque<ChatMessage> load(String sessionId) {
                return new ArrayDeque<ChatMessage>();
            }
        });
    }
}

