/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.netty;

import java.net.InetSocketAddress;
import org.apache.kyuubi.shade.io.grpc.Internal;
import org.apache.kyuubi.shade.io.grpc.ServerCredentials;
import org.apache.kyuubi.shade.io.grpc.ServerProvider;
import org.apache.kyuubi.shade.io.grpc.netty.NettyServerBuilder;
import org.apache.kyuubi.shade.io.grpc.netty.ProtocolNegotiators;

@Internal
public final class NettyServerProvider
extends ServerProvider {
    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 5;
    }

    protected NettyServerBuilder builderForPort(int port) {
        return NettyServerBuilder.forPort(port);
    }

    @Override
    protected ServerProvider.NewServerBuilderResult newServerBuilderForPort(int port, ServerCredentials creds) {
        ProtocolNegotiators.FromServerCredentialsResult result = ProtocolNegotiators.from(creds);
        if (result.error != null) {
            return ServerProvider.NewServerBuilderResult.error(result.error);
        }
        return ServerProvider.NewServerBuilderResult.serverBuilder(new NettyServerBuilder(new InetSocketAddress(port), result.negotiator));
    }
}

