/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.cli.server;

import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.sshd.cli.CliLogger;
import org.apache.sshd.cli.server.SshServerCliSupport;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.keyprovider.FileHostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.HostKeyCertificateProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.config.SshServerConfigFileReader;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.server.subsystem.SubsystemFactory;
import org.slf4j.Logger;

public class SshServerMain
extends SshServerCliSupport {
    public static void main(String[] args) throws Exception {
        SshServer sshd;
        int port = 8000;
        boolean error = false;
        String hostKeyType = "EC";
        int hostKeySize = 0;
        LinkedList<String> keyFiles = null;
        LinkedList<String> certFiles = null;
        TreeMap<String, String> options = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int numArgs = GenericUtils.length((Object[])args);
        for (int i = 0; i < numArgs; ++i) {
            String argName = args[i];
            if ("-p".equals(argName)) {
                if (++i >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                port = Integer.parseInt(args[i]);
                continue;
            }
            if ("-key-type".equals(argName)) {
                if (++i >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if (keyFiles != null) {
                    System.err.println("option conflicts with -key-file: " + argName);
                    error = true;
                    break;
                }
                hostKeyType = args[i].toUpperCase();
                continue;
            }
            if ("-key-size".equals(argName)) {
                if (++i >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                if (keyFiles != null) {
                    System.err.println("option conflicts with -key-file: " + argName);
                    error = true;
                    break;
                }
                hostKeySize = Integer.parseInt(args[i]);
                continue;
            }
            if ("-key-file".equals(argName)) {
                if (++i >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    error = true;
                    break;
                }
                String keyFilePath = args[i];
                if (keyFiles == null) {
                    keyFiles = new LinkedList<String>();
                }
                keyFiles.add(keyFilePath);
                continue;
            }
            if (!"-o".equals(argName)) continue;
            if (++i >= numArgs) {
                System.err.println("option requires and argument: " + argName);
                error = true;
                break;
            }
            String opt = args[i];
            int idx = opt.indexOf(61);
            if (idx <= 0) {
                System.err.println("bad syntax for option: " + opt);
                error = true;
                break;
            }
            String optName = opt.substring(0, idx);
            String optValue = opt.substring(idx + 1);
            if ("HostKey".equals(optName)) {
                if (keyFiles == null) {
                    keyFiles = new LinkedList();
                }
                keyFiles.add(optValue);
                continue;
            }
            if ("HostCertificate".equals(optName)) {
                if (certFiles == null) {
                    certFiles = new LinkedList<String>();
                }
                certFiles.add(optValue);
                continue;
            }
            if ("Port".equals(optName)) {
                port = Integer.parseInt(optValue);
                continue;
            }
            options.put(optName, optValue);
        }
        PropertyResolver resolver = PropertyResolverUtils.toPropertyResolver(options);
        Level level = CliLogger.resolveLoggingVerbosity(resolver, args);
        Logger logger = CliLogger.resolveSystemLogger(SshServerMain.class, level);
        SshServer sshServer = sshd = error ? null : SshServerMain.setupIoServiceFactory(SshServer.setUpDefaultServer(), resolver, level, System.out, System.err, args);
        if (sshd == null) {
            error = true;
        }
        if (error) {
            System.err.println("usage: sshd [-p port] [-io mina|nio2|netty] [-key-type RSA|DSA|EC] [-key-size NNNN] [-key-file <path>] [-o option=value]");
            System.exit(-1);
            return;
        }
        Map props = sshd.getProperties();
        props.putAll(options);
        SshServerConfigFileReader.configure((SshServer)sshd, (PropertyResolver)resolver, (boolean)true, (boolean)true);
        KeyPairProvider hostKeyProvider = SshServerMain.resolveServerKeys(System.err, hostKeyType, hostKeySize, keyFiles);
        sshd.setKeyPairProvider(hostKeyProvider);
        if (GenericUtils.isNotEmpty(certFiles)) {
            FileHostKeyCertificateProvider certProvider = new FileHostKeyCertificateProvider((Collection)certFiles.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList()));
            sshd.setHostKeyCertificateProvider((HostKeyCertificateProvider)certProvider);
        }
        SshServerMain.setupServerBanner((ServerFactoryManager)sshd, resolver);
        sshd.setPort(port);
        ShellFactory shellFactory = SshServerMain.resolveShellFactory(level, System.out, System.err, resolver);
        if (shellFactory != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Using shell={}", (Object)shellFactory.getClass().getName());
            }
            sshd.setShellFactory(shellFactory);
        }
        sshd.setPasswordAuthenticator((username, password, session) -> Objects.equals(username, password));
        sshd.setPublickeyAuthenticator((PublickeyAuthenticator)AcceptAllPublickeyAuthenticator.INSTANCE);
        SshServerMain.setupUserAuthFactories(sshd, resolver);
        SshServerMain.setupServerForwarding(sshd, level, System.out, System.err, resolver);
        SshServerMain.setupCommandFactory(sshd, level, System.out, System.err, shellFactory);
        List<SubsystemFactory> subsystems = SshServerMain.resolveServerSubsystems((ServerFactoryManager)sshd, level, System.out, System.err, resolver);
        if (GenericUtils.isNotEmpty(subsystems)) {
            if (logger.isInfoEnabled()) {
                logger.info("Setup subsystems={}", (Object)NamedResource.getNames(subsystems));
            }
            sshd.setSubsystemFactories(subsystems);
        }
        System.err.println("Starting SSHD on port " + port);
        sshd.start();
        Thread.sleep(Long.MAX_VALUE);
        System.err.println("Exiting after a very (very very) long time");
    }

    private static CommandFactory setupCommandFactory(SshServer sshd, Level level, PrintStream stdout, PrintStream stderr, ShellFactory shellFactory) {
        ScpCommandFactory scpFactory = shellFactory instanceof ScpCommandFactory ? (ScpCommandFactory)shellFactory : SshServerMain.createScpCommandFactory(level, stdout, stderr, null);
        sshd.setCommandFactory((CommandFactory)scpFactory);
        return scpFactory;
    }
}

