/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef H_DEBUG_PANIC_
#define H_DEBUG_PANIC_

#include "os/mynewt.h"

#if MYNEWT_VAL(DEBUG_PANIC_ENABLED)
#define DEBUG_PANIC() OS_CRASH()
#else
#define DEBUG_PANIC()
#endif

#if MYNEWT_VAL(DEBUG_PANIC_ENABLED)
#define DEBUG_ASSERT(expr) ((expr) ? (void)0 : OS_CRASH())
#else
#define DEBUG_ASSERT(expr)
#endif

#endif
