/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt.sun.tools.javac.api.JavacScope;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import jpt.sun.tools.javac.api.JavacTrees;
import jpt.sun.tools.javac.code.Kinds;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Symtab;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.code.Types;
import jpt.sun.tools.javac.comp.AttrContext;
import jpt.sun.tools.javac.comp.Enter;
import jpt.sun.tools.javac.comp.Env;
import jpt.sun.tools.javac.comp.Resolve;
import jpt.sun.tools.javac.model.JavacElements;
import jpt.sun.tools.javac.model.JavacTypes;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Names;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.RecordComponentElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.TypeParameterElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.type.TypeVariable;
import jpt30.lang.model.util.ElementFilter;
import jpt30.lang.model.util.Elements;
import jpt30.lang.model.util.SimpleElementVisitor9;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CodeStyleUtils;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.java.source.base.SourceLevelUtils;
import org.netbeans.modules.java.source.builder.ElementsService;
import org.openide.util.Parameters;

public final class ElementUtilities {
    private static final ElementAcceptor ALL_ACCEPTOR = (e, type) -> true;
    private final Context ctx;
    private final ElementsService delegate;
    private final CompilationInfo info;
    private static final Object ORDINARY_SCOPE_TYPE;
    private static final Logger LOG;
    private static final Set<Modifier> NOT_OVERRIDABLE;

    ElementUtilities(@NonNull CompilationInfo info) {
        this(info.impl.getJavacTask(), info);
    }

    ElementUtilities(@NonNull JavacTaskImpl jt) {
        this(jt, null);
    }

    private ElementUtilities(@NonNull JavacTaskImpl jt, @NullAllowed CompilationInfo info) {
        this.ctx = jt.getContext();
        this.delegate = ElementsService.instance(this.ctx);
        this.info = info;
    }

    public TypeElement enclosingTypeElement(Element element) throws IllegalArgumentException {
        return ElementUtilities.enclosingTypeElementImpl(element);
    }

    static TypeElement enclosingTypeElementImpl(Element element) throws IllegalArgumentException {
        if (element.getKind() == ElementKind.PACKAGE) {
            throw new IllegalArgumentException();
        }
        if ((element = element.getEnclosingElement()).getKind() == ElementKind.PACKAGE) {
            return null;
        }
        while (element != null && !element.getKind().isClass() && !element.getKind().isInterface()) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    public TypeElement outermostTypeElement(Element element) {
        return this.delegate.outermostTypeElement(element);
    }

    public Element getImplementationOf(ExecutableElement method, TypeElement origin) {
        return this.delegate.getImplementationOf(method, origin);
    }

    public boolean isSynthetic(Element element) {
        return (((Symbol)element).flags() & 0x1000L) != 0L || (((Symbol)element).flags() & 0x1000000000L) != 0L || (((Symbol)element).flags() & 0x1000000L) != 0L;
    }

    public boolean isOpen(ModuleElement element) {
        return ((Symbol.ModuleSymbol)element).flags.contains((Object)Symbol.ModuleFlags.OPEN);
    }

    public boolean overridesMethod(ExecutableElement element) {
        return this.delegate.overridesMethod(element);
    }

    public static String getBinaryName(TypeElement element) throws IllegalArgumentException {
        if (element instanceof Symbol.TypeSymbol) {
            return ((Symbol.TypeSymbol)((Object)element)).flatName().toString();
        }
        throw new IllegalArgumentException();
    }

    public Iterable<? extends Element> getMembers(TypeMirror type, ElementAcceptor acceptor) {
        ArrayList<Element> membersList = new ArrayList<Element>();
        HashMap<String, java.util.List<Element>> membersMap = new HashMap<String, java.util.List<Element>>();
        if (type != null) {
            if (acceptor == null) {
                acceptor = ALL_ACCEPTOR;
            }
            JavacElements elements = JavacElements.instance(this.ctx);
            JavacTypes types = JavacTypes.instance(this.ctx);
            switch (type.getKind()) {
                case DECLARED: 
                case UNION: 
                case INTERSECTION: {
                    TypeElement te = (TypeElement)((DeclaredType)type).asElement();
                    if (te == null) break;
                    for (Element element : elements.getAllMembers(te)) {
                        if (!acceptor.accept(element, type)) continue;
                        ElementUtilities.addIfNotHidden(element, membersList, membersMap, elements, types);
                    }
                    if (te.getKind().isClass() || te.getKind().isInterface() && SourceLevelUtils.allowDefaultMethods(Source.instance(this.ctx))) {
                        Symbol.VarSymbol varSymbol;
                        Symbol.VarSymbol thisPseudoMember = new Symbol.VarSymbol(262160L, Names.instance((Context)this.ctx)._this, (Type.ClassType)te.asType(), (Symbol.ClassSymbol)te);
                        if (acceptor.accept(thisPseudoMember, type)) {
                            ElementUtilities.addAlways(thisPseudoMember, membersList, membersMap);
                        }
                        if (te.getSuperclass().getKind() == TypeKind.DECLARED && acceptor.accept(varSymbol = new Symbol.VarSymbol(262160L, Names.instance((Context)this.ctx)._super, (Type.ClassType)te.getSuperclass(), (Symbol.ClassSymbol)te), type)) {
                            ElementUtilities.addAlways(varSymbol, membersList, membersMap);
                        }
                    }
                }
                case BOOLEAN: 
                case BYTE: 
                case CHAR: 
                case DOUBLE: 
                case FLOAT: 
                case INT: 
                case LONG: 
                case SHORT: 
                case VOID: {
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = List.of((Type)type);
                    t = new Type.ClassType(t.getEnclosingType(), list, t.tsym);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Names.instance((Context)this.ctx)._class, t, ((Type)type).tsym);
                    if (!acceptor.accept(classPseudoMember, type)) break;
                    ElementUtilities.addAlways(classPseudoMember, membersList, membersMap);
                    break;
                }
                case ARRAY: {
                    for (Element element : elements.getAllMembers((TypeElement)((Object)((Type)type).tsym))) {
                        if (!acceptor.accept(element, type)) continue;
                        ElementUtilities.addAlways(element, membersList, membersMap);
                    }
                    Type t = Symtab.instance((Context)this.ctx).classType;
                    List<Type> list = List.of((Type)type);
                    Symbol.VarSymbol classPseudoMember = new Symbol.VarSymbol(25L, Names.instance((Context)this.ctx)._class, t = new Type.ClassType(t.getEnclosingType(), list, t.tsym), ((Type)type).tsym);
                    if (!acceptor.accept(classPseudoMember, type)) break;
                    ElementUtilities.addAlways(classPseudoMember, membersList, membersMap);
                }
            }
        }
        return membersList;
    }

    @NonNull
    public Map<? extends Element, Scope> findElementsAndOrigins(@NonNull Scope scope, ElementAcceptor acceptor) {
        Parameters.notNull("scope", scope);
        HashMap<Element, Scope> result = new HashMap<Element, Scope>();
        if (acceptor == null) {
            acceptor = ALL_ACCEPTOR;
        }
        HashMap members = null;
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        ArrayDeque<Scope> outerScopes = new ArrayDeque<Scope>();
        ArrayDeque visibleEls = new ArrayDeque();
        Object current = null;
        while (scope != null) {
            TypeElement cls = scope.getEnclosingClass();
            Object e = null;
            if (cls != null) {
                ExecutableElement ee = scope.getEnclosingMethod();
                e = ee != null && ee.getEnclosingElement() != cls ? ee : cls;
            }
            if (e != current) {
                members = new HashMap();
                outerScopes.push(scope);
                visibleEls.push(members);
                current = e;
            }
            if (cls != null) {
                for (Element element : scope.getLocalElements()) {
                    if (!acceptor.accept(element, null)) continue;
                    ElementUtilities.addIfNotHidden(element, null, members, elements, types);
                }
                TypeMirror type = cls.asType();
                for (Element member : elements.getAllMembers(cls)) {
                    if (!acceptor.accept(member, type)) continue;
                    ElementUtilities.addIfNotHidden(member, null, members, elements, types);
                }
            } else {
                for (Element element : scope.getLocalElements()) {
                    if (element.getKind().isClass() || element.getKind().isInterface() || element.getEnclosingElement() == null || !acceptor.accept(element, element.getEnclosingElement().asType())) continue;
                    ElementUtilities.addIfNotHidden(element, null, members, elements, types);
                }
            }
            scope = scope.getEnclosingScope();
        }
        while (!outerScopes.isEmpty()) {
            Scope x = (Scope)outerScopes.pop();
            Collection vals = ((Map)visibleEls.pop()).values();
            for (java.util.List col : vals) {
                for (Element e : col) {
                    result.put(e, x);
                }
            }
        }
        return result;
    }

    private static void addAlways(Element element, java.util.List<Element> list, Map<String, java.util.List<Element>> members) {
        String name = element.getSimpleName().toString();
        members.computeIfAbsent(name, e -> new ArrayList()).add(element);
        if (list != null) {
            list.add(element);
        }
    }

    private static <E extends Element> void addIfNotHidden(E element, java.util.List<E> list, Map<String, java.util.List<E>> map, Elements elements, jpt30.lang.model.util.Types types) {
        String name = element.getSimpleName().toString();
        java.util.List<E> namedMembers = map.get(name);
        if (namedMembers != null) {
            if (ElementUtilities.isHidden(element, namedMembers, elements, types)) {
                return;
            }
        } else {
            namedMembers = new ArrayList();
            map.put(name, namedMembers);
        }
        if (list != null) {
            list.add(element);
        }
        namedMembers.add(element);
    }

    public Iterable<? extends Element> getLocalMembersAndVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList membersList = new ArrayList();
        HashMap membersMap = new HashMap();
        if (acceptor == null) {
            acceptor = ALL_ACCEPTOR;
        }
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        while (scope != null) {
            TypeElement cls = scope.getEnclosingClass();
            if (cls != null) {
                for (Element element : scope.getLocalElements()) {
                    if (!acceptor.accept(element, null)) continue;
                    ElementUtilities.addIfNotHidden(element, membersList, membersMap, elements, types);
                }
                TypeMirror type = cls.asType();
                for (Element member : elements.getAllMembers(cls)) {
                    if (!acceptor.accept(member, type)) continue;
                    ElementUtilities.addIfNotHidden(member, membersList, membersMap, elements, types);
                }
            } else {
                for (Element element : scope.getLocalElements()) {
                    if (element.getKind().isClass() || element.getKind().isInterface() || element.getEnclosingElement() == null || !acceptor.accept(element, element.getEnclosingElement().asType())) continue;
                    ElementUtilities.addIfNotHidden(element, membersList, membersMap, elements, types);
                }
            }
            scope = scope.getEnclosingScope();
        }
        return membersList;
    }

    public Iterable<? extends Element> getLocalVars(Scope scope, ElementAcceptor acceptor) {
        ArrayList membersList = new ArrayList();
        HashMap membersMap = new HashMap();
        if (acceptor == null) {
            acceptor = ALL_ACCEPTOR;
        }
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        while (scope != null && scope.getEnclosingClass() != null) {
            for (Element element : scope.getLocalElements()) {
                if (!acceptor.accept(element, null)) continue;
                ElementUtilities.addIfNotHidden(element, membersList, membersMap, elements, types);
            }
            scope = scope.getEnclosingScope();
        }
        return membersList;
    }

    public Iterable<? extends TypeElement> getGlobalTypes(ElementAcceptor acceptor) {
        ArrayList membersList = new ArrayList();
        HashMap membersMap = new HashMap();
        if (acceptor == null) {
            acceptor = ALL_ACCEPTOR;
        }
        JavacTrees trees = JavacTrees.instance(this.ctx);
        JavacElements elements = JavacElements.instance(this.ctx);
        JavacTypes types = JavacTypes.instance(this.ctx);
        for (CompilationUnitTree unit : Collections.singletonList(this.info.getCompilationUnit())) {
            TreePath path = new TreePath(unit);
            Scope scope = ((Trees)trees).getScope(path);
            while (scope instanceof JavacScope && ((JavacScope)scope).getScopeType() == ORDINARY_SCOPE_TYPE) {
                for (Element element : scope.getLocalElements()) {
                    if (!element.getKind().isClass() && !element.getKind().isInterface() || !acceptor.accept(element, null)) continue;
                    ElementUtilities.addIfNotHidden((TypeElement)element, membersList, membersMap, elements, types);
                }
                scope = scope.getEnclosingScope();
            }
            Element element = ((Trees)trees).getElement(path);
            if (element != null && element.getKind() == ElementKind.PACKAGE) {
                for (Element element2 : element.getEnclosedElements()) {
                    if (!acceptor.accept(element2, null)) continue;
                    ElementUtilities.addIfNotHidden((TypeElement)element2, membersList, membersMap, elements, types);
                }
            }
            while (scope != null) {
                for (Element element3 : scope.getLocalElements()) {
                    if (!element3.getKind().isClass() && !element3.getKind().isInterface() || !acceptor.accept(element3, null)) continue;
                    ElementUtilities.addIfNotHidden((TypeElement)element3, membersList, membersMap, elements, types);
                }
                scope = scope.getEnclosingScope();
            }
        }
        return membersList;
    }

    private static boolean isHidden(Element member, java.util.List<? extends Element> members, Elements elements, jpt30.lang.model.util.Types types) {
        ListIterator<? extends Element> it = members.listIterator();
        while (it.hasNext()) {
            Element hider = it.next();
            if (hider == member) {
                return true;
            }
            if (elements.hides(member, hider)) {
                it.remove();
                continue;
            }
            if (member instanceof VariableElement && hider instanceof VariableElement && (!member.getKind().isField() || hider.getKind().isField())) {
                return true;
            }
            TypeMirror memberType = member.asType();
            TypeMirror hiderType = hider.asType();
            if (memberType.getKind() == TypeKind.EXECUTABLE && hiderType.getKind() == TypeKind.EXECUTABLE) {
                if (!types.isSubsignature((ExecutableType)hiderType, (ExecutableType)memberType)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public CharSequence getElementName(Element el, boolean fqn) {
        if (el == null || el.asType().getKind() == TypeKind.NONE) {
            return "";
        }
        return (CharSequence)new ElementNameVisitor().visit(el, fqn);
    }

    public boolean isLocal(Element element) {
        return this.delegate.isLocal(element);
    }

    public boolean alreadyDefinedIn(CharSequence name, ExecutableType method, TypeElement enclClass) {
        return this.delegate.alreadyDefinedIn(name, method, enclClass);
    }

    public boolean isMemberOf(Element e, TypeElement type) {
        return this.delegate.isMemberOf(e, type);
    }

    public ExecutableElement getOverriddenMethod(ExecutableElement method) {
        return this.delegate.getOverriddenMethod(method);
    }

    public boolean implementsMethod(ExecutableElement element) {
        return this.delegate.implementsMethod(element);
    }

    public java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl) {
        return this.findUnimplementedMethods(impl, impl, false);
    }

    public java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl, boolean includeDefaults) {
        return this.findUnimplementedMethods(impl, impl, includeDefaults);
    }

    public java.util.List<? extends ExecutableElement> findOverridableMethods(TypeElement type) {
        ArrayList<ExecutableElement> overridable = new ArrayList<ExecutableElement>();
        EnumSet<Modifier> notOverridable = EnumSet.copyOf(NOT_OVERRIDABLE);
        if (!type.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            notOverridable.add(Modifier.ABSTRACT);
        }
        DeclaredType dt = (DeclaredType)type.asType();
        JavacTypes types = JavacTypes.instance(this.ctx);
        HashSet<CallSite> typeStrings = new HashSet<CallSite>();
        Tree.Kind kind = this.info.getTrees().getTree(type).getKind();
        for (ExecutableElement ee : ElementFilter.methodsIn(this.info.getElements().getAllMembers(type))) {
            TypeMirror methodType = types.erasure(types.asMemberOf(dt, ee));
            String methodTypeString = ee.getSimpleName().toString() + methodType.toString();
            if (typeStrings.contains(methodTypeString)) continue;
            boolean replaceable = kind == Tree.Kind.RECORD && this.isSynthetic(ee);
            EnumSet<Modifier> set = EnumSet.copyOf(notOverridable);
            set.removeAll(ee.getModifiers());
            if (set.size() != notOverridable.size() || this.overridesPackagePrivateOutsidePackage(ee, type) || !replaceable && this.isOverridden(ee, type)) continue;
            overridable.add(ee);
            if (!ee.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            typeStrings.add((CallSite)((Object)methodTypeString));
        }
        Collections.reverse(overridable);
        return overridable;
    }

    public boolean hasGetter(TypeElement type, VariableElement field, CodeStyle codeStyle) {
        boolean isBoolean = field.asType().getKind() == TypeKind.BOOLEAN;
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        String name = CodeStyleUtils.computeGetterName(field.getSimpleName(), isBoolean, isStatic, codeStyle);
        return this.delegate.alreadyDefinedIn(name, field.asType(), List.nil(), type);
    }

    public boolean hasSetter(TypeElement type, VariableElement field, CodeStyle codeStyle) {
        boolean isStatic = field.getModifiers().contains((Object)Modifier.STATIC);
        String name = CodeStyleUtils.computeSetterName(field.getSimpleName(), isStatic, codeStyle);
        return this.delegate.alreadyDefinedIn(name, this.info.getTypes().getNoType(TypeKind.VOID), List.of(field.asType()), type);
    }

    public boolean isErroneous(@NullAllowed Element e) {
        if (e == null) {
            return true;
        }
        if (e.getKind() == ElementKind.MODULE && ((Symbol)e).kind == Kinds.Kind.ERR) {
            return true;
        }
        TypeMirror type = e.asType();
        if (type == null) {
            return false;
        }
        if (type.getKind() == TypeKind.ERROR || type.getKind() == TypeKind.OTHER) {
            return true;
        }
        return type instanceof Type && ((Type)type).isErroneous();
    }

    public boolean isEffectivelyFinal(VariableElement e) {
        return (((Symbol)((Object)e)).flags() & 0x20000000010L) != 0L;
    }

    @CheckForNull
    public Element findElement(@NonNull String description) {
        TypeElement el;
        if (description.contains("(")) {
            String methodFullName = description.substring(0, description.indexOf(40));
            String className = methodFullName.substring(0, methodFullName.lastIndexOf(46));
            TypeElement clazz = this.info.getElements().getTypeElement(className);
            if (clazz == null) {
                return null;
            }
            String methodSimpleName = methodFullName.substring(methodFullName.lastIndexOf(46) + 1);
            boolean constructor = clazz.getSimpleName().contentEquals(methodSimpleName);
            String parameters = description.substring(description.indexOf(40) + 1, description.lastIndexOf(41) + 1);
            int lastParamStart = 0;
            int angleDepth = 0;
            ArrayList<TypeMirror> types = new ArrayList<TypeMirror>();
            block6: for (int paramIndex = 0; paramIndex < parameters.length(); ++paramIndex) {
                switch (parameters.charAt(paramIndex)) {
                    case '<': {
                        ++angleDepth;
                        continue block6;
                    }
                    case '>': {
                        --angleDepth;
                        continue block6;
                    }
                    case ',': {
                        if (angleDepth > 0) continue block6;
                    }
                    case ')': {
                        if (paramIndex <= lastParamStart) continue block6;
                        String type = parameters.substring(lastParamStart, paramIndex).replace("...", "[]");
                        types.add(this.info.getTypes().erasure(this.info.getTreeUtilities().parseType(type, this.info.getTopLevelElements().get(0))));
                        lastParamStart = paramIndex + 1;
                    }
                }
            }
            block7: for (ExecutableElement ee : constructor ? ElementFilter.constructorsIn(clazz.getEnclosedElements()) : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                if (!constructor && !ee.getSimpleName().contentEquals(methodSimpleName) || ee.getParameters().size() != types.size()) continue;
                Iterator<? extends TypeMirror> real = ((ExecutableType)this.info.getTypes().erasure(ee.asType())).getParameterTypes().iterator();
                Iterator expected = types.iterator();
                while (real.hasNext() && expected.hasNext()) {
                    if (this.info.getTypes().isSameType(real.next(), (TypeMirror)expected.next())) continue;
                    continue block7;
                }
                assert (real.hasNext() == expected.hasNext());
                return ee;
            }
        }
        if ((el = this.info.getElements().getTypeElement(description)) != null) {
            return el;
        }
        int dot = description.lastIndexOf(46);
        if (dot != -1) {
            String simpleName = description.substring(dot + 1);
            el = this.info.getElements().getTypeElement(description.substring(0, dot));
            if (el != null) {
                for (VariableElement var : ElementFilter.fieldsIn(el.getEnclosedElements())) {
                    if (!var.getSimpleName().contentEquals(simpleName)) continue;
                    return var;
                }
            }
        }
        return null;
    }

    public ExecutableElement getDescriptorElement(TypeElement origin) {
        Symbol sym;
        Types types = Types.instance(this.info.impl.getJavacTask().getContext());
        if (types.isFunctionalInterface((Symbol.TypeSymbol)((Object)origin)) && (sym = types.findDescriptorSymbol((Symbol.TypeSymbol)((Object)origin))) != null && sym.getKind() == ElementKind.METHOD) {
            return (ExecutableElement)((Object)sym);
        }
        return null;
    }

    public Collection<? extends Element> getLinkedRecordElements(Element forElement) {
        ExecutableElement executableElement;
        Parameters.notNull("forElement", forElement);
        Object record = null;
        Name componentName = null;
        switch (forElement.getKind()) {
            case FIELD: {
                Element enclosing = forElement.getEnclosingElement();
                if (enclosing.getKind() != ElementKind.RECORD) break;
                record = (TypeElement)enclosing;
                componentName = forElement.getSimpleName();
                break;
            }
            case PARAMETER: {
                RecordComponentElement component;
                int n;
                Object recordType;
                ExecutableElement executableElement2;
                Element enclosingType;
                Element enclosing = forElement.getEnclosingElement();
                if (enclosing.getKind() != ElementKind.CONSTRUCTOR || (enclosingType = enclosing.getEnclosingElement()).getKind() != ElementKind.RECORD || (executableElement2 = this.recordCanonicalConstructor((TypeElement)(recordType = (TypeElement)enclosingType))) == null || !executableElement2.equals(enclosing) || (n = executableElement2.getParameters().indexOf(forElement)) < 0 || n >= recordType.getRecordComponents().size() || !(component = recordType.getRecordComponents().get(n)).getSimpleName().equals(forElement.getSimpleName())) break;
                record = recordType;
                componentName = component.getSimpleName();
                break;
            }
            case METHOD: {
                Element enclosing = forElement.getEnclosingElement();
                ExecutableElement method = (ExecutableElement)forElement;
                if (!method.getParameters().isEmpty() || enclosing.getKind() != ElementKind.RECORD) break;
                Object recordType = (TypeElement)enclosing;
                for (RecordComponentElement recordComponentElement : recordType.getRecordComponents()) {
                    if (!forElement.equals(recordComponentElement.getAccessor())) continue;
                    record = recordType;
                    componentName = recordComponentElement.getSimpleName();
                }
                break;
            }
            case RECORD_COMPONENT: {
                record = (TypeElement)forElement.getEnclosingElement();
                componentName = forElement.getSimpleName();
            }
        }
        if (record == null) {
            return Collections.singleton(forElement);
        }
        RecordComponentElement component = null;
        int componentIdx = 0;
        for (RecordComponentElement recordComponentElement : record.getRecordComponents()) {
            if (recordComponentElement.getSimpleName().equals(componentName)) {
                component = recordComponentElement;
                break;
            }
            ++componentIdx;
        }
        if (component == null) {
            return Collections.singleton(forElement);
        }
        HashSet<Element> result = new HashSet<Element>();
        result.add(component);
        result.add(component.getAccessor());
        for (Element element : record.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD || !element.getSimpleName().equals(componentName)) continue;
            result.add(element);
            break;
        }
        if ((executableElement = this.recordCanonicalConstructor((TypeElement)record)) != null && componentIdx < executableElement.getParameters().size()) {
            result.add(executableElement.getParameters().get(componentIdx));
        }
        return result;
    }

    private ExecutableElement recordCanonicalConstructor(TypeElement recordType) {
        Supplier<ExecutableElement> fallback = () -> {
            java.util.List<? extends RecordComponentElement> recordComponents = recordType.getRecordComponents();
            for (ExecutableElement c : ElementFilter.constructorsIn(recordType.getEnclosedElements())) {
                boolean componentMatches;
                TypeMirror parameterType;
                TypeMirror componentType;
                if (recordComponents.size() != c.getParameters().size()) continue;
                Iterator<? extends RecordComponentElement> componentIt = recordComponents.iterator();
                Iterator<? extends VariableElement> parameterIt = c.getParameters().iterator();
                for (componentMatches = true; componentIt.hasNext() && parameterIt.hasNext() && componentMatches; componentMatches &= this.info.getTypes().isSameType(componentType, parameterType)) {
                    componentType = componentIt.next().asType();
                    parameterType = parameterIt.next().asType();
                }
                if (!componentMatches) continue;
                return c;
            }
            return null;
        };
        return ElementFilter.constructorsIn(recordType.getEnclosedElements()).stream().filter(this.info.getElements()::isCanonicalConstructor).findAny().orElseGet(fallback);
    }

    @NonNull
    public Set<PackageElement> transitivelyExportedPackages(@NonNull ModuleElement module) {
        Parameters.notNull("module", module);
        ModuleElement currentModule = this.info.getModule();
        ArrayList<ModuleElement> todo = new ArrayList<ModuleElement>();
        HashSet<ModuleElement> seen = new HashSet<ModuleElement>();
        HashSet<PackageElement> exported = new HashSet<PackageElement>();
        todo.add(module);
        while (!todo.isEmpty()) {
            ModuleElement currentlyProcessing = (ModuleElement)todo.remove(todo.size() - 1);
            if (!seen.add(currentlyProcessing)) continue;
            for (ModuleElement.ExportsDirective exports : ElementFilter.exportsIn(currentlyProcessing.getDirectives())) {
                if (exports.getTargetModules() != null && !exports.getTargetModules().contains(currentModule)) continue;
                exported.add(exports.getPackage());
            }
            for (ModuleElement.RequiresDirective requires : ElementFilter.requiresIn(currentlyProcessing.getDirectives())) {
                if (!requires.isTransitive()) continue;
                todo.add(requires.getDependency());
            }
        }
        return exported;
    }

    private java.util.List<? extends ExecutableElement> findUnimplementedMethods(TypeElement impl, TypeElement element, boolean includeDefaults) {
        ArrayList<ExecutableElement> undef = new ArrayList<ExecutableElement>();
        JavacTypes types = JavacTypes.instance(this.ctx);
        Types implTypes = Types.instance(this.ctx);
        DeclaredType implType = (DeclaredType)impl.asType();
        if (element.getKind().isInterface() || element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            for (Element element2 : element.getEnclosedElements()) {
                if (element2.getKind() != ElementKind.METHOD || (!element.getKind().isInterface() ? !element2.getModifiers().contains((Object)Modifier.ABSTRACT) : element2.getModifiers().contains((Object)Modifier.STATIC))) continue;
                ExecutableElement ee = (ExecutableElement)element2;
                ExecutableElement executableElement = (ExecutableElement)this.getImplementationOf(ee, impl);
                if (executableElement == null) {
                    if (implTypes.asSuper((Type)((Object)implType), (Symbol)ee.getEnclosingElement()) == null) continue;
                    undef.add(ee);
                    continue;
                }
                if (impl == element || implTypes.asSuper((Type)((Object)implType), (Symbol)ee.getEnclosingElement()) == null) continue;
                if (executableElement == ee) {
                    undef.add(ee);
                    continue;
                }
                if (!includeDefaults || !executableElement.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                undef.add(executableElement);
            }
        }
        for (TypeMirror typeMirror : types.directSupertypes(element.asType())) {
            for (ExecutableElement executableElement : this.findUnimplementedMethods(impl, (TypeElement)((DeclaredType)typeMirror).asElement(), includeDefaults)) {
                boolean exists = false;
                ExecutableType eeType = (ExecutableType)types.asMemberOf(implType, executableElement);
                for (ExecutableElement existing : undef) {
                    block13: {
                        Symbol.MethodSymbol msExisting;
                        block11: {
                            Type mt;
                            DeclaredType subType;
                            TypeMirror eeReturnType;
                            TypeMirror existingReturnType;
                            block12: {
                                ExecutableType existingType;
                                if (!existing.getSimpleName().contentEquals(executableElement.getSimpleName()) || !types.isSubsignature(existingType = (ExecutableType)types.asMemberOf(implType, existing), eeType)) continue;
                                existingReturnType = existingType.getReturnType();
                                eeReturnType = eeType.getReturnType();
                                msExisting = (Symbol.MethodSymbol)existing;
                                if (types.isSubtype(existingReturnType, eeReturnType)) break block11;
                                if (!types.isSubtype(eeReturnType, existingReturnType)) break block12;
                                undef.remove(existing);
                                undef.add(executableElement);
                                break block13;
                            }
                            if (existingReturnType.getKind() != TypeKind.DECLARED || eeReturnType.getKind() != TypeKind.DECLARED) break block13;
                            Env<AttrContext> env = Enter.instance(this.ctx).getClassEnv((Symbol.TypeSymbol)((Object)impl));
                            DeclaredType declaredType = subType = env != null ? this.findCommonSubtype((DeclaredType)existingReturnType, (DeclaredType)eeReturnType, env) : null;
                            if (subType == null) break block13;
                            undef.remove(existing);
                            Symbol.MethodSymbol ms = msExisting.clone((Symbol)((Object)impl));
                            ms.type = mt = implTypes.createMethodTypeWithReturn(ms.type, (Type)((Object)subType));
                            undef.add(ms);
                            break block13;
                        }
                        if (!msExisting.overrides((Symbol.MethodSymbol)executableElement, (Symbol.TypeSymbol)((Object)impl), implTypes, true)) {
                            if (existing.getEnclosingElement().getKind().isClass()) {
                                exists = true;
                                break;
                            }
                            if (!element.getKind().isClass() || !executableElement.getEnclosingElement().getKind().isInterface() || existing.getModifiers().contains((Object)Modifier.DEFAULT) || executableElement.getModifiers().contains((Object)Modifier.DEFAULT)) break;
                            exists = true;
                            break;
                        }
                    }
                    exists = true;
                    break;
                }
                if (exists) continue;
                undef.add(executableElement);
            }
        }
        if (!includeDefaults && element.getKind() == ElementKind.INTERFACE) {
            Iterator it = undef.iterator();
            while (it.hasNext()) {
                ExecutableElement executableElement = (ExecutableElement)it.next();
                if (!executableElement.getModifiers().contains((Object)Modifier.DEFAULT)) continue;
                it.remove();
            }
        }
        return undef;
    }

    private DeclaredType findCommonSubtype(DeclaredType type1, DeclaredType type2, Env<AttrContext> env) {
        java.util.List<DeclaredType> subtypes1 = this.getSubtypes(type1, env);
        java.util.List<DeclaredType> subtypes2 = this.getSubtypes(type2, env);
        if (subtypes1 == null || subtypes2 == null) {
            return null;
        }
        jpt30.lang.model.util.Types types = this.info.getTypes();
        for (DeclaredType subtype1 : subtypes1) {
            for (DeclaredType subtype2 : subtypes2) {
                if (types.isSubtype(subtype1, subtype2)) {
                    return subtype1;
                }
                if (!types.isSubtype(subtype2, subtype1)) continue;
                return subtype2;
            }
        }
        return null;
    }

    private java.util.List<DeclaredType> getSubtypes(DeclaredType baseType, Env<AttrContext> env) {
        LinkedList<DeclaredType> subtypes = new LinkedList<DeclaredType>();
        HashSet<TypeElement> elems = new HashSet<TypeElement>();
        LinkedList<DeclaredType> bases = new LinkedList<DeclaredType>();
        bases.add(baseType);
        ClassIndex index = this.info.getClasspathInfo().getClassIndex();
        jpt30.lang.model.util.Types types = this.info.getTypes();
        Resolve resolve = Resolve.instance(this.ctx);
        while (!bases.isEmpty()) {
            DeclaredType head = (DeclaredType)bases.remove();
            TypeElement elem = (TypeElement)head.asElement();
            if (!elems.add(elem)) continue;
            subtypes.add(head);
            java.util.List<? extends TypeMirror> tas = head.getTypeArguments();
            boolean isRaw = !tas.iterator().hasNext();
            Set<ElementHandle<TypeElement>> implementors = index.getElements(ElementHandle.create(elem), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.allOf(ClassIndex.SearchScope.class));
            if (implementors == null) {
                return null;
            }
            block1: for (ElementHandle<TypeElement> eh : implementors) {
                TypeElement e = eh.resolve(this.info);
                if (e == null || !resolve.isAccessible(env, (Symbol.TypeSymbol)((Object)e))) continue;
                if (isRaw) {
                    DeclaredType dt = types.getDeclaredType(e, new TypeMirror[0]);
                    bases.add(dt);
                    continue;
                }
                HashMap<Element, TypeMirror> map = new HashMap<Element, TypeMirror>();
                TypeMirror sup = e.getSuperclass();
                if (sup.getKind() == TypeKind.DECLARED && ((DeclaredType)sup).asElement() == elem) {
                    DeclaredType dt = (DeclaredType)sup;
                    Iterator<? extends TypeMirror> iterator = tas.iterator();
                    Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                    while (it.hasNext() && iterator.hasNext()) {
                        TypeMirror stm;
                        TypeMirror basetm = iterator.next();
                        if (basetm == (stm = it.next())) continue;
                        if (stm.getKind() != TypeKind.TYPEVAR) continue block1;
                        map.put(((TypeVariable)stm).asElement(), basetm);
                    }
                    if (it.hasNext() != iterator.hasNext()) {
                        continue;
                    }
                } else {
                    for (TypeMirror typeMirror : e.getInterfaces()) {
                        if (((DeclaredType)typeMirror).asElement() != elem) continue;
                        DeclaredType dt = (DeclaredType)typeMirror;
                        Iterator<? extends TypeMirror> ittas = tas.iterator();
                        Iterator<? extends TypeMirror> it = dt.getTypeArguments().iterator();
                        while (it.hasNext() && ittas.hasNext()) {
                            TypeMirror stm;
                            TypeMirror basetm = ittas.next();
                            if (basetm == (stm = it.next())) continue;
                            if (stm.getKind() != TypeKind.TYPEVAR) continue block1;
                            map.put(((TypeVariable)stm).asElement(), basetm);
                        }
                        if (it.hasNext() != ittas.hasNext()) continue block1;
                    }
                }
                bases.add(this.getDeclaredType(e, map, types));
            }
        }
        return subtypes;
    }

    private DeclaredType getDeclaredType(TypeElement e, HashMap<? extends Element, ? extends TypeMirror> map, jpt30.lang.model.util.Types types) {
        java.util.List<? extends TypeParameterElement> tpes = e.getTypeParameters();
        TypeMirror[] targs = new TypeMirror[tpes.size()];
        int i = 0;
        for (TypeParameterElement typeParameterElement : tpes) {
            TypeMirror t = map.get(typeParameterElement);
            targs[i++] = t != null ? t : typeParameterElement.asType();
        }
        Element encl = e.getEnclosingElement();
        if ((encl.getKind().isClass() || encl.getKind().isInterface()) && !((TypeElement)encl).getTypeParameters().isEmpty()) {
            return types.getDeclaredType(this.getDeclaredType((TypeElement)encl, map, types), e, targs);
        }
        return types.getDeclaredType(e, targs);
    }

    private boolean isOverridden(ExecutableElement methodBase, TypeElement origin) {
        Element impl = this.getImplementationOf(methodBase, origin);
        return impl != null && (impl != methodBase || origin == methodBase.getEnclosingElement());
    }

    private boolean overridesPackagePrivateOutsidePackage(ExecutableElement ee, TypeElement impl) {
        Name elemPackageName = this.getPackageName(ee);
        Name currentPackageName = this.getPackageName(impl);
        return !ee.getModifiers().contains((Object)Modifier.PRIVATE) && !ee.getModifiers().contains((Object)Modifier.PUBLIC) && !ee.getModifiers().contains((Object)Modifier.PROTECTED) && !currentPackageName.contentEquals(elemPackageName);
    }

    private Name getPackageName(Element e) {
        while (e.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e.getEnclosingElement()).getQualifiedName();
    }

    static {
        LOG = Logger.getLogger(ElementUtilities.class.getName());
        Object ordinary = null;
        try {
            ordinary = Enum.valueOf(Class.forName("jpt.sun.tools.javac.api.JavacScope$ScopeType"), "ORDINARY");
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        ORDINARY_SCOPE_TYPE = ordinary;
        NOT_OVERRIDABLE = EnumSet.of(Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE);
    }

    public static interface ElementAcceptor {
        public boolean accept(Element var1, TypeMirror var2);
    }

    private static class ElementNameVisitor
    extends SimpleElementVisitor9<StringBuilder, Boolean> {
        private ElementNameVisitor() {
            super(new StringBuilder());
        }

        @Override
        public StringBuilder visitExecutable(ExecutableElement e, Boolean p) {
            if (p != Boolean.TRUE || e.getEnclosingElement() == null) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(e.getSimpleName());
            }
            return e.getEnclosingElement().accept(this, p).append(".").append(e.getSimpleName());
        }

        @Override
        public StringBuilder visitVariable(VariableElement e, Boolean p) {
            if (p != Boolean.TRUE || e.getEnclosingElement() == null) {
                return ((StringBuilder)this.DEFAULT_VALUE).append(e.getSimpleName());
            }
            return e.getEnclosingElement().accept(this, p).append(".").append(e.getSimpleName());
        }

        @Override
        public StringBuilder visitPackage(PackageElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitType(TypeElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitModule(ModuleElement e, Boolean p) {
            return ((StringBuilder)this.DEFAULT_VALUE).append((p != false ? e.getQualifiedName() : e.getSimpleName()).toString());
        }

        @Override
        public StringBuilder visitRecordComponent(RecordComponentElement e, Boolean p) {
            return this.visitVariable((VariableElement)((Object)e), p);
        }
    }
}

