/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.resource;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.components.RequiredPermission;

public class RestrictedComponentsAuthorizableFactory {
    private static final Authorizable RESTRICTED_COMPONENTS_AUTHORIZABLE = new Authorizable(){

        public Authorizable getParentAuthorizable() {
            return null;
        }

        public Resource getResource() {
            return ResourceFactory.getRestrictedComponentsResource();
        }
    };

    public static Authorizable getRestrictedComponentsAuthorizable() {
        return RESTRICTED_COMPONENTS_AUTHORIZABLE;
    }

    public static Authorizable getRestrictedComponentsAuthorizable(final RequiredPermission requiredPermission) {
        return new Authorizable(){

            public Authorizable getParentAuthorizable() {
                return RESTRICTED_COMPONENTS_AUTHORIZABLE;
            }

            public Resource getResource() {
                return ResourceFactory.getRestrictedComponentsResource(requiredPermission);
            }

            public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
                if (user == null) {
                    return AuthorizationResult.denied((String)"Unknown user.");
                }
                AuthorizationResult resourceResult = super.checkAuthorization(authorizer, action, user, resourceContext);
                if (AuthorizationResult.Result.Denied.equals((Object)resourceResult.getResult())) {
                    return this.getParentAuthorizable().checkAuthorization(authorizer, action, user, resourceContext);
                }
                return resourceResult;
            }

            public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
                if (user == null) {
                    throw new AccessDeniedException("Unknown user.");
                }
                try {
                    super.authorize(authorizer, action, user, resourceContext);
                }
                catch (AccessDeniedException resourceDenied) {
                    try {
                        this.getParentAuthorizable().authorize(authorizer, action, user, resourceContext);
                    }
                    catch (AccessDeniedException policiesDenied) {
                        throw resourceDenied;
                    }
                }
            }
        };
    }

    public static Set<Authorizable> getRestrictedComponentsAuthorizable(Class<?> configurableComponentClass) {
        HashSet<Authorizable> authorizables = new HashSet<Authorizable>();
        Restricted restricted = configurableComponentClass.getAnnotation(Restricted.class);
        if (restricted != null) {
            Restriction[] restrictions = restricted.restrictions();
            if (restrictions != null && restrictions.length > 0) {
                Arrays.stream(restrictions).forEach(restriction -> authorizables.add(RestrictedComponentsAuthorizableFactory.getRestrictedComponentsAuthorizable(restriction.requiredPermission())));
            } else {
                authorizables.add(RestrictedComponentsAuthorizableFactory.getRestrictedComponentsAuthorizable());
            }
        }
        return authorizables;
    }
}

